package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;

import static android.content.Intent.FLAG_ACTIVITY_REORDER_TO_FRONT;
import static com.tenqube.visual_third.manager.AnswerManager.initFabric;
import static com.tenqube.visual_third.util.Utils.getCategoryIcon;
import static com.tenqube.visual_third.util.Utils.makeDialogPath;

/**
 * 서버에서 전달받은 Transaction 객체를 가지고 팝업을 띄운다.
 * 1. intent Transaction 객체
 * 2. validation 체크
 * 3. UI 구성
 */
public class TransactionPopupActivity extends Activity {

    public static final String ARG_TRANSACTION = "ARG_TRANSACTION";
    public static final String ACTION_TRAN_POPUP = "tenqube.intent.action.ACTION_TRAN_POPUP";

    private TextView appTitleTextView;
    private ImageView appImageView;

    public static void startActivity(Context context, TransactionPopupInfo transactionPopupInfo) throws ParameterException, AuthException {
        if(TextUtils.isEmpty(PrefManager.getInstance(context).loadStringValue(PrefManager.UID, "")))
            throw new AuthException("Need to sign up");

        if(transactionPopupInfo == null) throw new ParameterException("Check transactionPopupInfo.");

        if(!PrefManager.getInstance(context).isEnabled(PrefManager.TRAN_POPUP, true)) return;

        try {
            Intent intent = new Intent(context, TransactionPopupActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK |
                    Intent.FLAG_ACTIVITY_CLEAR_TOP|
                    Intent.FLAG_ACTIVITY_NO_HISTORY|
                    FLAG_ACTIVITY_REORDER_TO_FRONT);


            intent.putExtra(ARG_TRANSACTION, transactionPopupInfo);
            context.startActivity(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setAppInfo() {
        PackageManager packageManager = getApplicationContext().getPackageManager();

        try {
            appImageView = findViewById(R.id.icon);
            appTitleTextView = findViewById(R.id.title);

            String pkgName = getApplicationContext().getPackageName();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(pkgName, PackageManager.GET_META_DATA);
            Drawable icon = packageManager.getApplicationIcon(pkgName);
            appImageView.setImageDrawable(icon);
            String appName = (String) packageManager.getApplicationLabel(appInfo);
            appTitleTextView.setText(appName);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        try {

            final TransactionPopupInfo transactionPopupInfo = (TransactionPopupInfo) getIntent().getSerializableExtra(ARG_TRANSACTION);

            if(transactionPopupInfo == null ||
                    !PrefManager.getInstance(this).isEnabled(PrefManager.TRAN_POPUP, true)) {
                finish();
                return;
            }
            initFabric(TransactionPopupActivity.this);

            AnswerManager.onKeyMetric(new LogRequest("TransactionPopupActivity"));

            requestWindowFeature(Window.FEATURE_NO_TITLE);
            getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            setContentView(R.layout.activity_transaction_popup);

            DisplayMetrics dm = new DisplayMetrics();
            getWindowManager().getDefaultDisplay().getMetrics(dm);

            setAppInfo();

            // 팝업 뜨는경우 브로드캐스트 해주기
            TextView companyTitleTextView = (TextView) findViewById(R.id.company_title);
            companyTitleTextView.setText(transactionPopupInfo.getCompanyTitle());

            TextView companyAddressTextView = (TextView) findViewById(R.id.company_address);
            companyAddressTextView.setVisibility(TextUtils.isEmpty(transactionPopupInfo.getCompanyAddress()) ?
                    View.GONE
                    :
                    View.VISIBLE);

            companyAddressTextView.setText(transactionPopupInfo.getCompanyAddress());

            TextView spentDateTextView = (TextView) findViewById(R.id.spent_date);
            spentDateTextView.setText(transactionPopupInfo.getSpentDate());

            TextView paymentTextView = (TextView) findViewById(R.id.payment);
            paymentTextView.setText(transactionPopupInfo.getPayment());

            TextView installmentTextView = (TextView) findViewById(R.id.installment);
            installmentTextView.setText(transactionPopupInfo.getInstallmentStr());

            TextView spentMoneyTextView = (TextView) findViewById(R.id.spent_money);
            spentMoneyTextView.setText(transactionPopupInfo.getSpentMoneyStr());

            FrameLayout adContainer = findViewById(R.id.adContainer);

            View line = findViewById(R.id.line2);

            View adView = AdManager.getInstance(getApplicationContext()).getAdView();
            if(adView != null) {
                line.setVisibility(View.GONE);
                adContainer.removeAllViews();
                if(adView.getParent() != null) {
                    ((ViewGroup)adView.getParent()).removeView(adView);
                }
                adContainer.setVisibility(View.VISIBLE);
                adContainer.addView(adView);
            } else {
                adContainer.setVisibility(View.GONE);
                line.setVisibility(View.VISIBLE);
            }

            findViewById(R.id.go_detail).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    // 상세보기 페이지 이동
                    try {

                        String path = makeDialogPath(transactionPopupInfo.getTranId(),
                                transactionPopupInfo.getTransaction().getParsedTransaction().keyword,
                                transactionPopupInfo.getCategory().getLarge(),
                                transactionPopupInfo.getCategory().getMedium(),
                                transactionPopupInfo.getCategory().getLargeCode(),
                                transactionPopupInfo.getCategory().getMediumCode(),
                                transactionPopupInfo.getTransaction().getParsedTransaction().spentDate,
                                transactionPopupInfo.getTransaction().getSpentMoney(),
                                transactionPopupInfo.getTransaction().getParsedTransaction().installmentCount,
                                transactionPopupInfo.getTransaction().getCardId(),
                                transactionPopupInfo.getTransaction().getParsedTransaction().memo,
                                transactionPopupInfo.getTransaction().getParsedTransaction().dwType == 1 ? "expense" : "income", "popup");

                        String deepLink = "visual://popup";
                        if(TextUtils.isEmpty(deepLink)) {
                            VisualWebActivity.startActivity(TransactionPopupActivity.this, path);
                        } else {
                            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(deepLink));
                            intent.putExtra(VisualWebActivity.ARG_PATH, path);
                            startActivity(intent);
                        }


                    } catch (Exception e) {
                        e.printStackTrace();
                    } finally {
                        finish();
                    }

                }
            });

            findViewById(R.id.close).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    finish();
                }
            });

            ImageView categoryImageView = (ImageView) findViewById(R.id.category);
            if(transactionPopupInfo.getLargeCode() == 10 || transactionPopupInfo.getLargeCode() == 90) {
                categoryImageView.setVisibility(View.GONE);
            } else {
                categoryImageView.setVisibility(View.VISIBLE);
                categoryImageView.setImageResource(getCategoryIcon(transactionPopupInfo.getLargeCode()));

            }

            LocalBroadcastManager.getInstance(TransactionPopupActivity.this).sendBroadcast(new Intent(ACTION_TRAN_POPUP));

        } catch (Exception e) {
            e.printStackTrace();
            finish();
        }

    }

}
