package com.tenqube.visual_third.manager;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;

import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.receiver.AlarmReceiver;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;

import java.util.ArrayList;
import java.util.Calendar;

import tenqube.parser.core.ParserService;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class VisualAlarmManager {

    public static final String TAG = VisualAlarmManager.class.getSimpleName();
    private static final int ALARM_SET = 0;
    private static final int ALARM_REPEAT = 1;

    private Context context;
    private static VisualAlarmManager mInstance = null;
    private AlarmManager alarmManager;
    private VisualRepository repository;

    private ResourceManager resourceManager;

    public static VisualAlarmManager getInstance(Context ctx) {
        synchronized (VisualAlarmManager.class) {
            if (mInstance == null) {
                mInstance = new VisualAlarmManager(ctx.getApplicationContext());
            }
        }
        return mInstance;
    }

    private VisualAlarmManager(Context context) {
        this.context = context;
        alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
        repository = VisualRepository.getInstance(context);
        resourceManager = ResourceManager.getInstance(VisualApi.getInstance(context), PrefManager.getInstance(context), ParserService.getInstance(context));

    }

    public void setReportTest(String type, int second) {

        ArrayList<VisualNotification> notifications = repository.loadNotifications();
        for(VisualNotification notification : notifications) {

            if(notification.getName().contains(type)) {
                cancelAlarm(notification);
                if(notification.isEnable()) {
                    PendingIntent pIntent = createPendingIntent(notification);
                    long alarmTime = System.currentTimeMillis() + second * 1000;

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                        alarmManager.setAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, alarmTime, pIntent);
                    } else {
                        alarmManager.set(AlarmManager.RTC_WAKEUP, alarmTime, pIntent);
                    }
                }
            }
        }

    }

    public void syncNotification() {
        resourceManager.syncNotification();
    }

    public void disableDailyAlarms() {
        try {
            VisualNotification daily = repository.loadDailyNoti();
            if(daily != null) {
                cancelAlarm(daily);
                repository.updateNotiStatus(daily.getId(), false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
    /**
     * 호출 시점
     * 1. 처음 진입시
     * 2. 설정 변경시
     */
    public void setAlarms() {

        try {
            int minute = getMinute();
            ArrayList<VisualNotification> notifications = repository.loadNotifications();
            for(VisualNotification notification : notifications) {
                cancelAlarm(notification);
                if(notification.isEnable()) {
                    setAlarm(notification, minute);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setAlarm(VisualNotification notification, int minute) {

        PendingIntent pIntent = createPendingIntent(notification);
        long alarmTime = calculateAlarmTime(notification, minute);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            alarmManager.setAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, alarmTime, pIntent);
        } else {
            alarmManager.set(AlarmManager.RTC_WAKEUP, alarmTime, pIntent);
        }
    }

    private void cancelAlarm(VisualNotification notification) {
        PendingIntent pIntent = createPendingIntent(notification);
        alarmManager.cancel(pIntent);
    }

    private PendingIntent createPendingIntent(VisualNotification notification) {
        Intent intent = new Intent(context, AlarmReceiver.class);
        intent.setAction(AlarmReceiver.ACTION_TENQUBE_NOTIFICATION);

        Bundle bundle = new Bundle();
        bundle.putSerializable("data", notification);
        intent.putExtra("bundle", bundle);

        LOGI("ALARM", "createPendingIntent" + intent.getBundleExtra("bundle"), true);

        return PendingIntent.getBroadcast(context, notification.getId(), intent, PendingIntent.FLAG_UPDATE_CURRENT);
    }

    private long calculateAlarmTime(VisualNotification notification, int minute) {

        Calendar calendar = Calendar.getInstance();
        long currentTime = calendar.getTimeInMillis();
        int currentDay = calendar.get(Calendar.DATE);

        int currentHour = calendar.get(Calendar.HOUR_OF_DAY);

        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);

        int day = notification.getDay();
        int dayOfWeek = notification.getDayOfWeek();
        int hour = notification.getHour();

        switch (notification.getName()) {
            case "monthly":
                if(day == currentDay) { // 1일로같음
                    if(currentHour >= hour) { // 알람설정 시간을 지나침
                        calendar.add(Calendar.MONTH, 1);
                    }
                } else {
                    calendar.add(Calendar.MONTH, 1);
                }

                calendar.set(Calendar.DATE, day);
                calendar.set(Calendar.HOUR_OF_DAY, hour);
                break;

            case "weekly_mon":
            case "weekly_fri":
                calendar.set(Calendar.HOUR_OF_DAY, hour);
                calendar.set(Calendar.DAY_OF_WEEK, dayOfWeek);

                if(currentTime >= calendar.getTimeInMillis()) {
                    calendar.add(Calendar.WEEK_OF_YEAR, 1);
                }
                break;

            case "daily":
                calendar.set(Calendar.HOUR_OF_DAY, hour);
//                calendar.set(Calendar.MINUTE, Calendar.getInstance().get(Calendar.MINUTE));
//                calendar.add(Calendar.MINUTE, 1);
                if(currentTime >= calendar.getTimeInMillis()) {
                    calendar.add(Calendar.DATE, 1);
                }
                break;
        }

        int beforeDay = calendar.get(Calendar.DATE);

        calendar.add(Calendar.MINUTE, minute);

        int afterDay = calendar.get(Calendar.DATE);

        if(beforeDay < afterDay) { // 하루가 지나가 버리면 다시 0으로 설정
            calendar.add(Calendar.MINUTE, -minute);
        }


        LOGI(TAG, "MINUTE: " + minute, mIsDebug);
        LOGI(TAG, "notification.getName()" + notification.getName(), mIsDebug);
        LOGI(TAG, "Alarm Date: " + Utils.getStringDateAsYYYYMMddHHmmss(calendar), mIsDebug);
        return calendar.getTimeInMillis();
    }

    /**
     * uid를 이용해 사용자 custId mod divider 를 통해 알람설정
     * @return
     */
    private int getMinute() {

        int divider = repository.getDivider();
        String uid = repository.getUid();
        return Math.abs(uid.hashCode()) % divider;

    }

}
