/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.repository;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.db.DatabaseHelper;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.dao.CardDao;
import com.tenqube.visual_third.db.dao.CategoryDao;
import com.tenqube.visual_third.db.dao.CurrencyDao;
import com.tenqube.visual_third.db.dao.NotificationDao;
import com.tenqube.visual_third.db.dao.TransactionDao;
import com.tenqube.visual_third.db.dao.UserCategoryDao;
import com.tenqube.visual_third.entity.Card;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.Currency;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.entity.UserCategory;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;
import com.tenqube.visual_third.model.js.Cards;
import com.tenqube.visual_third.model.js.CategoryInfo;
import com.tenqube.visual_third.model.js.InsertTransactionRequest;
import com.tenqube.visual_third.model.js.TransactionByIdsRequest;
import com.tenqube.visual_third.model.js.Transactions;
import com.tenqube.visual_third.model.js.UpdateTransactionRequest;
import com.tenqube.visual_third.model.ui.NotiCatch;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import tenqube.parser.constants.Constants;

public class VisualRepository {
    private final Context context;
    private static VisualRepository mInstance;
    private final PrefManager prefManager;
    private final CardDao cardDao;
    private final CategoryDao categoryDao;
    private final TransactionDao transactionDao;
    private final UserCategoryDao userCategoryDao;
    private final CurrencyDao currencyDao;
    private final NotificationDao notificationDao;
    private final AppExecutors appExecutors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualRepository getInstance(Context context) {
        Class<VisualRepository> clazz = VisualRepository.class;
        synchronized (VisualRepository.class) {
            if (mInstance == null) {
                mInstance = new VisualRepository(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private VisualRepository(Context context) {
        DatabaseHelper dbHelper = DatabaseHelper.getInstance(context);
        Db db = new Db(dbHelper.getWritableDatabase(), dbHelper.getReadableDatabase());
        this.context = context;
        this.prefManager = PrefManager.getInstance(context);
        this.cardDao = new CardDao(db);
        this.categoryDao = new CategoryDao(db);
        this.transactionDao = new TransactionDao(db);
        this.userCategoryDao = new UserCategoryDao(db);
        this.currencyDao = new CurrencyDao(db);
        this.notificationDao = new NotificationDao(db);
        this.appExecutors = new AppExecutors();
    }

    public void initialize(final Callback<Boolean> callback) {
        this.appExecutors.diskIO().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String apiKey = VisualRepository.this.prefManager.loadStringValue("TENQUBE_API_KEY", "");
                    String qualifier = VisualRepository.this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "");
                    VisualRepository.this.prefManager.clearAll();
                    VisualRepository.this.saveSDKInfo(apiKey, qualifier);
                    VisualRepository.this.cardDao.deleteAll();
                    VisualRepository.this.transactionDao.deleteAll();
                    VisualRepository.this.cardDao.insertCash();
                    VisualRepository.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onComplete(true);
                        }
                    });
                }
                catch (Exception e) {
                    VisualRepository.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onComplete(false);
                        }
                    });
                }
            }
        });
    }

    public ArrayList<NotiCatch> loadNotiCatchedApps() {
        String[] apps;
        String defaultPkgs = "com.kftc.citismb,com.cu.sbank,com.keb.android.mbank,com.epost.psf.sdsi,com.wooribank.pib.smart,com.wooricard.smartapp,net.ib.android.smcard,com.hyundaicard.appcard,com.lcacApp,nh.smart.card,nh.smart,com.bccard.bcsmartapp,co.kr.kdb.android.smartkdb,com.kftc.citismb-49,com.shinhan.sbanking,com.shinhan.sbanking-116,com.citibank.cardapp,com.feelingk.dyfn.pushagent,com.nh.mobilenoti,com.kbstar.starpush,com.knb.bsp,com.shinhan.smartcaremg,com.IBK.SmartPush.app,com.hanabank.ebk.channel.android.hananbank,kr.co.bnkbank.push.customer,com.kbcard.kbkookmincard,com.wr.alrim,com.kftc.shsmb,com.smg.mgnoti,kr.co.youfirst.checkable,com.hanaskcard.app.touchstamp,com.samsung.android.spay,com.sc.danb.scbankapp,com.yuanta.tradarm,com.kbankwith.smartbank,com.hanaskcard.paycla,com.shinhan.smartcaremgr,kr.co.citibank.citimobile,com.shinhan.mobilebankbook,com.shinhaninvest.mts,kr.co.bsbank.mobilebank,com.epost.psf.ss,com.kbstar.liivkbcambodia,com.wooriwm.txsmart,com.wooriwm.mugsmart,com.skplanet.syrup.notisender,com.kakaobank.channel";
        String pkgs = this.prefManager.loadStringValue("TENQUBE_PACKAGE_NAMES", defaultPkgs);
        ArrayList<NotiCatch> notiCatches = new ArrayList<NotiCatch>();
        PackageManager packageManager = this.context.getPackageManager();
        for (String packageName : apps = pkgs.split(",")) {
            try {
                ApplicationInfo appInfo = packageManager.getApplicationInfo(packageName, 128);
                Drawable icon = packageManager.getApplicationIcon(packageName);
                String appName = (String)packageManager.getApplicationLabel(appInfo);
                notiCatches.add(new NotiCatch(icon, appName));
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return notiCatches;
    }

    public Cursor getSum(String fromAt, String toAt, int groupBy) {
        return this.transactionDao.getSum(fromAt, toAt, groupBy);
    }

    public void settingNotification(int smallIcon, String channel, int color2) {
        this.prefManager.saveIntValue("TENQUBE_NOTI_ICON_RES", smallIcon);
        this.prefManager.saveStringValue("TENQUBE_NOTI_CHANNEL", channel);
        this.prefManager.saveIntValue("TENQUBE_NOTI_COLOR", color2);
    }

    public void setEnabled(boolean enabled) {
        this.prefManager.saveBoolean("TENQUBE_SDK_ENABLED", enabled);
    }

    public boolean isExecutedBulk() {
        return this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false);
    }

    public void setDeepLink(String url) {
        this.prefManager.saveStringValue("TENQUBE_DEEP_LINK", url);
    }

    public void setUserName(String userName) {
        this.prefManager.saveStringValue("TENQUBE_USER_NAME", userName);
    }

    public boolean shouldSignUp() {
        return TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_UID", ""));
    }

    public void saveSDKInfo(String apiKey, String qualifier) {
        this.prefManager.saveStringValue("TENQUBE_API_KEY", apiKey);
        this.prefManager.saveStringValue("TENQUBE_QUALIFIER", qualifier);
    }

    public void saveServerInfo(SignUpResponse response) {
        this.prefManager.saveStringValue("TENQUBE_SEARCH_URL", response.getResults().getSearch().getUrl());
        this.prefManager.saveStringValue("TENQUBE_SEARCH_API_KEY", response.getResults().getSearch().getApiKey());
        this.prefManager.saveStringValue("TENQUBE_UID", response.getResults().getAuthorization().getSdk());
        this.prefManager.saveLongValue("TENQUBE_SIGN_UP_TIME", Calendar.getInstance().getTimeInMillis());
        if (response.getResults().getWeb() != null) {
            this.prefManager.saveStringValue("TENQUBE_WEB_URL", response.getResults().getWeb().getUrl());
        }
    }

    public double getSum(String fromAt, String toAt) {
        return this.transactionDao.getSum(fromAt, toAt);
    }

    public boolean isActiveNoti(String name) {
        return this.notificationDao.isActiveNoti(name);
    }

    public void setActiveNoti(String name, boolean isActive) {
        this.notificationDao.setActiveNoti(name, isActive);
    }

    public void updateNotiHour(String name, int hour) {
        this.notificationDao.updateNotiHour(name, hour);
    }

    public ArrayList<VisualNotification> loadNotifications() {
        return this.notificationDao.loadNotifications();
    }

    public boolean shouldShowTranPopup() {
        return this.prefManager.isEnabled("TENQUBE_TRAN_POPUP", true);
    }

    public void setTranPopup(boolean shouldShow) {
        this.prefManager.saveBoolean("TENQUBE_TRAN_POPUP", shouldShow);
    }

    public Currency loadCurrencyInfo(String from, String to) {
        return this.currencyDao.loadCurrencyInfo(from, to);
    }

    public void mergeCurrency(String from, String to, float rate, String updatedAt) {
        this.currencyDao.mergeCurrency(new Currency(0, from, to, rate, updatedAt));
    }

    public void updateDeletedTransactionById(Integer[] ids) {
        this.transactionDao.updateDeletedTransactionById(ids);
    }

    public void deleteTransactions() {
        ArrayList<Integer> ids = this.transactionDao.loadDeletedTranIds();
        if (!Utils.isEmpty(ids)) {
            this.transactionDao.deleteTransactions(ids);
        }
    }

    public void loadAll() {
    }

    public int insertTransaction(InsertTransactionRequest insertTransactionRequest) {
        return this.transactionDao.insertTransaction(insertTransactionRequest);
    }

    public JoinedTransaction loadJoinedTransaction(int tranId) {
        return this.transactionDao.loadJoinedTransaction(tranId);
    }

    public int loadTranId(String identifier) {
        return this.transactionDao.loadTranId(identifier);
    }

    public com.tenqube.visual_third.entity.Transaction loadApplyAllTran(String keyword) {
        if (TextUtils.isEmpty((CharSequence)keyword)) {
            return null;
        }
        return this.transactionDao.loadApplyAllTran(keyword);
    }

    public ArrayList<Transactions.Transaction> loadTransactions(com.tenqube.visual_third.model.js.TransactionRequest transactionRequest) {
        ArrayList<JoinedTransaction> transactions = this.transactionDao.loadJoinedTransactions(transactionRequest);
        return Mapper.toJsTransactions(transactions);
    }

    public ArrayList<Transaction> loadAnalysisTransactions(com.tenqube.visual_third.model.js.TransactionRequest transactionRequest) {
        ArrayList<JoinedTransaction> transactions = this.transactionDao.loadJoinedTransactions(transactionRequest);
        return Mapper.toAnalysisTran(transactions);
    }

    public ArrayList<Transactions.Transaction> loadTransactions(TransactionByIdsRequest transactionRequest) {
        ArrayList<JoinedTransaction> transactions = this.transactionDao.loadJoinedTransactions(transactionRequest);
        return Mapper.toJsTransactions(transactions);
    }

    public TransactionRequest loadNotSyncedTransactions() {
        ArrayList<JoinedTransaction> transactions = this.transactionDao.loadNotSyncedTransactions();
        if (!transactions.isEmpty()) {
            return new TransactionRequest(Mapper.toApiTransactions(transactions));
        }
        return null;
    }

    public SearchCompanyRequest loadFailedSearchTransactions() {
        ArrayList<JoinedTransaction> transactions = this.transactionDao.loadFailedSearchTransactions();
        ArrayList<SearchCompanyRequest.Transaction> searchTransactions = Mapper.toSearchTransactionWithEntity(transactions);
        if (!Utils.isEmpty(searchTransactions)) {
            return new SearchCompanyRequest(searchTransactions);
        }
        return null;
    }

    public ArrayList<Cards.Card> loadCards() {
        ArrayList<Card> cards = this.cardDao.loadCards();
        return Mapper.toJsCards(cards);
    }

    public ArrayList<CategoryInfo.ServerCategory> loadCategories() {
        ArrayList<Category> categories = this.categoryDao.loadCategories();
        return Mapper.toJsCategories(categories);
    }

    public Category loadCategory(String categoryCode) {
        return this.categoryDao.loadCategory(categoryCode);
    }

    public ArrayList<CategoryInfo.UserCategory> loadUserCategories() {
        ArrayList<UserCategory> categories = this.userCategoryDao.loadUserCategories();
        return Mapper.toJsUserCategories(categories);
    }

    public void mergeCategory(ArrayList<SyncCategoryResponse.Category> categories) {
        try {
            for (SyncCategoryResponse.Category category : categories) {
                this.categoryDao.mergeCategory(category);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateSyncedTransactions(TransactionRequest transactionRequest) {
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<TransactionRequest.Transaction> transactions = transactionRequest.getTransactions();
        for (TransactionRequest.Transaction tran : transactions) {
            ids.add(tran.getIdentifier());
        }
        this.transactionDao.updateSyncedTransactions(ids);
    }

    public void updateTransaction(UpdateTransactionRequest updateTransactionRequest) {
        this.transactionDao.updateTransaction(updateTransactionRequest);
    }

    public void updateRetrySearch(ArrayList<SearchCompanyRequest.Transaction> transactions, boolean shouldRetry) {
        ArrayList<String> ids = new ArrayList<String>();
        for (SearchCompanyRequest.Transaction tran : transactions) {
            ids.add(tran.getIdentifier());
        }
        this.transactionDao.updateRetryTransactions(ids, shouldRetry);
    }

    public int loadCardId(String cardName, int cardType, int cardSubType) {
        int cardId = this.cardDao.getCardId(cardName, cardType, cardSubType);
        if (cardId == -1) {
            cardId = this.cardDao.insert(cardName, cardType, cardSubType);
        }
        return cardId;
    }

    public void mergeTransactions(ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions) {
        try {
            for (com.tenqube.visual_third.model.parser.Transaction parsedTran : transactions) {
                int cardId = this.loadCardId(parsedTran.getParsedTransaction().cardName, parsedTran.getParsedTransaction().cardType, parsedTran.getParsedTransaction().cardSubType);
                parsedTran.setCardId(cardId);
                int userCateId = this.userCategoryDao.getCategoryId(parsedTran.getParsedTransaction().dwType == Constants.DWType.DEPOSIT.ordinal() ? "901010" : "101010");
                parsedTran.setUserCateId(userCateId);
                this.transactionDao.mergeTransaction(parsedTran);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateTransactions(SearchCompanyResponse response) {
        try {
            for (SearchCompanyResponse.TranCompany tranCompany : response.getResults()) {
                int userCateId = this.userCategoryDao.getCategoryId(tranCompany.getCategory().getRepCode());
                this.transactionDao.updateTransaction(tranCompany, userCateId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateTransaction(SearchCompanyResponse.TranCompany tranCompany, boolean isAll) {
        try {
            int userCateId = this.userCategoryDao.getCategoryId(tranCompany.getCategory().getRepCode());
            if (isAll) {
                this.transactionDao.updateTransactionByKeyword(tranCompany, userCateId);
            } else {
                this.transactionDao.updateTransaction(tranCompany, userCateId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

