package com.tenqube.visual_third.web;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.SystemClock;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AlertDialog;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.js.ConfirmBoxRequest;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.NewViewRequest;
import com.tenqube.visual_third.model.js.PageInfoRequest;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.GoOpenMarketUtil;

import static com.tenqube.visual_third.util.Utils.fromJson;

public class UiImpl extends Base implements VisualInterface.UI, BottomDialog.OnBottomListener{

    private String callbackSelectOrderBy;
    private final BottomDialog bottomDialog;
    private long mLastClickTime;
    private AppExecutors appExecutors;

    public UiImpl(Context context, ViewContractor contractor, WebView webView, VisualInterface.Error error, BottomDialog bottomDialog) {
        super(context, contractor, webView, error);
        this.bottomDialog = bottomDialog;
        this.bottomDialog.setBottomListener(this);
        this.appExecutors = new AppExecutors();
    }

    /**

     window.visual.openSelectBox( JSON.stringify({
     message: '카테고리가 변경되었습니다. 같은 업체에 대하여 일괄 적용하시겠습니까?',
     data: [{
     buttonText: '아니요',
     callbackJS: 'thisTranUpdate'
     }, {
     buttonText: '네',
     callbackJS: 'allTranUpdate'
     }]
     }));
     */
    @JavascriptInterface
    public void openConfirmBox(final String params) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                String funcName = "openConfirmBox";
                try {
                    // params 파싱해서 callback 구하기
                    final ConfirmBoxRequest confirmBoxRequest = fromJson(params, ConfirmBoxRequest.class);
                    confirmBoxRequest.checkParams();

                    AlertDialog.Builder builder = new AlertDialog.Builder(context);

                    builder.setMessage(confirmBoxRequest.getMessage());

                    builder.setNegativeButton(confirmBoxRequest.getData().get(0).getButtonText(), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            callback(confirmBoxRequest.getData().get(0).getCallbackJS(), null);
                        }
                    });

                    builder.setPositiveButton(confirmBoxRequest.getData().get(1).getButtonText(), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            callback(confirmBoxRequest.getData().get(1).getCallbackJS(), null);
                        }
                    });

                    AlertDialog alertDialog = builder.create();
                    alertDialog.show();
                } catch (ParameterException e) {
                    onError(funcName, e.toString());
                } catch (Exception e) {
                    onError(funcName, e.toString());
                }
            }
        });

    }

    /**
     *
     bottom dialog 노출
     * @param params {
        title: ‘정렬기준 선택',
        data: [{
        name: ‘인기순',
        orderByType: 1
        }, {
        name: ‘최신순’,
        orderByType: 2,
        }, {
        name: ‘이름순',
        orderByType: 3
        }],
        dataCallbackJS: ‘callbackSelectOrderBy’
    }
     */
    @JavascriptInterface
    public void openSelectBox(final String params) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                String funcName = "openSelectBox";
                try {
                    // params 파싱해서 callback 구하기
                    SelectBoxRequest selectBoxRequest = fromJson(params, SelectBoxRequest.class);
                    selectBoxRequest.checkParams();
                    callbackSelectOrderBy = selectBoxRequest.getDataCallbackJS();

                    if(bottomDialog != null) bottomDialog.showBottomDialog(selectBoxRequest);

                } catch (ParameterException e) {
                    onError(funcName, e.toString());
                } catch (Exception e) {
                    onError(funcName, e.toString());
                }

            }
        });

    }

    @Override
    public void onItemSelected(final SelectBoxInfo selectBoxInfo) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                if(bottomDialog != null) bottomDialog.dismiss();
                callback(callbackSelectOrderBy, selectBoxInfo);
            }
        });
    }

    /**
     * @param params
     * * 3. 예시
        3-1. 내장 브라우저에서 해당 웹 페이지 호출
        ```
        window.visual.openNewView( JSON.stringify({
        viewType: ‘external’,
        url: ‘https://visualbank.io’,
        titlebar: ‘N’
        }));
        ```
        3-2. 앱 내부 웹 뷰에서 해당 웹 페이지 호출
        ```
        window.visual.openNewView( JSON.stringify({
        viewType: ‘internal’,
        url: ‘http://dev.kt-view.tenqube.kr/dialog’,
        titlebar: ‘Y’,
        title: '상세내역',
        titleColor: ‘#000000’,
        fontColor: ‘#ffffff’
        }));
        ```
        3-3. 구글 플레이 스토어에 해당 페이지 호출
        ```
        window.visual.openNewView( JSON.stringify({
        viewType: ‘google’,
        url: ‘https://play.google.com/store/apps/details?id=com.tenqube.qlip’,
        titlebar: ‘N’
        }));
     */
    @JavascriptInterface
    public void openNewView(final String params) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                String funcName = "openNewView";
                try {

                    if(SystemClock.elapsedRealtime() - mLastClickTime < 1000){
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();


                    NewViewRequest newViewInfo = fromJson(params, NewViewRequest.class);
                    newViewInfo.checkParams();

                    switch (newViewInfo.getViewType()) {
                        case "external":
                            Intent i = new Intent(Intent.ACTION_VIEW);
                            i.setData(Uri.parse(newViewInfo.getUrl()));
                            context.startActivity(i);
                            break;

                        case "internal":
                            contractor.startPopup(newViewInfo.getUrl());
                            break;

                        case "google":
                            GoOpenMarketUtil.openOnGooglePlayMarket(context, newViewInfo.getUrl());
                            break;

                        case "native":

                            break;
                    }


                } catch (ParameterException e) {
                    onError(funcName, e.toString());
                } catch (Exception e) {
                    onError(funcName, e.toString());
                }

            }
        });


    }

    /**
     * 화면 종료
     */
    @JavascriptInterface
    public void finish(final String path) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                String funcName = "finish";
                try {

                    if(contractor != null) contractor.onFinish(path);

                } catch (Exception e) {
                    onError(funcName, e.toString());
                }

            }

        });

    }

    /**
     * 스낵바 띄우기
     * @param msg
     */
    @JavascriptInterface
    public void showSnackBar(final String msg) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                try {
                    Snackbar.make(webView, msg, Snackbar.LENGTH_SHORT).show();
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }

        });


    }

    /**
     * 토스트 띄우기
     * @param msg
     */
    @JavascriptInterface
    public void showToast(final String msg) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                try {
                    Toast.makeText(context, msg, Toast.LENGTH_SHORT).show();
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }

        });


    }

    @JavascriptInterface
    public void onPageLoaded(final String params) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                try {
                    PageInfoRequest page = fromJson(params, PageInfoRequest.class);
                    page.checkParams();
                    if(contractor != null) contractor.onPageLoaded();

                } catch (ParameterException e) {
                    e.printStackTrace();
                }

            }

        });


    }

    @JavascriptInterface
    public void onScrollChanged(boolean shouldShow) {

    }

    @JavascriptInterface
    public void onFinish() {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                String funcName = "onFinish";
                try {
                    callback("onFinish", null);
                } catch (Exception e) {
                    onError(funcName, e.toString());
                }

            }

        });


    }

    @JavascriptInterface
    public void showDatePicker(final String params) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                String funcName = "showMonthPicker";

                try {

                    DateRequest dateRequest = fromJson(params, DateRequest.class);
                    dateRequest.checkParams();
                    if(contractor != null) contractor.showDatePicker(dateRequest);

                } catch (Exception e) {
                    onError(funcName, e.toString());
                }
            }

        });



    }

    @JavascriptInterface
    public void showTimePicker(final String params) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                String funcName = "showTimePicker";
                try {
                    TimeRequest timeRequest = fromJson(params, TimeRequest.class);
                    timeRequest.checkParams();
                    if(contractor != null) contractor.showTimePicker(timeRequest);


                } catch (Exception e) {
                    onError(funcName, e.toString());
                }
            }

        });


    }

    @JavascriptInterface
    public void reload() {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                String funcName = "reload";

                try {
                    if(contractor != null) contractor.reload();
                } catch (Exception e) {
                    onError(funcName, e.toString());
                }
            }

        });


    }

    @JavascriptInterface
    public void retry() {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                String funcName = "retry";

                try {
                    if(contractor != null) contractor.retry();
                } catch (Exception e) {
                    onError(funcName, e.toString());
                }
            }

        });


    }

    @JavascriptInterface
    public void setRefreshEnabled(final boolean enabled) {

        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                String funcName = "setRefreshEnabled";

                try {
                    if(contractor != null) contractor.setRefreshEnabled(enabled);
                } catch (Exception e) {
                    onError(funcName, e.toString());
                }
            }

        });


    }

    @Override
    public void onCalendar(final String date, final String callback) {
        appExecutors.mainThread().execute(new Runnable() {
            @Override
            public void run() {
                callbackWithStr(callback, date);
            }

        });


    }


}
