package com.tenqube.visual_third.db;


import android.content.ContentValues;
import android.database.Cursor;
import android.provider.BaseColumns;

import com.tenqube.visual_third.entity.Card;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.Content;
import com.tenqube.visual_third.entity.Currency;
import com.tenqube.visual_third.entity.Transaction;
import com.tenqube.visual_third.entity.UserCategory;
import com.tenqube.visual_third.entity.VisualNotification;

import tenqube.parser.constants.Constants;


public final class ReaderContract {

    private static final String TEXT_TYPE = " TEXT ";
    private static final String REAL_TYPE = " REAL ";
    private static final String INTEGER_TYPE = " INTEGER ";
    private static final String COMMA_SEP = " , ";
    private static final String DATE_TYPE = " DATETIME ";
    private static final String DEFAULT = " DEFAULT ";
    private static final String NOT_NULL = " NOT NULL ";
    private static final String PRIMARY_KEY = " PRIMARY KEY ";
    private static final String UNIQUE = " UNIQUE ";
    private static final String AUTOINCREMENT = " AUTOINCREMENT ";
    private static final String CREATE_TABLE = " CREATE TABLE ";
    private static final String CREATE_TABLE_IF_NOT_EXISTS = " CREATE TABLE IF NOT EXISTS ";
    private static final String DROP_TABLE_IF_EXISTS = " DROP TABLE IF EXISTS ";
    private static final String DEFAULT_TEXT = " 'none' ";
    private static final String DEFAULT_INT = " 0 ";
    private static final String DEFAULT_DATE = " current_timestamp ";

    private ReaderContract() {
    }

    public static class NotificationsTable implements BaseColumns {

        public static final String TABLE_NAME = " NOTIFICATIONS ";
        public static final String ALIAS = " noti.";
        public static final String AS_ALIAS = " AS noti ";
        public static final String COLUMN_NOTI_ID = "noti_id_pk";
        public static final String COLUMN_NAME= "noti_name";
        public static final String COLUMN_TITLE = "noti_title";
        public static final String COLUMN_CONTENT = "noti_content";
        public static final String COLUMN_TICKER = "noti_ticker";
        public static final String COLUMN_ALARM_TYPE = "noti_alarm_type";
        public static final String COLUMN_DAY_OF_WEEK = "noti_day_of_week";
        public static final String COLUMN_HOUR = "noti_hour";
        public static final String COLUMN_DAY = "noti_day";
        public static final String COLUMN_ENABLE = "noti_enable";

        public static final String COLUMN_CREATED_AT = "noti_created_at";

        public static final String SQL_CREATE_TABLE =
                CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + " (" +
                        COLUMN_NOTI_ID + INTEGER_TYPE + PRIMARY_KEY + COMMA_SEP +
                        COLUMN_NAME + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_TITLE + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_CONTENT + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_TICKER + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +

                        COLUMN_ALARM_TYPE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_DAY_OF_WEEK + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_HOUR + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_DAY + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_ENABLE + INTEGER_TYPE + NOT_NULL + DEFAULT + " 1 " + COMMA_SEP +

                        COLUMN_CREATED_AT + DATE_TYPE + NOT_NULL + DEFAULT + DEFAULT_DATE + COMMA_SEP +
                        UNIQUE + "("+COLUMN_NAME +")" +

                        " )";


        public static final String SQL_DELETE_ENTRIES =
                DROP_TABLE_IF_EXISTS + TABLE_NAME;


        public static VisualNotification populateModel(Cursor c) {
            return new VisualNotification(
                    c.getInt(c.getColumnIndex(COLUMN_NOTI_ID)),
                    c.getString(c.getColumnIndex(COLUMN_NAME)),
                    c.getString(c.getColumnIndex(COLUMN_TITLE)),
                    c.getString(c.getColumnIndex(COLUMN_CONTENT)),
                    c.getString(c.getColumnIndex(COLUMN_TICKER)),

                    c.getInt(c.getColumnIndex(COLUMN_ALARM_TYPE)),
                    c.getInt(c.getColumnIndex(COLUMN_DAY_OF_WEEK)),
                    c.getInt(c.getColumnIndex(COLUMN_DAY)),
                    c.getInt(c.getColumnIndex(COLUMN_HOUR)),
                    c.getInt(c.getColumnIndex(COLUMN_ENABLE)) == 1
            );
        }

        public static ContentValues populateContent(VisualNotification model) {
            ContentValues values = new ContentValues();
            values.put(COLUMN_NOTI_ID, model.getId());
            values.put(COLUMN_NAME, model.getName());
            values.put(COLUMN_TITLE, model.getTitle());
            values.put(COLUMN_CONTENT, model.getContent());
            values.put(COLUMN_TICKER, model.getTicker());
            values.put(COLUMN_ALARM_TYPE, model.getAlarmType());
            values.put(COLUMN_DAY_OF_WEEK, model.getDayOfWeek());
            values.put(COLUMN_HOUR, model.getHour());
            values.put(COLUMN_DAY, model.getDay());
            values.put(COLUMN_ENABLE, model.isEnable()? 1 : 0);
            values.put(COLUMN_CREATED_AT, model.getCreatedAt());
            return values;
        }

        public static final String INSERT_NOTIFICATION = "INSERT OR REPLACE INTO" + TABLE_NAME +
                "(" +
                COLUMN_NOTI_ID + "," +
                COLUMN_NAME + "," +
                COLUMN_TITLE + "," +
                COLUMN_CONTENT +  "," +
                COLUMN_TICKER +  "," +
                COLUMN_ALARM_TYPE +  "," +
                COLUMN_DAY_OF_WEEK +  "," +
                COLUMN_HOUR +  "," +
                COLUMN_DAY +  "," +
                COLUMN_ENABLE +  "," +
                COLUMN_CREATED_AT +
                ")" +
                "VALUES";

    }

    public static class CurrencyTable implements BaseColumns {

        public static final String TABLE_NAME = " CURRENCY";
        public static final String ALIAS = " currency.";
        public static final String AS_ALIAS = " AS currency ";
        public static final String COLUMN_CURRENCY_ID = "currency_id_pk";
        public static final String COLUMN_FROM = "currency_from";
        public static final String COLUMN_TO = "currency_to";
        public static final String COLUMN_RATE = "currency_rate";
        public static final String COLUMN_CREATED_AT = "currency_created_at";


        public static final String SQL_CREATE_TABLE =
                CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + " (" +
                        COLUMN_CURRENCY_ID + INTEGER_TYPE + PRIMARY_KEY + COMMA_SEP +
                        COLUMN_FROM + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_TO + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_RATE + REAL_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_CREATED_AT + DATE_TYPE + NOT_NULL + DEFAULT + DEFAULT_DATE + COMMA_SEP +
                        UNIQUE + "("+COLUMN_FROM + COMMA_SEP + COLUMN_TO + ")" +
                        " )";


        public static final String SQL_DELETE_ENTRIES =
                DROP_TABLE_IF_EXISTS + TABLE_NAME;

        public static Currency populateModel(Cursor c) {
            return new Currency(
                    c.getInt(c.getColumnIndex(COLUMN_CURRENCY_ID)),
                    c.getString(c.getColumnIndex(COLUMN_FROM)),
                    c.getString(c.getColumnIndex(COLUMN_TO)),
                    c.getFloat(c.getColumnIndex(COLUMN_RATE)),
                    c.getString(c.getColumnIndex(COLUMN_CREATED_AT)));
        }

        public static ContentValues populateContent(Currency model) {
            ContentValues values = new ContentValues();
            values.put(COLUMN_FROM, model.getFrom());
            values.put(COLUMN_TO, model.getTo());
            values.put(COLUMN_RATE, model.getRate());
            values.put(COLUMN_CREATED_AT, model.getCreatedAt());
            return values;
        }

        public static final String INSERT_CURRENCY = "INSERT OR REPLACE INTO" + TABLE_NAME +
                "(" +
                COLUMN_FROM + "," +
                COLUMN_TO + "," +
                COLUMN_RATE + "," +
                COLUMN_CREATED_AT + ")" +
                "VALUES";
    }

    public static class ContentTable implements BaseColumns {

        public static final String TABLE_NAME = " CONTENTS";
        public static final String AS_ALIAS = " AS content ";
        public static final String ALIAS = " content.";

        public static final String COLUMN_CONTENT_ID = "contentId";

        public static final String COLUMN_PRIORITY = "priority";

        public static final String COLUMN_CATEGORY_PRIORITY = "categoryPriority";
        public static final String COLUMN_NUM_OF_OCCURRENCE = "numOfOccurrence";

        public static final String COLUMN_LARGE_CODE = "lCode";
        public static final String COLUMN_RAW_KEYS = "rawKeys";
        public static final String COLUMN_LINK_TO = "linkTo";

        public static final String COLUMN_LABEL = "label";
        public static final String COLUMN_LARGE_CONTENT = "largeContent";
        public static final String COLUMN_LARGE_KEYS = "largeKeys";


        public static final String COLUMN_MEDIUM_CONTENT = "mediumContent";
        public static final String COLUMN_MEDIUM_KEYS = "mediumKeys";

        public static final String COLUMN_IMAGE = "image";

        public static final String SQL_CREATE_ENTRIES =
                CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + " (" +
                        COLUMN_CONTENT_ID + INTEGER_TYPE + PRIMARY_KEY + AUTOINCREMENT + COMMA_SEP +
                        COLUMN_PRIORITY + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_CATEGORY_PRIORITY + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_NUM_OF_OCCURRENCE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_LARGE_CODE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_RAW_KEYS + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_LINK_TO + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_LABEL + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +

                        COLUMN_LARGE_CONTENT + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_LARGE_KEYS + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +

                        COLUMN_MEDIUM_CONTENT + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_MEDIUM_KEYS + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +

                        COLUMN_IMAGE + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT +

                        " )";

        public static final String indexing = "CREATE INDEX visual_contents_idx ON " + ContentTable.TABLE_NAME + " ("+COLUMN_LARGE_CODE + ")";

        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO" +TABLE_NAME +
                "(" +
                COLUMN_CONTENT_ID + "," +
                COLUMN_PRIORITY + "," +
                COLUMN_CATEGORY_PRIORITY + "," +

                COLUMN_NUM_OF_OCCURRENCE + "," +
                COLUMN_LARGE_CODE + "," +
                COLUMN_RAW_KEYS + "," +

                COLUMN_LINK_TO + "," +
                COLUMN_LABEL + "," +

                COLUMN_LARGE_CONTENT + "," +
                COLUMN_LARGE_KEYS + "," +

                COLUMN_MEDIUM_CONTENT + "," +
                COLUMN_MEDIUM_KEYS + "," +

                COLUMN_IMAGE +  ")" +
                "VALUES";

        public static final String SQL_DELETE_ENTRIES =
                DROP_TABLE_IF_EXISTS + TABLE_NAME;

        public static Content populateModel(Cursor c) {
            return new Content(c.getInt(c.getColumnIndex(COLUMN_CONTENT_ID)),
                    c.getInt(c.getColumnIndex(COLUMN_PRIORITY)),
                    c.getInt(c.getColumnIndex(COLUMN_CATEGORY_PRIORITY)),
                    c.getInt(c.getColumnIndex(COLUMN_NUM_OF_OCCURRENCE)),
                    c.getInt(c.getColumnIndex(COLUMN_LARGE_CODE)),
                    c.getString(c.getColumnIndex(COLUMN_RAW_KEYS)),
                    c.getString(c.getColumnIndex(COLUMN_LINK_TO)),
                    c.getString(c.getColumnIndex(COLUMN_LABEL)),
                    c.getString(c.getColumnIndex(COLUMN_LARGE_CONTENT)),
                    c.getString(c.getColumnIndex(COLUMN_LARGE_KEYS)),

                    c.getString(c.getColumnIndex(COLUMN_MEDIUM_CONTENT)),
                    c.getString(c.getColumnIndex(COLUMN_MEDIUM_KEYS)),

                    c.getString(c.getColumnIndex(COLUMN_IMAGE))
            );
        }
    }

    public static class ConditionTable implements BaseColumns {

        public static final String TABLE_NAME = " CONDITIONS";
        public static final String AS_ALIAS = " AS condition ";
        public static final String ALIAS = " condition.";

        public static final String COLUMN_CONDITION_ID = "conditionId";

        public static final String COLUMN_CONTENT_ID = "cId";

        public static final String COLUMN_STANDARD = "standard";
        public static final String COLUMN_FUNC_TYPE = "funcType";

        public static final String COLUMN_FUNC_KEYS = "funcKeys";

        public static final String SQL_CREATE_ENTRIES =
                CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + " (" +
                        COLUMN_CONDITION_ID + INTEGER_TYPE + PRIMARY_KEY + AUTOINCREMENT + COMMA_SEP +
                        COLUMN_CONTENT_ID + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_STANDARD + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_FUNC_TYPE + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_FUNC_KEYS + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT  +
                        " )";

        public static final String indexing = "CREATE INDEX visual_conditions_idx ON " + ConditionTable.TABLE_NAME + " ("+COLUMN_CONTENT_ID + ")";

        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO" +TABLE_NAME +
                "(" +
                COLUMN_CONDITION_ID + "," +
                COLUMN_CONTENT_ID + "," +
                COLUMN_STANDARD + "," +

                COLUMN_FUNC_TYPE + "," +
                COLUMN_FUNC_KEYS + ")" +
                "VALUES";

        public static final String SQL_DELETE_ENTRIES =
                DROP_TABLE_IF_EXISTS + TABLE_NAME;

        public static Condition populateModel(Cursor c) {
            return new Condition(c.getInt(c.getColumnIndex(COLUMN_CONDITION_ID)),
                    c.getInt(c.getColumnIndex(COLUMN_CONTENT_ID)),
                    c.getString(c.getColumnIndex(COLUMN_STANDARD)),
                    c.getString(c.getColumnIndex(COLUMN_FUNC_TYPE)),
                    c.getString(c.getColumnIndex(COLUMN_FUNC_KEYS)));
        }
    }

    public static class CardTable implements BaseColumns {

        public static final String TABLE_NAME = " CARDS";
        public static final String AS_ALIAS = " AS card ";
        public static final String ALIAS = " card.";

        public static final String COLUMN_CARD_ID = "cId";

        public static final String COLUMN_CARD_NAME = "cardName";

        public static final String COLUMN_CARD_TYPE = "cardType";
        public static final String COLUMN_CARD_SUB_TYPE = "cardSubType";

        public static final String COLUMN_CHANGE_NAME = "changeName";
        public static final String COLUMN_CHANGE_TYPE = "changeType";
        public static final String COLUMN_CHANGE_SUB_TYPE = "changeSubType";

        public static final String COLUMN_BILLING_DAY = "billingDay";
        public static final String COLUMN_CARD_BALANCE = "balance";

        public static final String COLUMN_CARD_MEMO = "cardMemo";

        public static final String COLUMN_IS_EXCEPT = "isCardExcept";
        public static final String COLUMN_IS_CUSTOM = "isCardCustom";
        public static final String COLUMN_IS_DELETED = "isCardDeleted";


        public static final String SQL_CREATE_ENTRIES =
                CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + " (" +
                        COLUMN_CARD_ID + INTEGER_TYPE + PRIMARY_KEY + AUTOINCREMENT + COMMA_SEP +

                        COLUMN_CARD_NAME + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_CARD_TYPE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_CARD_SUB_TYPE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_CHANGE_NAME + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_CHANGE_TYPE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_CHANGE_SUB_TYPE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_BILLING_DAY + INTEGER_TYPE + NOT_NULL + DEFAULT + " 1 " + COMMA_SEP +
                        COLUMN_CARD_BALANCE + REAL_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_CARD_MEMO + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +

                        COLUMN_IS_EXCEPT + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_IS_CUSTOM + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_IS_DELETED + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        UNIQUE+"("+COLUMN_CARD_NAME + COMMA_SEP + COLUMN_CARD_TYPE + COMMA_SEP + COLUMN_CARD_SUB_TYPE + ") ON CONFLICT REPLACE" +

                        " )";

        public static final String indexing = "CREATE INDEX visual_card_idx ON " + CardTable.TABLE_NAME + " ("+COLUMN_CARD_NAME + "," +
                COLUMN_CARD_TYPE + "," +
                COLUMN_CARD_SUB_TYPE + ")";

        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO" +TABLE_NAME +
                "(" +
                COLUMN_CARD_NAME + "," +
                COLUMN_CARD_TYPE + "," +
                COLUMN_CARD_SUB_TYPE + "," +

                COLUMN_CHANGE_NAME + "," +
                COLUMN_CHANGE_TYPE + "," +
                COLUMN_CHANGE_SUB_TYPE + "," +

                COLUMN_BILLING_DAY + "," +
                COLUMN_CARD_BALANCE + "," +
                COLUMN_CARD_MEMO + "," +

                COLUMN_IS_EXCEPT + "," +
                COLUMN_IS_CUSTOM + "," +
                COLUMN_IS_DELETED + ")" +
                "VALUES";

        public static final String SQL_DELETE_ENTRIES =
                DROP_TABLE_IF_EXISTS + TABLE_NAME;

        public static ContentValues populateData() {
            ContentValues values = new ContentValues();
            values.put(ReaderContract.CardTable.COLUMN_CARD_NAME, "현금");
            values.put(ReaderContract.CardTable.COLUMN_CHANGE_NAME, "현금");

            values.put(ReaderContract.CardTable.COLUMN_CARD_TYPE, Constants.CardType.CASH.ordinal());
            values.put(ReaderContract.CardTable.COLUMN_CHANGE_TYPE, Constants.CardType.CASH.ordinal());

            values.put(ReaderContract.CardTable.COLUMN_CARD_SUB_TYPE, 0);
            values.put(ReaderContract.CardTable.COLUMN_CHANGE_SUB_TYPE, 0);

            values.put(ReaderContract.CardTable.COLUMN_BILLING_DAY, 1);

            return values;
        }

        public static Card populateModel(Cursor c) {
            return new Card(c.getInt(c.getColumnIndex(COLUMN_CARD_ID)),
                    c.getString(c.getColumnIndex(ReaderContract.CardTable.COLUMN_CARD_NAME)),
                    c.getInt(c.getColumnIndex(CardTable.COLUMN_CARD_TYPE)),
                    c.getInt(c.getColumnIndex(CardTable.COLUMN_CARD_SUB_TYPE)),

                    c.getString(c.getColumnIndex(CardTable.COLUMN_CHANGE_NAME)),
                    c.getInt(c.getColumnIndex(CardTable.COLUMN_CHANGE_TYPE)),
                    c.getInt(c.getColumnIndex(CardTable.COLUMN_CHANGE_SUB_TYPE)),
                    c.getInt(c.getColumnIndex(CardTable.COLUMN_BILLING_DAY)),
                    c.getDouble(c.getColumnIndex(CardTable.COLUMN_CARD_BALANCE)),
                    c.getString(c.getColumnIndex(CardTable.COLUMN_CARD_MEMO)),
                    c.getInt(c.getColumnIndex(CardTable.COLUMN_IS_EXCEPT)) == 1,
                    c.getInt(c.getColumnIndex(CardTable.COLUMN_IS_CUSTOM)) == 1,
                    c.getInt(c.getColumnIndex(CardTable.COLUMN_IS_DELETED)) == 1
            );
        }

    }

    public static class UserCategoryTable implements BaseColumns {
        public static final String TABLE_NAME = " USER_CATEGORIES ";
        public static final String ALIAS = " userCate.";
        public static final String AS_ALIAS = " AS userCate ";

        public static final String COLUMN_USER_CATE_ID = "ucId";

        public static final String COLUMN_CODE = "repCode";
        public static final String COLUMN_IS_EXCEPT = "isCateExcept";
        public static final String COLUMN_IS_MAIN = "isCateMain";

        public static final String SQL_CREATE_ENTRIES =
                CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + " (" +
                        COLUMN_USER_CATE_ID + INTEGER_TYPE + PRIMARY_KEY + AUTOINCREMENT + COMMA_SEP +

                        COLUMN_CODE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_IS_EXCEPT + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_IS_MAIN + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT +
                        " )";


        public static final String SQL_DELETE_ENTRIES =
                DROP_TABLE_IF_EXISTS + TABLE_NAME;

        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO" +
                TABLE_NAME +
                "(" +
                COLUMN_USER_CATE_ID + "," +
                COLUMN_CODE + "," +
                COLUMN_IS_EXCEPT + "," +
                COLUMN_IS_MAIN
                + ")" +
                "VALUES";

        public static UserCategory populateModel(Cursor c) {
            return new UserCategory(c.getInt(c.getColumnIndex(COLUMN_USER_CATE_ID)),
                    c.getInt(c.getColumnIndex(UserCategoryTable.COLUMN_CODE)),
                    c.getInt(c.getColumnIndex(UserCategoryTable.COLUMN_IS_EXCEPT)) == 1,
                    c.getInt(c.getColumnIndex(UserCategoryTable.COLUMN_IS_MAIN)) == 1);
        }

    }

    public static class CategoryTable implements BaseColumns {
        public static final String TABLE_NAME = " CATEGORIES ";
        public static final String ALIAS = " ca.";
        public static final String AS_ALIAS = " AS ca ";


        public static final String COLUMN_CODE = "cateCode";
        public static final String COLUMN_LARGE = "largeName";
        public static final String COLUMN_MEDIUM = "mediumName";
        public static final String COLUMN_SMALL = "smallName";

        public static final String SQL_CREATE_ENTRIES =
                CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + " (" +
                        _ID + INTEGER_TYPE + PRIMARY_KEY + AUTOINCREMENT + COMMA_SEP +
                        COLUMN_CODE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_LARGE + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_MEDIUM + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_SMALL + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT +

                        " )";


        public static final String INSERT_QUERY = "INSERT OR REPLACE INTO" +
                TABLE_NAME +
                "(" +
                    _ID + "," +
                    COLUMN_CODE + "," +
                    COLUMN_LARGE + "," +
                    COLUMN_MEDIUM + "," +
                    COLUMN_SMALL
                + ")" +
                "VALUES";

        public static Category populateModel(Cursor c) {
            return new Category(c.getInt(c.getColumnIndex(_ID)),
                    c.getInt(c.getColumnIndex(CategoryTable.COLUMN_CODE)),
                    c.getString(c.getColumnIndex(CategoryTable.COLUMN_LARGE)),
                    c.getString(c.getColumnIndex(CategoryTable.COLUMN_MEDIUM)),
                    c.getString(c.getColumnIndex(CategoryTable.COLUMN_SMALL))
            );
        }
    }

    public static class TransactionsTable implements BaseColumns {


        public static final String TABLE_NAME = " TRANSACTIONS";
        public static final String ALIAS = " tran.";
        public static final String AS_ALIAS = " AS tran ";


        public static final String COLUMN_TRAN_ID = "tranId";

        public static final String COLUMN_IDENTIFIER = "identifier";

        public static final String COLUMN_CARD_ID = "cardId";
        public static final String COLUMN_USER_CATEGORY_ID = "userCategoryId";

        public static final String COLUMN_COMPANY_ID = "companyId";
        public static final String COLUMN_CATEGORY_CODE = "categoryCode";
        public static final String COLUMN_FRANCHISE = "franchise";

        public static final String COLUMN_SPENT_DATE = "spentDate";
        public static final String COLUMN_FINISH_DATE = "finishDate";

        public static final String COLUMN_SPENT_LATITUDE = "spentLatitude";
        public static final String COLUMN_SPENT_LONGITUDE = "spentLongitude";

        public static final String COLUMN_SPENT_MONEY = "spentMoney";
        public static final String COLUMN_ORI_SPENT_MONEY = "oriSpentMoney";

        public static final String COLUMN_INSTALLMENT_COUNT = "installmentCount";

        public static final String COLUMN_KEYWORD = "keyword";
        public static final String COLUMN_SEARCH_KEYWORD = "searchKeyword";
        public static final String COLUMN_REPEAT_TYPE = "repeatType";
        public static final String COLUMN_CURRENCY = "currency";
        public static final String COLUMN_IS_DELETED = "isDeleted";
        public static final String COLUMN_DW_TYPE = "dwType";

        public static final String COLUMN_SENDER = "sender";
        public static final String COLUMN_FULL_SMS = "fullSms";
        public static final String COLUMN_SMS_DATE = "smsDate";
        public static final String COLUMN_SMS_TYPE = "smsType";
        public static final String COLUMN_REG_ID = "regId";


        public static final String COLUMN_IS_OFFSET = "isOffset";
        public static final String COLUMN_IS_CUSTOM = "isCustom";
        public static final String COLUMN_IS_USER_UPDATE = "isUserUpdate";
        public static final String COLUMN_IS_UPDATE_ALL = "isUpdateAll";

        public static final String COLUMN_MEMO = "memo";
        public static final String COLUMN_CLASS_CODE = "classCode";
        public static final String COLUMN_IS_SYNCED = "isSynced";
        public static final String COLUMN_SHOULD_RETRY_SEARCH = "shouldRetrySearch";


        public static final String SQL_CREATE_ENTRIES =

                CREATE_TABLE + TABLE_NAME + " (" +
                        COLUMN_TRAN_ID + INTEGER_TYPE + PRIMARY_KEY + AUTOINCREMENT + COMMA_SEP +

                        COLUMN_IDENTIFIER + REAL_TYPE + NOT_NULL + UNIQUE + COMMA_SEP+

                        COLUMN_CARD_ID + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_USER_CATEGORY_ID + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_COMPANY_ID + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_FRANCHISE + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_CATEGORY_CODE + INTEGER_TYPE + NOT_NULL+DEFAULT+"101010" + COMMA_SEP+

                        COLUMN_SPENT_DATE + DATE_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_FINISH_DATE + DATE_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_SPENT_LATITUDE + REAL_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_SPENT_LONGITUDE + REAL_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_SPENT_MONEY + REAL_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_ORI_SPENT_MONEY + REAL_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_INSTALLMENT_COUNT + INTEGER_TYPE + NOT_NULL + DEFAULT + "1" + COMMA_SEP +

                        COLUMN_KEYWORD + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_SEARCH_KEYWORD + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +

                        COLUMN_REPEAT_TYPE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_CURRENCY + TEXT_TYPE + COMMA_SEP +

                        COLUMN_IS_DELETED + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_DW_TYPE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_SENDER + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_FULL_SMS + TEXT_TYPE + NOT_NULL + DEFAULT + DEFAULT_TEXT + COMMA_SEP +
                        COLUMN_SMS_DATE + DATE_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_SMS_TYPE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT+ COMMA_SEP +
                        COLUMN_REG_ID + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT+ COMMA_SEP +

                        COLUMN_IS_OFFSET + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_IS_CUSTOM + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_IS_USER_UPDATE + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_IS_UPDATE_ALL + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +

                        COLUMN_MEMO + TEXT_TYPE + COMMA_SEP +
                        COLUMN_CLASS_CODE + TEXT_TYPE + NOT_NULL+DEFAULT + DEFAULT_TEXT + COMMA_SEP +

                        COLUMN_IS_SYNCED + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT + COMMA_SEP +
                        COLUMN_SHOULD_RETRY_SEARCH + INTEGER_TYPE + NOT_NULL + DEFAULT + DEFAULT_INT +
                        ")";


        public static final String indexing = "CREATE INDEX qlip_transaction_idx2 ON " + TransactionsTable.TABLE_NAME + " ("+COLUMN_SPENT_DATE + "," + COLUMN_DW_TYPE  +")";
        public static final String indexing2 = "CREATE INDEX qlip_transaction_idx3 ON " + TransactionsTable.TABLE_NAME + " ("+COLUMN_TRAN_ID  + ")";


        public static Transaction populateModel(Cursor c) {

            return new Transaction(
                    c.getInt(c.getColumnIndex(COLUMN_TRAN_ID)),
                    c.getLong(c.getColumnIndex(COLUMN_IDENTIFIER)),
                    c.getInt(c.getColumnIndex(COLUMN_CARD_ID)),
                    c.getInt(c.getColumnIndex(COLUMN_USER_CATEGORY_ID)),
                    c.getInt(c.getColumnIndex(COLUMN_COMPANY_ID)),
                    c.getString(c.getColumnIndex(COLUMN_FRANCHISE)),
                    c.getInt(c.getColumnIndex(COLUMN_CATEGORY_CODE)),
                    c.getString(c.getColumnIndex(COLUMN_SPENT_DATE)),
                    c.getString(c.getColumnIndex(COLUMN_FINISH_DATE)),
                    c.getDouble(c.getColumnIndex(COLUMN_SPENT_LATITUDE)),
                    c.getDouble(c.getColumnIndex(COLUMN_SPENT_LONGITUDE)),
                    c.getDouble(c.getColumnIndex(COLUMN_SPENT_MONEY)),
                    c.getDouble(c.getColumnIndex(COLUMN_ORI_SPENT_MONEY)),

                    c.getInt(c.getColumnIndex(COLUMN_INSTALLMENT_COUNT)),
                    c.getString(c.getColumnIndex(COLUMN_KEYWORD)),
                    c.getString(c.getColumnIndex(COLUMN_SEARCH_KEYWORD)),
                    c.getInt(c.getColumnIndex(COLUMN_REPEAT_TYPE)),
                    c.getString(c.getColumnIndex(COLUMN_CURRENCY)),
                    c.getInt(c.getColumnIndex(COLUMN_IS_DELETED)) == 1,
                    c.getInt(c.getColumnIndex(COLUMN_DW_TYPE)),
                    c.getString(c.getColumnIndex(COLUMN_SENDER)),
                    c.getString(c.getColumnIndex(COLUMN_FULL_SMS)),
                    c.getString(c.getColumnIndex(COLUMN_SMS_DATE)),
                    c.getInt(c.getColumnIndex(COLUMN_SMS_TYPE)),
                    c.getInt(c.getColumnIndex(COLUMN_REG_ID)),
                    c.getInt(c.getColumnIndex(COLUMN_IS_OFFSET)) == 1,
                    c.getInt(c.getColumnIndex(COLUMN_IS_CUSTOM)) == 1,
                    c.getInt(c.getColumnIndex(COLUMN_IS_USER_UPDATE)) == 1,
                    c.getInt(c.getColumnIndex(COLUMN_IS_UPDATE_ALL)) == 1,

                    c.getString(c.getColumnIndex(COLUMN_MEMO)),
                    c.getString(c.getColumnIndex(COLUMN_CLASS_CODE)),
                    c.getInt(c.getColumnIndex(COLUMN_IS_SYNCED)) == 1
                    );
        }
    }

}
