package com.tenqube.visual_third.service;

import android.app.IntentService;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;

import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.VisualNotificationManager;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class AlarmService extends IntentService {

    public static final String TAG = AlarmService.class.getSimpleName();

    /**
     * Creates an IntentService.  Invoked by your subclass's constructor.
     * @param name Used to name the worker thread, important only for debugging.
     */
    public AlarmService(String name) {
        super(name);
    }

    public AlarmService() {
        super("AlarmService");
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        LOGI(TAG, "onHandleIntent", mIsDebug);

        try {
            if(intent != null) {

                Bundle bundle = intent.getBundleExtra("bundle");
                if (bundle != null) {
                    VisualNotification notification = (VisualNotification) bundle.getSerializable("data");
                    if(notification != null) {
                        VisualNotificationManager.getInstance(getApplicationContext()).showNotification(notification);

                    } else {
                        LOGI(TAG, "notification == null", mIsDebug);

                    }
                } else {
                    LOGI(TAG, "bundle == null", mIsDebug);

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            VisualAlarmManager.getInstance(getApplicationContext()).setAlarms();
        }

    }
}
