/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.View;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.util.FontUtil;

public class NotificationDialogFragment
extends DialogFragment {
    public static final String TAG = NotificationDialogFragment.class.getSimpleName();
    Callback callback;

    public static NotificationDialogFragment newInstance() {
        return new NotificationDialogFragment();
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
            View view = this.getActivity().getLayoutInflater().inflate(R.layout.dialog_notification, null);
            FontUtil.setAllTextView(view);
            view.findViewById(R.id.ok).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NotificationDialogFragment.this.dismissAllowingStateLoss();
                    if (NotificationDialogFragment.this.callback != null) {
                        NotificationDialogFragment.this.callback.onOkButtonClicked();
                    }
                }
            });
            view.findViewById(R.id.cancel).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NotificationDialogFragment.this.dismissAllowingStateLoss();
                    if (NotificationDialogFragment.this.callback != null) {
                        NotificationDialogFragment.this.callback.onCancelButtonClicked();
                    }
                }
            });
            builder.setView(view);
            AlertDialog dialog = builder.create();
            dialog.requestWindowFeature(1);
            dialog.setCanceledOnTouchOutside(true);
            if (dialog.getWindow() != null) {
                dialog.getWindow().requestFeature(1);
            }
            return dialog;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dismissAllowingStateLoss();
            return null;
        }
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setLayout(-1, -2);
            dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    static interface Callback {
        public void onOkButtonClicked();

        public void onCancelButtonClicked();
    }
}

