package com.tenqube.visual_third.db.dao;

import android.content.Context;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.NotificationApp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class NotificationAppDao {

    private final Db db;

    public NotificationAppDao(Db db) {
        this.db = db;
    }

    public void insertNotificationApp(Context context) {

        ArrayList<String> notifications = new ArrayList<>();
        AssetManager am = context.getAssets();
        InputStream inStream;
        BufferedReader buffer;
        try {
            inStream = am.open("notification_apps.tsv");
            buffer = new BufferedReader(new InputStreamReader(inStream));
            String line = "";
            int i  = 0;
            while ((line = buffer.readLine()) != null) {
                if(i == 0){
                    i++;
                    continue;
                }

                String[] colums = line.split("\t");

                notifications.add(new NotificationApp(Integer.parseInt(colums[0]),//id
                        colums[1],//name
                        colums[2],//image
                        0
                ).insertValues());

            }

            if (inStream != null)
                inStream.close();
            if (buffer != null)
                buffer.close();

            if(notifications.size() != 0) {
                String insertQuery = ReaderContract.NotificationAppTable.INSERT_QUERY + TextUtils.join(",", notifications);
                db.runQuery(insertQuery);
                notifications.clear();
            }

        } catch (IOException e) {
            e.printStackTrace();
        } catch (NumberFormatException e) {
            e.printStackTrace();
        } catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<NotificationApp> findAll() {

        ArrayList<NotificationApp> results = new ArrayList<>();
        String query = QueryGenerator.notificationApp();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {

                        results.add(ReaderContract.NotificationAppTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public void mergeAll(ArrayList<NotificationApp> apps) {
        try {

            ArrayList<String> values = new ArrayList<>();
            ArrayList<Integer> deletedIds = new ArrayList<>();

            for(NotificationApp app : apps) {
                if(app.getEnabled() == 0) {
                    deletedIds.add(app.getId());
                } else {
                    values.add(app.insertValues());

                }
            }
            String insertQuery = ReaderContract.NotificationAppTable.INSERT_QUERY + TextUtils.join(",", values);
            db.runQuery(insertQuery);

            db.delete(ReaderContract.NotificationAppTable.TABLE_NAME, ReaderContract.NotificationAppTable._ID + " IN (" + TextUtils.join(",", deletedIds) + ")", null);

        } catch (SQLiteException e) {
            e.printStackTrace();
        }

    }


}
