package com.tenqube.visual_third.core;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.support.v4.app.ActivityCompat;

import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnSuccessListener;

import java.util.concurrent.Executor;


class FusedLocationManager {

    FusedLocationProviderClient mFusedLocationClient;

    private Context mContext;
    private Location mLocation = null;
    private static FusedLocationManager mInstance = null;

    public static FusedLocationManager getInstance(Context ctx) {
        synchronized (FusedLocationManager.class) {
            if (mInstance == null) {
                mInstance = new FusedLocationManager(ctx.getApplicationContext());
            }
        }
        return mInstance;
    }

    private FusedLocationManager(Context context) {
        this.mContext = context;
        mFusedLocationClient = LocationServices.getFusedLocationProviderClient(context);

    }

    public void loadLastLocation() {
        if (ActivityCompat.checkSelfPermission(mContext, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(mContext, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return;
        }
        mFusedLocationClient.getLastLocation()
                .addOnSuccessListener(new DirectExecutor(), new OnSuccessListener<Location>() {
                    @Override
                    public void onSuccess(Location location) {
                        if (location != null) {
                            mLocation = location;
                        }
                    }
                });
    }


    public Location getLocation(){
        return mLocation;
    }


    class DirectExecutor implements Executor {
        public void execute(Runnable r) {
            r.run();
        }
    }


}
