package com.tenqube.visual_third.core;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.PrefManager;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

import static com.tenqube.visual_third.manager.PrefManager.ACCESS_TOKEN;
import static com.tenqube.visual_third.manager.PrefManager.REFRESH_TOKEN;

class AuthorizationInterceptor implements Interceptor {

    private final PrefManager prefManager;
    private final  VisualApi visualApi;

    AuthorizationInterceptor(PrefManager prefManager, VisualApi visualApi) {
        this.prefManager = prefManager;
        this.visualApi = visualApi;
    }

    @Override
    public Response intercept(@NonNull Chain chain) throws IOException {
        Response mainResponse = chain.proceed(chain.request());

        if (mainResponse.code() == 401) {

            String refreshToken = prefManager.loadStringValue(REFRESH_TOKEN, "");
            if(!TextUtils.isEmpty(refreshToken)) {
                // synchronously calling login API
                try {
                    visualApi.renewToken(refreshToken);

                    // retry the 'mainRequest' which encountered an authentication error
                    // add new token into 'mainRequest' header and request again

                    Request mainRequest = chain.request();
                    Request.Builder builder = mainRequest.newBuilder();

                    builder.header("Authorization", prefManager.loadStringValue(ACCESS_TOKEN, "")).
                            method(mainRequest.method(), mainRequest.body());
                    mainResponse = chain.proceed(builder.build());

                } catch (AuthException e) {
                    e.printStackTrace();
                }
            }
        }

        return mainResponse;
    }
}
