/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.catcher.rcs;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.tenqube.visual_third.parser.catcher.SmsMmsService;
import com.tenqube.visual_third.parser.catcher.rcs.RcsContentObserver;
import com.tenqube.visual_third.parser.catcher.rcs.RcsParser;
import java.io.Serializable;
import tenqube.parser.model.SMS;

public class RcsCatcher {
    private static RcsCatcher mInstance;
    private final Context context;
    private Handler handler;
    private HandlerThread handlerThread;
    private static final Uri CONTENT_URI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RcsCatcher getInstance(Context context) {
        Class<RcsCatcher> clazz = RcsCatcher.class;
        synchronized (RcsCatcher.class) {
            if (mInstance == null) {
                mInstance = new RcsCatcher(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private RcsCatcher(Context context) {
        this.context = context;
    }

    public void register() {
        Log.i((String)"RCS", (String)"register");
        this.handlerThread = new HandlerThread("Rcs worker");
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        ContentResolver contentResolver = this.context.getContentResolver();
        RcsContentObserver observer = new RcsContentObserver(this, this.handler);
        contentResolver.registerContentObserver(CONTENT_URI, true, (ContentObserver)observer);
    }

    public void parse(String messageId) {
        this.sendToParser(this.queryRcs(messageId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMS queryRcs(String messageId) {
        if (this.context.getContentResolver() == null) {
            return null;
        }
        Cursor c = null;
        Object messageBody = null;
        String selection = "is_bot_message = 1 and openrichcard_content IS NOT NULL";
        SMS sms = null;
        try {
            c = this.context.getContentResolver().query(Uri.parse((String)("content://com.lge.ims.rcsim.database.provider.message/" + messageId)), null, selection, null, null);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    sms = RcsParser.toSMS(c);
                    c.moveToNext();
                }
            }
        }
        catch (SQLiteException sQLiteException) {
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return sms;
    }

    private void sendToParser(SMS sms) {
        if (sms != null) {
            Intent startIntent = new Intent(this.context.getApplicationContext(), SmsMmsService.class);
            startIntent.putExtra("ARG_SMS", (Serializable)sms);
            if (Build.VERSION.SDK_INT >= 26) {
                this.context.getApplicationContext().startForegroundService(startIntent);
            } else {
                this.context.getApplicationContext().startService(startIntent);
            }
        }
    }

    static {
        CONTENT_URI = Uri.parse((String)"content://com.lge.ims.rcsim.database.provider.message");
    }
}

