/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.catcher.rcs;

import android.database.Cursor;
import android.text.TextUtils;
import com.tenqube.visual_third.util.Utils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;

public final class RcsParser {
    public static String getDisplayText(String jsonString) {
        try {
            JSONObject rootObject = new JSONObject(jsonString);
            StringBuilder collector = new StringBuilder();
            JSONObject layoutObject = rootObject.getJSONObject("layout");
            RcsParser.collectDisplayText(layoutObject, collector, "");
            String displayText = collector.toString();
            return displayText;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return jsonString;
        }
    }

    private static boolean collectDisplayText(JSONObject widgetObject, StringBuilder collector, String delimiter) throws JSONException {
        String widget;
        switch (widget = widgetObject.getString("widget")) {
            case "TextView": {
                String text = widgetObject.getString("text");
                if (!TextUtils.isEmpty((CharSequence)text)) {
                    collector.append(delimiter);
                    collector.append(text);
                    return true;
                }
                return false;
            }
            case "LinearLayout": {
                JSONArray children = widgetObject.getJSONArray("children");
                int length = children.length();
                for (int i = 0; i < length; ++i) {
                    JSONObject jsonObject = children.getJSONObject(i);
                    RcsParser.collectDisplayText(jsonObject, collector, delimiter);
                }
                return true;
            }
        }
        return false;
    }

    public static SMS toSMS(Cursor c) {
        int id2 = c.getInt(c.getColumnIndex("_id"));
        String address = c.getString(c.getColumnIndex("address"));
        long date = System.currentTimeMillis();
        String bodyJson = c.getString(c.getColumnIndex("body"));
        String fullSMS = RcsParser.getDisplayText(bodyJson);
        if (id2 != 0 && !TextUtils.isEmpty((CharSequence)address) && date != 0L && !TextUtils.isEmpty((CharSequence)fullSMS)) {
            return new SMS(id2, fullSMS, address, address, Utils.getConvertedDate(date), Constants.SMSType.SMS.ordinal());
        }
        return null;
    }
}

