/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.catcher;

import android.annotation.TargetApi;
import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import com.tenqube.visual_third.parser.catcher.SmsMmsService;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.worker.RcsWorker;
import java.io.Serializable;
import tenqube.parser.model.NotiRequest;

@TargetApi(value=18)
public class NotiCatcher
extends NotificationListenerService {
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private boolean isRcs = false;

    public IBinder onBind(Intent mIntent) {
        return super.onBind(mIntent);
    }

    public boolean onUnbind(Intent mIntent) {
        return super.onUnbind(mIntent);
    }

    public void onCreate() {
        super.onCreate();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    @TargetApi(value=19)
    public void onNotificationPosted(StatusBarNotification sbn) {
        this.parseNoti(sbn);
        this.startRcsWorker();
    }

    private void startRcsWorker() {
        if (!this.isRcs) {
            OneTimeWorkRequest mathWork = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(RcsWorker.class).addTag("rcs")).build();
            WorkManager.getInstance((Context)this.getApplicationContext()).enqueueUniqueWork("rcs", ExistingWorkPolicy.REPLACE, mathWork);
            this.isRcs = true;
        }
    }

    @RequiresApi(api=19)
    private void parseNoti(StatusBarNotification sbn) {
        String title = "none";
        String content = "";
        String bigContent = "";
        try {
            if (this.shouldParse(sbn)) {
                if (Utils.isSDKDisabled(this.getApplicationContext())) {
                    return;
                }
                String packageName = sbn.getPackageName();
                Notification notification = sbn.getNotification();
                CharSequence titleCS = notification.extras.getCharSequence("android.title");
                CharSequence contentCS = notification.extras.getCharSequence("android.text");
                CharSequence bigCS = notification.extras.getCharSequence("android.bigText");
                if (titleCS != null) {
                    title = titleCS.toString();
                }
                if (contentCS != null) {
                    content = contentCS.toString();
                }
                if (bigCS != null) {
                    bigContent = bigCS.toString();
                }
                if (this.isInValid(content, packageName)) {
                    return;
                }
                NotiRequest notiRequest = new NotiRequest(packageName, title, content, bigContent, notification.when);
                Intent startIntent = new Intent(this.getApplicationContext(), SmsMmsService.class);
                startIntent.putExtra("ARG_SMS", (Serializable)notiRequest.toSMS(null));
                this.startService(startIntent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @RequiresApi(api=19)
    private boolean shouldParse(StatusBarNotification sbn) {
        return sbn != null && !sbn.isOngoing() && sbn.getNotification() != null && sbn.getNotification().extras != null && sbn.getNotification().extras.getInt("android.progress") == 0 && sbn.getNotification().extras.getInt("android.progressMax") == 0;
    }

    private boolean isInValid(String content, String packageName) {
        return TextUtils.isEmpty((CharSequence)content) || TextUtils.isEmpty((CharSequence)packageName) || "me.kkebi.ting".equals(packageName) || "com.android.systemui".equals(packageName) || "com.tenqube.qlip".equals(packageName) || "com.internet.speed.meter.lite".equals(packageName) || "com.sec.android.app.clockpackage".equals(packageName) || "wan.util.barclock".equals(packageName) || "com.eclipsim.gpsstatus2".equals(packageName) || "com.android.bluetooth".equals(packageName);
    }

    public void onNotificationRemoved(StatusBarNotification sbn) {
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 3;
    }

    public void onListenerConnected() {
        super.onListenerConnected();
    }

    public void onListenerDisconnected() {
        super.onListenerDisconnected();
    }
}

