package com.tenqube.visual_third.worker;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.core.os.BuildCompat;
import androidx.work.Worker;
import androidx.work.WorkerParameters;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.VisualNotificationManager;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.permission.PermissionUtil;

import java.util.Calendar;

import static com.tenqube.visual_third.util.permission.PermissionUtil.PERMISSIONS_SMS;

public class ReportWorker extends Worker {

    public static final String ACTION_TENQUBE_NOTIFICATION = "ACTION_TENQUBE_NOTIFICATION_HANA";

    public static final String ARG_ACTION = "ARG_ACTION";

    public static final String ARG_NOTI_ID = "TENQUBE_ARG_NOTI_ID";
    public static final String ARG_NOTI_TEST = "TENQUBE_ARG_NOTI_TEST";

    private Context mContext;

    public ReportWorker(
            @NonNull Context context,
            @NonNull WorkerParameters params) {
        super(context, params);
        mContext = getContext(context);

    }

    @Override
    public Result doWork() {
        // Do the work here--in this case, upload the images.


        Utils.LOGD("doWork", "start");
        if(ACTION_TENQUBE_NOTIFICATION.equals(getInputData().getString(ARG_ACTION)) && PermissionUtil.hasPermissions(
                mContext, PERMISSIONS_SMS)){

            try {
                int notiId = getInputData().getInt(ARG_NOTI_ID, -1);
                final boolean isTest = getInputData().getBoolean(ARG_NOTI_TEST, false);
                Utils.LOGD("doWork", "notiId:" + notiId);
                Utils.LOGD("doWork", "isTest:" + isTest);

                if(notiId != -1) {
                    VisualNotification notification = VisualAlarmManager.getInstance(mContext).getNotification(notiId);
                    Utils.LOGD("doWork", "isTest:" + isTest);

                    if(notification != null &&
                            notification.isEnable() &&
                            !"daily".equals(notification.getName())) {

                        // 알림이 울린시점의 시간이 저녁인경우
                        if(isTest || shouldShow(notification)) {
                            VisualNotificationManager.getInstance(mContext).showNotification(notification);

                            if(isTest) {
                                VisualAlarmManager.getInstance(mContext).setReportTest(Constants.ReportAlarmType.MONTHLY.name().toLowerCase(), 10);
                            } else{
                                VisualAlarmManager.getInstance(mContext).setAlarm(notification);
                            }
                        }
                    } else {
                        Utils.LOGD("doWork", "notification: disabled");

                    }
                }
            } catch (Exception e) {
            }
        }

        return Result.success();
    }

    private boolean shouldShow(VisualNotification notification) {

        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(Calendar.HOUR_OF_DAY);
        int diff = hour - notification.getHour();

        return Math.abs(diff) < 3;
    }

    private Context getContext(Context context) {
        if (BuildCompat.isAtLeastN()) {
            return context.createDeviceProtectedStorageContext();
        } else {
            return context;
        }
    }
}
