package com.tenqube.visual_third.db.dao;

import android.database.Cursor;
import android.database.SQLException;
import android.text.TextUtils;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Currency;

import java.util.ArrayList;

/**
 * CRUD 모아서 정리하기
 */
public class CurrencyDao {

    private final Db db;

    public CurrencyDao(Db db) {
        this.db = db;
    }

    public Currency loadCurrencyInfo(String from, String to) {
        Cursor c = null;
        String query = QueryGenerator.currency();

        try {
            String[] args = new String[]{from, to};
            c = db.runQuery(query, args);
            if (c != null) {
                if (c.moveToFirst()) {
                    return ReaderContract.CurrencyTable.populateModel(c);
                }
            }
        } catch (SQLException e) {

        } finally {
            if (c != null)
                c.close();
        }
        return null;
    }

    public void mergeCurrency(Currency currency) {
        try {
            db.insertOnReplace(ReaderContract.CurrencyTable.TABLE_NAME, ReaderContract.CurrencyTable.populateContent(currency));
        } catch (Exception e) {

        }
    }

    public void mergeCurrency(ArrayList<String> currencies) {
        try {
            db.runQuery(ReaderContract.CurrencyTable.INSERT_CURRENCY + TextUtils.join(",", currencies));
        } catch (Exception e) {

        }
    }


}
