package com.tenqube.visual_third.web;

import android.webkit.WebView;

import com.tenqube.visual_third.ActivityCallback;
import com.tenqube.visual_third.model.js.Error;
import com.tenqube.visual_third.util.Utils;

public class ErrorImpl extends Base implements VisualInterface.Error {

    private static final String ERROR_CALLBACK = "onError";

    public ErrorImpl(ActivityCallback activity, WebView webView) {
        super(activity, webView, null);
    }

    @Override
    public void onError(String funcName, String msg) {
        Utils.LOG("onError", "funcName" + funcName + "/ msg" + msg);

        callback(ERROR_CALLBACK, new Error(funcName, msg));
    }
}
