package com.tenqube.visual_third.parser.catcher.rcs;

import android.database.Cursor;
import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;

import static com.tenqube.visual_third.util.Utils.getConvertedDate;

public final class RcsParser {

    public static String getDisplayText(String jsonString) {
        try {
            JSONObject rootObject = new JSONObject(jsonString);
            StringBuilder collector = new StringBuilder();
            JSONObject layoutObject = rootObject.getJSONObject("layout");
            collectDisplayText(layoutObject, collector, "");
            String displayText = collector.toString();
            return displayText;
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonString;
    }

    private static boolean collectDisplayText(JSONObject widgetObject, StringBuilder
            collector, String delimiter) throws JSONException {
        String widget = widgetObject.getString("widget");
        switch (widget) {
            case "TextView":
                String text = widgetObject.getString("text");
                if (!TextUtils.isEmpty(text)) {
                    collector.append(delimiter);
                    collector.append(text);
                    return true;
                }
                return false;
            case "LinearLayout":
                JSONArray children = widgetObject.getJSONArray("children");
                int length = children.length();
                for (int i = 0; i < length; i++) {
                    JSONObject jsonObject = children.getJSONObject(i);
                    collectDisplayText(jsonObject, collector, delimiter);
                }
                return true;
        }
        return false;
    }

    public static SMS toSMS(Cursor c) {
        int id = c.getInt(c.getColumnIndex("_id"));
        String address = c.getString(c.getColumnIndex("address"));
        long date = System.currentTimeMillis();
        String bodyJson = c.getString(c.getColumnIndex("body"));
        String fullSMS = RcsParser.getDisplayText(bodyJson);

        if(id != 0 &&
                !TextUtils.isEmpty(address) &&
                date != 0 &&
                !TextUtils.isEmpty(fullSMS)) {
            return new SMS(id, fullSMS, address, address, getConvertedDate(date), Constants.SMSType.SMS.ordinal());
        } else {
            return null;
        }

    }
}
