package com.tenqube.visual_third.parser.executor;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;

import androidx.annotation.Nullable;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.util.Utils;

public class BulkExecutor {

    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    public static final int SYNC_ERROR = 14;
    public static final int SHOW_SYNC_PROGRESS_BAR = 16;
    public static final int CLOSE_SYNC_PROGRESS_BAR = 17;

    private static BulkExecutor instance;
    private Context context;
    private BulkLoader bulkLoader;

    @Nullable
    private BulkCallback callback;

    public boolean isLoading;
    private Constants.ProgressType progressType = Constants.ProgressType.BULK;

    private BulkExecutor(Context context){
        this.context = context;
    }

    public static BulkExecutor getInstance(Context context){
        if(instance == null){
            instance = new BulkExecutor(context);
        }
        return instance;
    }

    public void setCallback(BulkCallback callback) {
        this.callback = callback;
    }

    public void start(final boolean isInit) {

        Utils.LOGD("bulkExecutor", "start" + "isInit" + isInit);

        Utils.LOGD("bulkExecutor", "start" + "isLoading" + isLoading);

        if(!isLoading) {
            isLoading = true;
            new Thread(new Runnable() {
                @Override
                public void run() {
                    try {
                        // 1. 프로그레스 다이얼로그 show
                        if(isInit) {
                            handler.sendEmptyMessage(SHOW_SYNC_PROGRESS_BAR);
                        } else {
                            handler.sendEmptyMessage(SHOW_PROGRESS_BAR);
                        }

                        bulkLoader = new BulkLoader(context, handler);

                        // 3. 지난 6개월 문자 파싱 시작
                        bulkLoader.doParsing(isInit);

                    } catch (Exception e) {
                        handler.sendEmptyMessage(ERROR);
                    }

                }
            }).start();
        } else { // 이미 진행중 다시 진입하면 url 로드 해줍니다.

            if(callback != null) {
                callback.loadProgressUrl(progressType);
            }
        }

    }

    //bulk
    private Handler handler = new Handler(new Handler.Callback() { // 핸들러로 전달받은 값 progress 값 세팅해주기
        @Override
        public boolean handleMessage(final Message msg) {

            try {
                switch (msg.what) {
                    case PROGRESS:
                        Utils.LOGD("bulkExecutor", "PROGRESS");

                        Bundle bundle = msg.getData();
                        if(bundle != null) {
                            if(callback != null) {
                                callback.onProgress(bundle.getInt("now"), bundle.getInt("total"));
                            }
                        }
                        break;

                    case SHOW_PROGRESS_BAR:
                        isLoading = true;
                        progressType = Constants.ProgressType.BULK;

                        if(callback != null) {
                            callback.loadProgressUrl(Constants.ProgressType.BULK);
                        }
                        Utils.LOGD("BulkHandler", "startBulk handleMessage SHOW_PROGRESS_BAR");
                        break;
                    case SHOW_SYNC_PROGRESS_BAR:
                        progressType = Constants.ProgressType.SYNC;

                        if(callback != null) {

                            callback.loadProgressUrl(Constants.ProgressType.SYNC);
                        }
                        isLoading = true;
                        break;

                    case CLOSE_SYNC_PROGRESS_BAR:
                        break;

                    case SYNC_ERROR:
                        Utils.LOGD("BulkHandler", "onBulkFinish SYNC_ERROR");

                        onSyncError();
                        onBulkFinish(false, false);

                        break;
                    case FINISH:
                        Utils.LOGD("BulkHandler", "onBulkFinish FINISH");

                        onBulkFinish(true, true);
                        break;

                    case ERROR:
                    default:
                        Utils.LOGD("BulkHandler", "onBulkFinish DEFAULT " + msg.what);
                        onBulkFinish(false, true);
                        break;
                }
            } catch (Exception e) {
                Utils.LOGD("BulkHandler", "Exception  " + e.toString());

                onBulkFinish(false, true);
            }

            return false;
        }
    });

    private void onSyncError() {

        Utils.LOGD("onSyncError", "start");
        if(callback != null) {
            callback.onSyncError();
        }

    }

    private void onBulkFinish(final boolean isSuccess,final boolean shouldReload) {
        Utils.LOGD("bulkExecutor", "onBulkFinish" );
        isLoading = false;
        if(callback != null) {
            callback.onBulkFinish(isSuccess, shouldReload);
        }
        destroy();

    }

    private void destroy() {
        Utils.LOGD("bulkExecutor", "destroy" );

        instance = null;
        bulkLoader = null;
        callback = null;
        handler = null;
    }
}
