package com.tenqube.visual_third.analysis;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.model.analysis.Transaction;

import java.util.ArrayList;

import static com.tenqube.visual_third.Constants.SUM;
import static com.tenqube.visual_third.analysis.AnalysisHelper.aggregate;
import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactions12Weekly;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getAggregate;

/**
 * Created by sagwangjin on 2018. 7. 22..
 */

public class Last12WeeklyAnalysis implements Runnable {
    private final ArrayList<Transaction> transactions;

    public double last12weeklySum = 0;

    Last12WeeklyAnalysis(ArrayList<Transaction> transactions) {
        this.transactions = transactions;
    }

    @Override
    public void run() {
        ArrayList<Transaction> last12Weekly = filterTransactions12Weekly(transactions); //이번주
        last12weeklySum = getAggregate(aggregate(last12Weekly, Constants.AggregateType.NONE), "", SUM);
    }
}
