package com.tenqube.visual_third;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Validator;

import java.util.Calendar;

public class VisualUserInfo {

    /**
     * 성별을 나타냅니다.
     */
    private Constants.Gender gender;

    /**
     * 태어난 해
     */
    final int birth;

    public VisualUserInfo(Constants.Gender gender, int birth) throws ParameterException {

        Validator.gt(birth, 1000);
        Validator.lt(birth, Calendar.getInstance().get(Calendar.YEAR));
        this.gender = gender;
        this.birth = birth;
    }

    public Constants.Gender getGender() {
        return gender;
    }

    public int getBirth() {
        return birth;
    }
}
