package com.tenqube.visual_third.web;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.AudioManager;
import android.net.Uri;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import android.view.SoundEffectConstants;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;

import com.google.android.material.snackbar.Snackbar;
import com.tenqube.visual_third.ActivityCallback;
import com.tenqube.visual_third.OnAdLoadedListener;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.model.js.AdRequest;
import com.tenqube.visual_third.model.js.ConfirmBoxRequest;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.NewViewRequest;
import com.tenqube.visual_third.model.js.PageInfoRequest;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.GoOpenMarketUtil;

import static android.app.Activity.RESULT_OK;
import static com.tenqube.visual_third.util.Utils.fromJson;

public class UiImpl extends Base implements VisualInterface.UI, BottomDialog.OnBottomListener{

    private String callbackSelectOrderBy;
    private final BottomDialog bottomDialog;
    private boolean isAdCancel = false;
    private final AdManager adManager;
    private AudioManager audioManager;

    public UiImpl(ActivityCallback activity,
                  WebView webView,
                  VisualInterface.Error error,
                  BottomDialog bottomDialog,
                  AdManager adManager) {
        super(activity, webView, error);
        this.bottomDialog = bottomDialog;
        this.bottomDialog.setBottomListener(this);
        this.adManager = adManager;
        audioManager = (AudioManager) activity.getActivity().getSystemService(Context.AUDIO_SERVICE);

    }

    @JavascriptInterface
    public void onClick() {
        try {
            activity.getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    audioManager.playSoundEffect(SoundEffectConstants.CLICK);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @JavascriptInterface
    public void showAd(String params) {
        isAdCancel = false;
        String funcName = "showAd";
        try {
            // params 파싱해서 callback 구하기
            final AdRequest adRequest = fromJson(params, AdRequest.class);
            adRequest.checkParams();
            adManager.loadAd(adRequest, new OnAdLoadedListener() {
                @Override
                public void onAdLoaded(View view) {

                    if(view != null && !isAdCancel) {
                        activity.addAd(view);
                    }
                }
            });
        } catch (ParameterException e) {
            onError(funcName, e.toString());
        } catch (Exception e) {
            onError(funcName, e.toString());
        }


    }

    @JavascriptInterface
    public void hideAd() {
        isAdCancel = true;
        activity.hideAd();
    }


    @Override
    public void setStatusBarColor(String color) {
        activity.changeStatusBarColor(color);
    }

    /**

     window.visual.openSelectBox( JSON.stringify({
     message: '카테고리가 변경되었습니다. 같은 업체에 대하여 일괄 적용하시겠습니까?',
     data: [{
     buttonText: '아니요',
     callbackJS: 'thisTranUpdate'
     }, {
     buttonText: '네',
     callbackJS: 'allTranUpdate'
     }]
     }));
     */
    @JavascriptInterface
    public void openConfirmBox(String params) {
        String funcName = "openConfirmBox";
        try {
            // params 파싱해서 callback 구하기
            final ConfirmBoxRequest confirmBoxRequest = fromJson(params, ConfirmBoxRequest.class);
            confirmBoxRequest.checkParams();

            AlertDialog.Builder builder = new AlertDialog.Builder(new ContextThemeWrapper(activity.getActivity(), R.style.AlertDialogCustom));

            builder.setMessage(confirmBoxRequest.getMessage());

            builder.setNegativeButton(confirmBoxRequest.getData().get(0).getButtonText(), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    callback(confirmBoxRequest.getData().get(0).getCallbackJS(), null);
                }
            });

            builder.setPositiveButton(confirmBoxRequest.getData().get(1).getButtonText(), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    callback(confirmBoxRequest.getData().get(1).getCallbackJS(), null);
                }
            });

            AlertDialog alertDialog = builder.create();
            alertDialog.show();
        } catch (ParameterException e) {
            onError(funcName, e.toString());
        } catch (Exception e) {
            onError(funcName, e.toString());
        }
    }

    /**
     *
     bottom dialog 노출
     * @param params {
        title: ‘정렬기준 선택',
        data: [{
        name: ‘인기순',
        orderByType: 1
        }, {
        name: ‘최신순’,
        orderByType: 2,
        }, {
        name: ‘이름순',
        orderByType: 3
        }],
        dataCallbackJS: ‘callbackSelectOrderBy’
    }
     */
    @JavascriptInterface
    public void openSelectBox(String params) {
        String funcName = "openSelectBox";
        try {
            // params 파싱해서 callback 구하기
            SelectBoxRequest selectBoxRequest = fromJson(params, SelectBoxRequest.class);
            selectBoxRequest.checkParams();
            this.callbackSelectOrderBy = selectBoxRequest.getDataCallbackJS();

            if(bottomDialog != null) bottomDialog.showBottomDialog(selectBoxRequest);

        } catch (ParameterException e) {
            onError(funcName, e.toString());
        } catch (Exception e) {
            onError(funcName, e.toString());
        }
    }

    @Override
    public void onItemSelected(SelectBoxInfo selectBoxInfo) {
        if(bottomDialog != null) bottomDialog.dismiss();
        callback(callbackSelectOrderBy, selectBoxInfo);
    }

    /**
     * @param params
     * * 3. 예시
        3-1. 내장 브라우저에서 해당 웹 페이지 호출
        ```
        window.visual.openNewView( JSON.stringify({
        viewType: ‘external’,
        url: ‘https://visualbank.io’,
        titlebar: ‘N’
        }));
        ```
        3-2. 앱 내부 웹 뷰에서 해당 웹 페이지 호출
        ```
        window.visual.openNewView( JSON.stringify({
        viewType: ‘internal’,
        url: ‘http://dev.kt-view.tenqube.kr/dialog’,
        titlebar: ‘Y’,
        title: '상세내역',
        titleColor: ‘#000000’,
        fontColor: ‘#ffffff’
        }));
        ```
        3-3. 구글 플레이 스토어에 해당 페이지 호출
        ```
        window.visual.openNewView( JSON.stringify({
        viewType: ‘google’,
        url: ‘https://play.google.com/store/apps/details?id=com.tenqube.qlip’,
        titlebar: ‘N’
        }));
     */
    @JavascriptInterface
    public void openNewView(String params) {
        String funcName = "openNewView";
        try {

            NewViewRequest newViewInfo = fromJson(params, NewViewRequest.class);
            newViewInfo.checkParams();

            if("external".equals(newViewInfo.getViewType())) {

                Intent i = new Intent(Intent.ACTION_VIEW);
                i.setData(Uri.parse(newViewInfo.getUrl()));
                activity.getActivity().startActivity(i);

            } else if("internal".equals(newViewInfo.getViewType())) {

                VisualWebActivity.startActivity(activity.getActivity(), newViewInfo.getUrl());

            } else if("google".equals(newViewInfo.getViewType())) {

                GoOpenMarketUtil.openOnGooglePlayMarket(activity.getActivity(), newViewInfo.getUrl());

            }

        } catch (ParameterException e) {
            onError(funcName, e.toString());
        } catch (Exception e) {
            onError(funcName, e.toString());
        }
    }

    /**
     * 화면 종료
     */
    @JavascriptInterface
    public void finish(String path) {
        String funcName = "finish";
        try {
            if(activity != null) {
                if(!TextUtils.isEmpty(path)) {
                    Intent intent = activity.getActivity().getIntent();
                    intent.putExtra("path", path);
                    activity.getActivity().setResult(RESULT_OK, intent);
                }
                activity.getActivity().finish();
            }

        } catch (Exception e) {
            onError(funcName, e.toString());
        }
    }

    /**
     * 스낵바 띄우기
     */
    @JavascriptInterface
    public void showSnackBar(String msg) {
        try {
            Snackbar.make(webView, msg, Snackbar.LENGTH_SHORT).show();
        } catch (Exception e) {

        }
    }

    /**
     * 토스트 띄우기
     */
    @JavascriptInterface
    public void showToast(String msg) {
        try {
            Toast.makeText(activity.getActivity(), msg, Toast.LENGTH_SHORT).show();
        } catch (Exception e) {

        }
    }


    @JavascriptInterface
    public void onPageLoaded(String params) {

        try {
            PageInfoRequest page = fromJson(params, PageInfoRequest.class);
            page.checkParams();

            if(activity != null) activity.onPagedLoaded();

        } catch (ParameterException e) {

        }
    }

    @JavascriptInterface
    public void onScrollChanged(int pos) {
        try {
            if(activity != null) activity.onScrollChanged(pos);
        } catch (Exception e) {

        }
    }

    @JavascriptInterface
    public void onFinish() {
        String funcName = "onFinish";
        try {
            callback("onFinish", null);
        } catch (Exception e) {
            onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public void showDatePicker(String params) {
        String funcName = "showMonthPicker";

        try {
            DateRequest dateRequest = fromJson(params, DateRequest.class);
            dateRequest.checkParams();
            android.app.DialogFragment newFragment = DatePickerFragment.newInstance(dateRequest);
            newFragment.show(activity.getActivity().getFragmentManager(), "datePicker");
        } catch (Exception e) {
            onError(funcName, e.toString());
        }

    }

    @JavascriptInterface
    public void showTimePicker(String params) {
        String funcName = "showTimePicker";
        try {
            TimeRequest timeRequest = fromJson(params, TimeRequest.class);
            timeRequest.checkParams();
            android.app.DialogFragment newFragment = TimePickerFragment.newInstance(timeRequest);
            newFragment.show(activity.getActivity().getFragmentManager(), "timePicker");
        } catch (Exception e) {
            onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public void reload() {
        String funcName = "reload";

        try {
            if(activity != null) activity.reload();
        } catch (Exception e) {
            onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public void retry() {
        String funcName = "retry";

        try {
            if(activity != null) activity.retry();
        } catch (Exception e) {
            onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public void setRefreshEnabled(boolean enabled){
        String funcName = "setRefreshEnabled";

        try {
            if(activity != null) activity.setRefreshEnabled(enabled);
        } catch (Exception e) {
            onError(funcName, e.toString());
        }
    }

    @Override
    public void onCalendar(String date, String callback) {
        callbackWithStr(callback, date);
    }

}
