package com.tenqube.visual_third.parser.catcher.rcs;

import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;


class RcsContentObserver extends ContentObserver {

    private RcsCatcher rcsCatcher;

    /**
     * Creates a content observer.
     *
     * @param handler The handler to run {@link #onChange} on, or null if none.
     */
    public RcsContentObserver(RcsCatcher rcsCatcher, Handler handler) {
        super(handler);
        this.rcsCatcher = rcsCatcher;
    }

    @Override
    public void onChange(boolean selfChange, Uri uri) {
        super.onChange(selfChange, uri);
        Log.i("RCS", "URI" + uri);
        rcsCatcher.parse(uri.toString().replace("content://im/chat/", ""));
    }

}