package com.tenqube.visual_third.model.api;

import java.io.Serializable;
import java.util.ArrayList;

import tenqube.parser.model.Bank;
import tenqube.parser.model.RegData;
import tenqube.parser.model.Sender;

public class ParsingRuleResponse implements Serializable{

    public String signature;

    /**
     * 암호화 키
     */
    public String securityKey;

    /**
     * 벌크 업로드시 서버로 보낼 수
     */
    public int tranCount;

    /**
     * 파싱 룰 최대 버전
     */
    public int ruleVersion;


    /**
     * 파싱 룰 정보
     */
    public ArrayList<RegData> regDatas = new ArrayList<>();


    /**
     * 파싱 가능한 전화번호 리스트 {@link Sender}
     */
    public ArrayList<Sender> senders = new ArrayList<>();

    /**
     * 카카오톡 에서 사용할 은행목록
     */
    public ArrayList<Bank> banks = new ArrayList<>();


    @Override
    public String toString() {
        return "ParsingRule{" +
                "securityKey='" + securityKey + '\'' +
                ", tranCount=" + tranCount +
                ", ruleVersion=" + ruleVersion +
                ", regDatas=" + regDatas +
                ", senders=" + senders +
                ", banks=" + banks +
                '}';
    }
}
