/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.CurrencyManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.VersionResponse;
import com.tenqube.visual_third.model.parser.Transaction;
import com.tenqube.visual_third.repository.VisualRepository;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParsingRule;

class BaseLoader {
    final Context mContext;
    ParserService parserService;
    VisualApi api;
    PrefManager prefManager;
    VisualRepository repository;
    private CurrencyManager currencyManager;

    BaseLoader(Context context) {
        this.mContext = context;
        this.parserService = ParserService.getInstance((Context)context);
        this.parserService.setDebugMode(true);
        this.api = VisualApi.getInstance(context);
        this.repository = VisualRepository.getInstance(context);
        this.prefManager = PrefManager.getInstance(context);
        this.currencyManager = CurrencyManager.getInstance(context);
        this.syncParsingRuleKey();
    }

    private void syncParsingRuleKey() {
        try {
            ParsingRuleKey parsingRuleKey;
            if (!this.prefManager.isEnabled("TENQUBE_PARSING_RULE_KEY", false) && (parsingRuleKey = this.api.syncParsingRuleKey()) != null) {
                ParsingRule parsingRule = new ParsingRule(parsingRuleKey.getSecurityKey(), parsingRuleKey.getTranCount(), 214, new ArrayList(), new ArrayList(), new ArrayList());
                this.parserService.syncParsingRule(parsingRule);
                this.prefManager.saveBoolean("TENQUBE_PARSING_RULE_KEY", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void syncParsingRule() {
        ParsingRule parsingRule;
        String[] authInfo = this.api.getAuthInfo();
        VersionResponse versionResponse = this.api.syncVersion(authInfo[0]);
        int clientVersion = this.prefManager.loadIntValue("TENQUBE_PARSING_RULE_VERSION", 214);
        if (versionResponse != null && versionResponse.getParsingRule() > clientVersion && (parsingRule = this.api.syncParsingRule(authInfo, clientVersion, versionResponse.getParsingRule())) != null) {
            this.parserService.syncParsingRule(parsingRule);
            this.prefManager.saveIntValue("TENQUBE_PARSING_RULE_VERSION", parsingRule.ruleVersion);
        }
    }

    void setCurrency(ArrayList<Transaction> transactions) {
        for (Transaction parsedTran : transactions) {
            parsedTran.setSpentMoney(this.currencyManager.calculateSpentMoney(parsedTran.getParsedTransaction().spentMoney, parsedTran.getParsedTransaction().currency));
        }
    }
}

