package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.text.TextUtils;

import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.AppExecutors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import jxl.CellView;
import jxl.Workbook;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.Blank;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class ExcelManager {

    WritableCellFormat titleFormat;
    enum COLUMS {
        id,
        identifier,
        cardId,
        userCategoryId,
        companyId,
        franchise,
        code,
        spentDate,
        spentMoney,
        oriSpentMoney,
        installmentCnt,
        keyword,
        repeatType,
        currency,
        dwType,
        fullSms,
        smsDate,
        smsType,
        regId,
        isOffset,
        isCustom,
        isUserUpdate,
        isUpdateAll,
        memo,
        classCode,
        isSynced,
        cardName,
        cardType,
        cardSubType,
        cardChangeName,
        cardChangeType,
        cardChangeSubType,
        billingDay,
        balance,
        cardMemo,
        cardIsExcept,
        cateIsExcept,
        large,
        medium,
        small
    }

    public static final String FILE_NAME = "ibk-visual.xls";
    private static ExcelManager mInstance = null;
    private Context mContext;
    private VisualRepository repository;
    private AppExecutors appExecutors;

    public static ExcelManager getInstance(Context ctx) {

        synchronized (ExcelManager.class) {
            if (mInstance == null) {
                mInstance = new ExcelManager(ctx.getApplicationContext());
            }
        }
        return mInstance;
    }

    public void destroy() {
        mInstance = null;
    }

    private ExcelManager(Context context) {
        this.mContext = context;
        repository = VisualRepository.getInstance(context);
        appExecutors = new AppExecutors();
        try {
            titleFormat = createTitleFormat();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File createFile() throws IOException {
        //
        File path = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS);
        if (!path.exists()) {
            path.mkdirs();
        }
        File deviceFile = new File(path, FILE_NAME);
        if (!deviceFile.exists()) {
            deviceFile.createNewFile();
        }
        return deviceFile;
    }

    private WritableCellFormat createTitleFormat() throws Exception {
        WritableFont times10pt = new WritableFont(WritableFont.ARIAL, 10);

        WritableCellFormat titleFormat = new WritableCellFormat(times10pt);
        titleFormat.setWrap(false);
        titleFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
        titleFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.WHITE);

        return titleFormat;
    }

    private WritableCellFormat createNumberFormat() throws Exception {

        WritableFont times10pt = new WritableFont(WritableFont.ARIAL, 10);

        jxl.write.NumberFormat numberFormat = new NumberFormat("###,###");

        WritableCellFormat integerFormat = new WritableCellFormat(times10pt, numberFormat);
        integerFormat.setWrap(false);
        integerFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
        integerFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.WHITE);

        return integerFormat;
    }

    private WritableCellFormat createDateTimeFormat() throws Exception {
        WritableFont times10pt = new WritableFont(WritableFont.ARIAL, 10);
        DateFormat userdatafmt = new DateFormat("yyyy-MM-DD hh:mm:ss");
        WritableCellFormat dataformat = new WritableCellFormat(times10pt, userdatafmt);
        dataformat.setWrap(false);
        dataformat.setVerticalAlignment(VerticalAlignment.CENTRE);
        dataformat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.WHITE);

        return dataformat;
    }

    public interface Callback {
        void onCompleted(File file);
    }

    public void export(final Callback completion) {

        appExecutors.diskIO().execute(new Runnable() {
            @Override
            public void run() {
                AssetManager am = mContext.getAssets();
                InputStream inStream;
                File deviceFile = null;
                try {
                    inStream = am.open(FILE_NAME);
                    Workbook tempWorkbook = Workbook.getWorkbook(inStream);

                    deviceFile = createFile();

                    // WritableWorkbook 을 visual.xls 파일을 기반으로 동일하게 생성합니다.
                    WritableWorkbook writableWorkbook = Workbook.createWorkbook(deviceFile, tempWorkbook);
                    WritableSheet excelSheet = writableWorkbook.getSheet(0);

                    addHeaders(excelSheet);

                    ArrayList<JoinedTransaction> transactions = repository.loadJoinedTransactions();

                    // 각 조건에 맞게 텍스 트변형 후 엑셀 인서트
                    int row = 1;
                    for(JoinedTransaction transaction : transactions) {

                        addLines(excelSheet, transaction, row);

                        row++;
                    }
                    writableWorkbook.write();
                    writableWorkbook.close();

                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    final File finalDeviceFile = deviceFile;
                    appExecutors.mainThread().execute(new Runnable() {
                        @Override
                        public void run() {
                            completion.onCompleted(finalDeviceFile);
                        }
                    });

                }
            }
        });


    }

    private void addLabel(WritableSheet sheet, int column, int row, String s, WritableCellFormat titleFormat, CellView cv)  {

        try {
            cv.setFormat(titleFormat);
            if(s==null|| TextUtils.isEmpty(s)){
                Blank blank = new Blank(column, row, titleFormat); // 빈 셀(열,행,포멧)
                sheet.addCell(blank);
                sheet.setColumnView(row,cv);
            } else {
                Label label;
                label = new Label(column, row, s, titleFormat);
                sheet.addCell(label);
                sheet.setColumnView(row,cv);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addNumber(WritableSheet sheet, int column, int row, int spentMoney,CellView cv, WritableCellFormat integerFormat) {

        try {
            cv.setFormat(integerFormat);
            Number number = new Number(column, row, spentMoney, integerFormat);
            sheet.addCell(number);
            sheet.setColumnView(row,cv);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDate(WritableSheet sheet, int column, int row, Calendar s, WritableCellFormat titleFormat, CellView cv, WritableCellFormat dataformat) {


        try {
            if(s == null){
                cv.setFormat(titleFormat);
                Blank blank = new Blank(column, row, titleFormat); // 빈 셀(열,행,포멧)
                sheet.addCell(blank);
                sheet.setColumnView(row,cv);

            }else{
//            hh:mm:ss

                Date now = s.getTime();
                cv.setFormat(dataformat);
                DateTime datetime = new DateTime(column, row,now,dataformat);
                sheet.addCell(datetime);
                sheet.setColumnView(row,cv);

            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void addHeaders(WritableSheet sheet) {
        int size = COLUMS.values().length;
        CellView cv = new CellView();
        cv.setAutosize(true);
        for(int column = 0 ; column < size ; column++){
            addLabel(sheet, column, 0, COLUMS.values()[column].name(), titleFormat, cv);
        }
    }

    private void addLines(WritableSheet sheet, JoinedTransaction transaction, int row){

        try {

            CellView cv = new CellView();
            cv.setAutosize(true);
            int size = COLUMS.values().length;
            for(int column = 0 ; column < size ; column++){

                switch (COLUMS.values()[column]){
                    case id:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getId(), titleFormat, cv);
                        break;
                    case identifier:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getIdentifier(), titleFormat, cv);

                        break;
                    case cardId:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getCardId(), titleFormat, cv);
                        break;

                    case userCategoryId:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getUserCategoryId(), titleFormat, cv);
                        break;

                    case companyId:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getCompanyId(), titleFormat, cv);
                        break;

                    case franchise:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getFranchise(), titleFormat, cv);
                        break;

                    case code:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getCategoryCode(), titleFormat, cv);
                        break;

                    case spentDate:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getSpentDate(), titleFormat, cv);
                        break;

                    case spentMoney:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getSpentMoney(), titleFormat, cv);
                        break;

                    case oriSpentMoney:
                        double spentMoney = transaction.getTransaction().getOriSpentMoney() == 0 ? transaction.getTransaction().getSpentMoney(): transaction.getTransaction().getOriSpentMoney();
                        addLabel(sheet, column, row, "" + spentMoney, titleFormat, cv);
                        break;

                    case installmentCnt:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getInstallmentCnt(), titleFormat, cv);
                        break;

                    case keyword:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getKeyword(), titleFormat, cv);
                        break;

                    case repeatType:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getRepeatType(), titleFormat, cv);
                        break;

                    case currency:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getCurrency(), titleFormat, cv);
                        break;

                    case dwType:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getDwType(), titleFormat, cv);
                        break;

                    case fullSms:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getFullSms(), titleFormat, cv);
                        break;

                    case smsDate:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getSmsDate(), titleFormat, cv);
                        break;

                    case smsType:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getSmsType(), titleFormat, cv);
                        break;

                    case regId:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getRegId(), titleFormat, cv);
                        break;

                    case isOffset:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().isOffset(), titleFormat, cv);
                        break;

                    case isCustom:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().isCustom(), titleFormat, cv);
                        break;

                    case isUserUpdate:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().isUserUpdate(), titleFormat, cv);
                        break;

                    case isUpdateAll:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().isUpdateAll(), titleFormat, cv);
                        break;

                    case memo:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getMemo(), titleFormat, cv);
                        break;

                    case classCode:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().getClassCode(), titleFormat, cv);
                        break;

                    case isSynced:
                        addLabel(sheet, column, row, "" + transaction.getTransaction().isSynced(), titleFormat, cv);
                        break;

                    case cardName:
                        addLabel(sheet, column, row, "" + transaction.getCard().getName(), titleFormat, cv);
                        break;

                    case cardType:
                        addLabel(sheet, column, row, "" + transaction.getCard().getType(), titleFormat, cv);
                        break;

                    case cardSubType:
                        addLabel(sheet, column, row, "" + transaction.getCard().getSubType(), titleFormat, cv);
                        break;

                    case cardChangeName:
                        addLabel(sheet, column, row, "" + transaction.getCard().getChangeName(), titleFormat, cv);
                        break;

                    case cardChangeType:
                        addLabel(sheet, column, row, "" + transaction.getCard().getChangeType(), titleFormat, cv);
                        break;

                    case cardChangeSubType:
                        addLabel(sheet, column, row, "" + transaction.getCard().getChangeSubType(), titleFormat, cv);
                        break;

                    case billingDay:
                        addLabel(sheet, column, row, "" + transaction.getCard().getBillingDay(), titleFormat, cv);
                        break;

                    case balance:
                        addLabel(sheet, column, row, "" + transaction.getCard().getBalance(), titleFormat, cv);
                        break;

                    case cardMemo:
                        addLabel(sheet, column, row, "" + transaction.getCard().getMemo(), titleFormat, cv);
                        break;

                    case cardIsExcept:
                        addLabel(sheet, column, row, "" + transaction.getCard().isExcept(), titleFormat, cv);
                        break;

                    case cateIsExcept:
                        addLabel(sheet, column, row, "" + transaction.getUserCategory().isExcept(), titleFormat, cv);
                        break;

                    case large:
                        addLabel(sheet, column, row, "" + transaction.getCategory().getLarge(), titleFormat, cv);
                        break;

                    case medium:
                        addLabel(sheet, column, row, "" + transaction.getCategory().getMedium(), titleFormat, cv);
                        break;

                    case small:
                        addLabel(sheet, column, row, "" + transaction.getCategory().getSmall(), titleFormat, cv);
                        break;
                }

            }
        } catch (Exception e){
            e.printStackTrace();
        }
    }





}
