package com.tenqube.visual_third.model.parser;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.api.AdResponse;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.notNull;

public class Advertisement implements Serializable {

    /**
     * 광고 고유 id
     */
    private int id;

    /**
     * 제목
     */
    private String title;

    /**
     * 라벨 정보
     */
    private String label;

    /**
     * 내용
     */
    private String content;

    /**
     * 연결 url
     */
    private String linkTo;

    /**
     * 이미지 URL
     */
    private String image;

    public Advertisement(AdResponse.Ad ad) throws ParameterException {

        notNull(ad);

        this.id = ad.getId();

        this.title = ad.getTitle();

        this.label = ad.getmContent();

        this.content = ad.getContent();

        this.linkTo = ad.getUrl();

        this.image = ad.getImage();

    }

    public int getId() {
        return id;
    }

    public String getTitle() {
        return title;
    }

    public String getLabel() {
        return label;
    }

    public String getContent() {
        return content;
    }

    public String getLinkTo() {
        return linkTo;
    }

    public String getImage() {
        return image;
    }
}
