/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.ExcelManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.ResourceManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.parser.PopupData;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.util.PathUtil;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.util.permission.AfterPermissionGranted;
import com.tenqube.visual_third.util.permission.PermissionUtil;
import com.tenqube.visual_third.web.ActionImpl;
import com.tenqube.visual_third.web.Completion;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.VisualInterface;
import java.io.File;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualWebActivity
extends Activity
implements TimePickerFragment.Callback,
DatePickerFragment.Callback,
PermissionUtil.PermissionCallbacks {
    public static final String ARG_PATH = "ARG_PATH";
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final int NOTIFICATION_REQUEST_CODE = 10;
    public static final int VISUAL_REQUEST_CODE = 512;
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    private PrefManager prefManager;
    private VisualApi api;
    private VisualRepository repository;
    private ResourceManager resourceManager;
    private VisualAlarmManager alarmManager;
    private boolean isPageLoaded;
    private String mFailingUrl;
    private String path;
    private WebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private VisualInterface.Action actionInterface;
    private SwipeRefreshLayout swipeRefreshLayout;
    public static String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final int STORAGE = 1;
    public Completion<Boolean> completion;

    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface", "SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            if (Utils.isSDKDisabled(this.getApplicationContext())) {
                throw new Exception("SDK disabled");
            }
            AnswerManager.initFabric((Context)this);
            AnswerManager.onKeyMetric(new LogRequest("VisualWebActivity"));
            this.api = VisualApi.getInstance(this.getApplicationContext());
            this.repository = VisualRepository.getInstance(this.getApplicationContext());
            this.prefManager = PrefManager.getInstance(this.getApplicationContext());
            this.resourceManager = ResourceManager.getInstance(this.api, this.prefManager, ParserService.getInstance((Context)this.getApplicationContext()));
            this.alarmManager = VisualAlarmManager.getInstance(this.getApplicationContext());
            this.path = this.getIntent().getStringExtra(ARG_PATH);
            LogUtil.LOGI((String)"PATH", (String)this.path, (boolean)true);
            this.setContentView(R.layout.activity_visual_web);
            this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_refresh_layout);
            this.swipeRefreshLayout.setEnabled(false);
            this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
            this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    VisualWebActivity.this.swipeRefreshLayout.setRefreshing(false);
                    AnalysisServiceImpl.shouldRefresh = true;
                    VisualWebActivity.this.webview.reload();
                }
            });
            this.webview = (WebView)this.findViewById(R.id.visual_web_view);
            this.errorInterface = new ErrorImpl(this, this.webview);
            this.logInterface = new LogImpl(this, this.webview, this.errorInterface);
            this.repoInterface = new RepoImpl(this, this.webview, this.errorInterface, this.repository, this.api, new AnalysisServiceImpl((Context)this, ""), this.alarmManager);
            this.uiInterface = new UiImpl(this, this.webview, this.errorInterface, new BottomDialog(this));
            this.systemInterface = new SystemImpl(this, this.webview, this.errorInterface);
            this.actionInterface = new ActionImpl(this, this.webview);
            this.webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
            this.webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
            this.webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
            this.webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
            this.webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
            this.webview.addJavascriptInterface((Object)this.actionInterface, "visualAction");
            WebViewHelper.settings(this.webview);
            this.webview.setWebViewClient(new WebViewClient(){

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    VisualWebActivity.this.mFailingUrl = failingUrl;
                    VisualWebActivity.this.loadErrorUrl();
                }
            });
            if (this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev").equals("dev")) {
                this.webview.getSettings().setCacheMode(2);
            }
            this.alarmManager.setAlarms();
            this.resourceManager.sync();
            this.loadUrl(this.path);
            this.syncSearchFailedTransactions();
        }
        catch (Exception e) {
            this.finish();
        }
    }

    public void onPagedLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.isPageLoaded = true;
            }
        });
    }

    private void loadUrl(String path) {
        if (this.webview != null) {
            this.isPageLoaded = false;
            if (path == null) {
                path = "";
            }
            String url = WebViewHelper.getBaseUrl(this.prefManager) + path;
            this.webview.loadUrl(url);
        }
    }

    private void loadErrorUrl() {
        this.isPageLoaded = false;
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setEnabled(false);
        }
        if (this.webview != null) {
            this.webview.loadUrl("file:///android_asset/index.html");
        }
    }

    private void syncSearchFailedTransactions() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SearchCompanyRequest request = VisualWebActivity.this.repository.loadFailedSearchTransactions();
                if (request != null) {
                    VisualWebActivity.this.api.searchCompany(request);
                }
                VisualWebActivity.this.api.syncTransactions(null);
            }
        }).start();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 10: {
                boolean isEnabled = Utils.isNotiEnabled(this.getApplicationContext());
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("isNotiEnabled", isEnabled);
                    String json = jsonObject.toString();
                    if (this.systemInterface == null) break;
                    this.systemInterface.onNotiCallback(json);
                    break;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void onBackPressed() {
        try {
            if (this.isPageLoaded && this.uiInterface != null) {
                this.uiInterface.onFinish();
            } else {
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }

    public void onResume() {
        super.onResume();
        this.overridePendingTransition(0, 0);
    }

    public void onPause() {
        super.onPause();
        this.overridePendingTransition(0, 0);
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.uiInterface.onCalendar(date, callback);
    }

    public void onScrollChanged(int pos) {
    }

    public void setRefreshEnabled(final boolean enabled) {
        this.swipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.swipeRefreshLayout.setEnabled(enabled);
            }
        });
    }

    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.reload();
                }
            });
        }
    }

    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.loadUrl(VisualWebActivity.this.mFailingUrl);
                }
            });
        }
    }

    public void exportExcel(Completion<Boolean> completion) {
        this.completion = completion;
        this.exportExcel();
    }

    @AfterPermissionGranted(value=1)
    public void exportExcel() {
        if (PermissionUtil.hasPermissions((Context)this, PERMISSIONS_STORAGE)) {
            ExcelManager.getInstance((Context)this).export(new ExcelManager.Callback(){

                @Override
                public void onCompleted(File file) {
                    boolean isSuccess;
                    boolean bl = isSuccess = file != null;
                    if (isSuccess) {
                        String applicationId = VisualWebActivity.this.prefManager.loadStringValue("TENQUBE_APPLICATION_ID", VisualWebActivity.this.getApplicationContext().getPackageName());
                        try {
                            Intent intent = new Intent("android.intent.action.SEND");
                            intent.setType("application/octet-stream");
                            intent.putExtra("android.intent.extra.STREAM", (Parcelable)Utils.getUri(VisualWebActivity.this.getApplicationContext(), applicationId, file));
                            VisualWebActivity.this.startActivity(intent);
                            Toast.makeText((Context)VisualWebActivity.this.getApplicationContext(), (CharSequence)VisualWebActivity.this.getString(R.string.export_excel_success_msg, new Object[]{file.getName()}), (int)0).show();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            String log = "pkgName:" + applicationId + "\n FileProvider Error";
                            Toast.makeText((Context)VisualWebActivity.this.getApplicationContext(), (CharSequence)log, (int)0).show();
                            VisualWebActivity.this.completion.onDataLoaded(false);
                            return;
                        }
                    }
                    VisualWebActivity.this.completion.onDataLoaded(isSuccess);
                }
            });
        } else {
            PermissionUtil.requestPermissions(this, 1, PERMISSIONS_STORAGE);
        }
    }

    @Override
    public void onPermissionsGranted(int requestCode, List<String> list) {
        if (requestCode == 1) {
            this.exportExcel();
        }
    }

    @Override
    public void onPermissionsDenied(int requestCode, List<String> list) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\uc5d1\uc140 \ud30c\uc77c \ub0b4\ubcf4\ub0b4\uae30\ub97c \uc704\ud574 \uc678\ubd80 \uc800\uc7a5\uc18c\uc5d0 \ub300\ud55c \uad8c\ud55c\uc774 \ud544\uc694\ud569\ub2c8\ub2e4. \uad8c\ud55c\uc774 \uc5c6\ub294 \uacbd\uc6b0 \uc5d1\uc140 \ud30c\uc77c \ub0b4\ubcf4\ub0b4\uae30 \uc0ac\uc6a9\uc774 \ubd88\uac00\ud569\ub2c8\ub2e4.", (int)0).show();
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    public static void startActivity(Activity activity, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance((Context)activity).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent((Context)activity, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(0x4020000);
        activity.startActivityForResult(intent, 512);
    }

    public static void startActivity(Context context, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(335675392);
        context.startActivity(intent);
    }

    public static void startActivity(@NonNull Context context, @NonNull PopupData popupData) throws AuthException, ParameterException {
        Validator.notNull(context);
        Validator.notNull(popupData);
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, PathUtil.makePath(popupData));
        intent.addFlags(335675392);
        context.startActivity(intent);
    }
}

