/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.web;

import android.app.Fragment;
import android.app.FragmentManager;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.ui.ActivityCallback;
import com.tenqube.visual_third.ui.NotiCatchDialogFragment;
import com.tenqube.visual_third.ui.NotiIntroActivity;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import com.tenqube.visual_third.web.Base;
import com.tenqube.visual_third.web.VisualInterface;

public class SystemImpl
extends Base
implements VisualInterface.System {
    private String callbackNoti;

    public SystemImpl(ActivityCallback activity, WebView webView, VisualInterface.Error error) {
        super(activity, webView, error);
    }

    @Override
    public void onNotiCallback(String json) {
        this.callbackWithStr(this.callbackNoti, json);
    }

    @Override
    @JavascriptInterface
    public void startNotiListener(String callback) {
        String funcName = "startNotiListener";
        try {
            this.callbackNoti = callback;
            if (this.isNotiEnabled()) {
                this.goNotiSettings(this.callbackNoti);
            } else {
                FragmentManager fragmentManager;
                NotiCatchDialogFragment notiCatchDialogFragment = NotiCatchDialogFragment.newInstance("");
                notiCatchDialogFragment.setCallback(new NotiCatchDialogFragment.Callback(){

                    @Override
                    public void onClickNext() {
                        SystemImpl.this.goNotiSettings(SystemImpl.this.callbackNoti);
                    }
                });
                if (!notiCatchDialogFragment.isAdded() && (fragmentManager = this.activity.getActivity().getFragmentManager()) != null) {
                    fragmentManager.beginTransaction().add((Fragment)notiCatchDialogFragment, NotiCatchDialogFragment.TAG).commitAllowingStateLoss();
                }
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void goNotiSettings(String callback) {
        String funcName = "goNotiSettings";
        try {
            Validator.isStr(callback, 100);
            this.callbackNoti = callback;
            try {
                Intent i = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
                this.activity.getActivity().startActivityForResult(i, 10);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Intent intent = new Intent(SystemImpl.this.activity.getContext(), NotiIntroActivity.class);
                        SystemImpl.this.activity.getActivity().startActivity(intent);
                    }
                }, 500L);
            }
            catch (ActivityNotFoundException e) {
                this.onError(funcName, e.toString());
            }
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public boolean isNotiEnabled() {
        String funcName = "isNotiEnabled";
        try {
            return Utils.isNotiEnabled(this.activity.getContext());
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
            return false;
        }
    }

    @Override
    @JavascriptInterface
    public boolean isNetworkConnected() {
        String funcName = "isNetworkConnected";
        try {
            ConnectivityManager cm = (ConnectivityManager)this.activity.getActivity().getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            return isConnected;
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
            return true;
        }
    }
}

