package com.tenqube.visual_third.web;

import android.text.TextUtils;
import android.webkit.WebView;

import com.tenqube.visual_third.ui.ActivityCallback;

import static com.tenqube.visual_third.util.Utils.toJson;

public class Base {

    final ActivityCallback activity;
    final WebView webView;
    final VisualInterface.Error error;

    public Base(ActivityCallback activity, WebView webView, VisualInterface.Error error) {
        this.activity = activity;
        this.webView = webView;
        this.error = error;
    }


    String getJs(String callback, String data) {
        if(!TextUtils.isEmpty(data)) data = "'" + data + "'";
        return "javascript:window." + callback + "(" + data + ");";
    }


    void callback(final String callback, final Object object) {

        try {
            webView.post(new Runnable() {
                @Override
                public void run() {
                    String url = getJs(callback, object == null ? "" : toJson(object));
                    webView.loadUrl(url);
                }
            });

        } catch (Exception e) {

        }

    }

    void callbackWithStr(final String callback, final String value) {

        try {
            webView.post(new Runnable() {
                @Override
                public void run() {
                    webView.loadUrl(getJs(callback, value));
                }
            });

        } catch (Exception e) {

        }

    }


    void onError(String fucName, String msg) {
        if(error != null) error.onError(fucName, msg);
    }
}
