package com.tenqube.visual_third.api;

import com.tenqube.visual_third.api.auth.AuthService;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeaderInterceptor implements Interceptor {

    static final String AUTHORIZATION = "Authorization";
    private final AuthService authService;

    public HeaderInterceptor(AuthService authService) {
        this.authService = authService;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {

        Request.Builder builder = chain.request()
                .newBuilder()
                .addHeader(AUTHORIZATION, authService.getAccessToken()); /*preferences.getString(Constants.PREF_KEY.X_API_KEY, "")*/;

        return chain.proceed(builder.build());
    }


}
