/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.ui.NotiCatch;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.FontUtil;
import java.util.ArrayList;

public class NotiCatchDialogFragment
extends DialogFragment {
    public static final String TAG = NotiCatchDialogFragment.class.getSimpleName();
    private TextView resultTextView;
    private AppAdapter appAdapter;
    private RecyclerView recyclerView;
    private VisualRepository repository;

    public static NotiCatchDialogFragment newInstance() {
        return new NotiCatchDialogFragment();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
            View view = this.getActivity().getLayoutInflater().inflate(R.layout.dialog_noti_catch, null);
            FontUtil.setAllTextView(view);
            this.repository = VisualRepository.getInstance((Context)this.getActivity());
            builder.setView(view);
            AlertDialog dialog = builder.create();
            dialog.requestWindowFeature(1);
            dialog.setCanceledOnTouchOutside(true);
            if (dialog.getWindow() != null) {
                dialog.getWindow().requestFeature(1);
            }
            this.resultTextView = (TextView)view.findViewById(R.id.result);
            this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
            this.appAdapter = new AppAdapter();
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.appAdapter);
            new LoadTask().execute(new Void[0]);
            view.findViewById(R.id.enter).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
                        NotiCatchDialogFragment.this.getActivity().startActivityForResult(intent, 10);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        NotiCatchDialogFragment.this.dismissAllowingStateLoss();
                    }
                }
            });
            return dialog;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dismissAllowingStateLoss();
            return null;
        }
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setLayout(-1, -2);
            dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    public static class AppAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        ArrayList<NotiCatch> apps = new ArrayList();

        public void addAll(ArrayList<NotiCatch> smsList) {
            this.apps = smsList;
            this.notifyDataSetChanged();
        }

        public NotiCatchViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_noti, parent, false);
            return new NotiCatchViewHolder(v);
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            NotiCatch notiCatch = this.apps.get(position);
            NotiCatchViewHolder notiCatchViewHolder = (NotiCatchViewHolder)holder;
            notiCatchViewHolder.icon.setImageDrawable(notiCatch.getIcon());
            notiCatchViewHolder.appName.setText((CharSequence)notiCatch.getAppName());
        }

        public int getItemCount() {
            return this.apps == null ? 0 : this.apps.size();
        }

        public static class NotiCatchViewHolder
        extends RecyclerView.ViewHolder {
            private ImageView icon;
            private TextView appName;

            public NotiCatchViewHolder(View itemView) {
                super(itemView);
                this.icon = (ImageView)itemView.findViewById(R.id.icon);
                this.appName = (TextView)itemView.findViewById(R.id.app_name);
            }
        }
    }

    public class LoadTask
    extends AsyncTask<Void, Void, ArrayList<NotiCatch>> {
        protected ArrayList<NotiCatch> doInBackground(Void ... voids) {
            return NotiCatchDialogFragment.this.repository.loadNotiCatchedApps();
        }

        protected void onPostExecute(ArrayList<NotiCatch> notiCatches) {
            super.onPostExecute(notiCatches);
            NotiCatchDialogFragment.this.appAdapter.addAll(notiCatches);
            NotiCatchDialogFragment.this.resultTextView.setVisibility(notiCatches.isEmpty() ? 0 : 8);
        }
    }
}

