package com.tenqube.visual_third.ui;

import android.app.Dialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.TextView;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.ui.NotiCatch;
import com.tenqube.visual_third.repository.VisualRepository;

import java.util.ArrayList;

import static com.tenqube.visual_third.ui.VisualActivityFragment.NOTIFICATION_REQUEST_CODE;
import static com.tenqube.visual_third.util.FontUtil.setAllTextView;


public class NotiCatchDialogFragment extends DialogFragment {

    public static final String TAG = NotiCatchDialogFragment.class.getSimpleName();
    private TextView resultTextView;

    private AppAdapter appAdapter;
    private RecyclerView recyclerView;
    private VisualRepository repository;

    public NotiCatchDialogFragment() {
        super();
    }


    public static NotiCatchDialogFragment newInstance() {
        return new NotiCatchDialogFragment();
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        try {

            android.app.AlertDialog.Builder builder = new android.app.AlertDialog.Builder(getActivity());
            View view = getActivity().getLayoutInflater().inflate(R.layout.dialog_noti_catch,null);
            setAllTextView(view);

            repository = VisualRepository.getInstance(getActivity());

            builder.setView(view);
            Dialog dialog = builder.create();
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
//        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCanceledOnTouchOutside(true);
            if(dialog.getWindow() != null) dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);

            resultTextView = (TextView) view.findViewById(R.id.result);
            recyclerView = (RecyclerView) view.findViewById(R.id.recyclerView);
            appAdapter = new AppAdapter();
            recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
            recyclerView.setAdapter(appAdapter);

            new LoadTask().execute();

            view.findViewById(R.id.enter).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    try {
                        Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
                        getActivity().startActivityForResult(intent, NOTIFICATION_REQUEST_CODE);

                    } catch (Exception e) {
                        e.printStackTrace();
                    } finally {
                        dismissAllowingStateLoss();
                    }

                }
            });

            return dialog;
        } catch (Exception e) {
            e.printStackTrace();
            dismissAllowingStateLoss();
        }

        return null;

    }

    @Override
    public void onStart() {
        super.onStart();
        Dialog dialog = getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        }
    }

    public class LoadTask extends AsyncTask<Void, Void, ArrayList<NotiCatch>> {

        @Override
        protected ArrayList<NotiCatch> doInBackground(Void... voids) {

            return repository.loadNotiCatchedApps();
        }

        @Override
        protected void onPostExecute(ArrayList<NotiCatch> notiCatches) {
            super.onPostExecute(notiCatches);
            appAdapter.addAll(notiCatches);
            resultTextView.setVisibility(notiCatches.isEmpty() ? View.VISIBLE : View.GONE);
        }
    }

    public static class AppAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder>  {

        ArrayList<NotiCatch> apps = new ArrayList<>();
        public AppAdapter() {
        }

        public void addAll(ArrayList<NotiCatch> smsList) {
            this.apps = smsList;
            notifyDataSetChanged();
        }

        @Override
        public NotiCatchViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_noti, parent,false);
            return new NotiCatchViewHolder(v);
        }

        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            NotiCatch notiCatch = apps.get(position);
            NotiCatchViewHolder notiCatchViewHolder = ((NotiCatchViewHolder)holder);
            notiCatchViewHolder.icon.setImageDrawable(notiCatch.getIcon());
            notiCatchViewHolder.appName.setText(notiCatch.getAppName());

        }

        @Override
        public int getItemCount() {
            return apps == null ? 0 : apps.size();
        }

        public static class NotiCatchViewHolder extends RecyclerView.ViewHolder {

            private ImageView icon;
            private TextView appName;

            public NotiCatchViewHolder(View itemView) {
                super(itemView);
                icon = (ImageView)itemView.findViewById(R.id.icon);
                appName = (TextView)itemView.findViewById(R.id.app_name);

            }
        }
    }

}
