package com.tenqube.visual_third.repository;

import android.content.Context;
import android.util.SparseArray;

import com.tenqube.visual_third.db.DatabaseHelper;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.dao.ContentsDao;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.Content;
import com.tenqube.visual_third.entity.JoinedContent;
import com.tenqube.visual_third.model.api.AnalysisResponse;

import java.util.ArrayList;

import static com.tenqube.visual_third.util.Utils.isEmpty;

public class AnalysisRepository {

    private static AnalysisRepository mInstance;
    private final ContentsDao contentsDao;

    public static AnalysisRepository getInstance(Context context){
        synchronized (AnalysisRepository.class) {
            if(mInstance == null){
                mInstance = new AnalysisRepository(context);
            }
        }
        return mInstance;
    }

    private AnalysisRepository(Context context) {
        DatabaseHelper dbHelper = DatabaseHelper.getInstance(context);
        Db db = new Db(dbHelper.getWritableDatabase(), dbHelper.getReadableDatabase());
        this.contentsDao = new ContentsDao(db);
    }

    public ArrayList<JoinedContent> loadContents() {
        ArrayList<Content>  contents = contentsDao.loadContents();
        SparseArray<ArrayList<Condition>> conditionMaps = contentsDao.loadConditions();
        ArrayList<JoinedContent> results = new ArrayList<>();

        for(Content content : contents) {
            results.add(new JoinedContent(content, conditionMaps.get(content.getId())));
        }

        return results;
    }

    public void mergeAnalysis(ArrayList<AnalysisResponse.Content> contents) {
        for(AnalysisResponse.Content content : contents) {

            if(content.getEnable() == 0) {
                this.contentsDao.deleteContent(content.getId());
            } else {
                this.contentsDao.mergeContent(content);

                if(!isEmpty(content.getConditions())) {
                    for(AnalysisResponse.Condition condition : content.getConditions()) {
                        if(condition.getEnable() == 0) {
                            this.contentsDao.deleteCondition(condition.getId());
                        } else {
                            this.contentsDao.mergeCondition(condition);
                        }
                    }
                }
            }

        }
    }
}
