package com.tenqube.visual_third.util;

import com.tenqube.visual_third.BuildConfig;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.manager.PrefManager;

public class WebViewHelper {


    public static String getBaseUrl(PrefManager prefManager) {
        String url = prefManager.loadStringValue(PrefManager.WEB_URL, "") + "/#v=" + BuildConfig.WEB_VERSION;
        return url;
    }

    public static String getPopupUrl(PrefManager prefManager) {
        String url = prefManager.loadStringValue(PrefManager.WEB_URL, "") + "/receipt/#v=" + BuildConfig.WEB_VERSION;
        return url;
    }

    public static String getProgressUrl(PrefManager prefManager, Constants.ProgressType progressType) {
        String url = prefManager.loadStringValue(PrefManager.WEB_URL, "") + "/loading/#v=" + BuildConfig.WEB_VERSION + "&type=" + progressType.name;
        return url;
    }
}
