/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.analysis;

import com.tenqube.visual_third.analysis.AnalysisHelper;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.Morning;
import com.tenqube.visual_third.model.analysis.Transaction;
import java.util.ArrayList;
import java.util.HashMap;

public class MonthlyAnalysis
implements Runnable {
    private final int before;
    private final ArrayList<Transaction> transactions;
    public String monthStr;
    public HashMap<String, AggregationValue> month;
    public HashMap<String, AggregationValue> cardType;
    double samePeriodSum;
    public HashMap<String, AggregationValue> lcode;
    public HashMap<String, AggregationValue> mcode;
    public HashMap<String, AggregationValue> fastfood;
    public Transaction maxTransaction;
    Morning morningCoffeeSum;
    Morning morningTaxiSum;

    public MonthlyAnalysis(ArrayList<Transaction> transactions, int before) {
        this.transactions = transactions;
        this.before = before;
    }

    @Override
    public void run() {
        this.monthStr = AnalysisHelper.getMonth(this.before) + "";
        ArrayList<Transaction> filteredTransactions = AnalysisHelper.filterTransactions(this.transactions, this.before);
        this.month = AnalysisHelper.aggregate(filteredTransactions, 0);
        if (this.before != 0) {
            this.samePeriodSum = AnalysisHelper.getSamePeriodSum(filteredTransactions, this.before);
        }
        this.cardType = AnalysisHelper.aggregate(filteredTransactions, 4);
        if (this.before == 0) {
            this.maxTransaction = AnalysisHelper.getMaxKeyword(filteredTransactions);
        }
        this.lcode = AnalysisHelper.aggregate(filteredTransactions, 2);
        this.mcode = AnalysisHelper.aggregate(filteredTransactions, 3);
        this.fastfood = AnalysisHelper.aggregate(AnalysisHelper.filterTransactionsMcode(filteredTransactions, 2212), 6);
        this.morningCoffeeSum = AnalysisHelper.getMorningSum(filteredTransactions, 2411);
        this.morningTaxiSum = AnalysisHelper.getMorningSum(filteredTransactions, 6216);
    }
}

