/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.parser.catcher.SMSTestCatcher;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualActivityFragment;
import com.tenqube.visual_third.util.ActivityUtils;
import com.tenqube.visual_third.util.Validator;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    private Context context;
    private ParserService parserService;
    private VisualRepository repository;
    private VisualAlarmManager alarmManager;
    private boolean isDoingStartVisual;

    public VisualServiceImpl(@NonNull Context context, String apiKey, String qualifier) throws ParameterException {
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            throw new ParameterException("apiKey is null");
        }
        if (TextUtils.isEmpty((CharSequence)qualifier) || !"dev".equals(qualifier) && !"prod".equals(qualifier)) {
            throw new ParameterException("check qualifier value (dev, prod)");
        }
        this.context = context;
        this.alarmManager = VisualAlarmManager.getInstance(context);
        this.parserService = ParserService.getInstance((Context)context);
        this.repository = VisualRepository.getInstance(context);
        this.repository.saveSDKInfo(apiKey, qualifier);
        this.registerTestCatcher();
    }

    private void registerTestCatcher() {
        SMSTestCatcher smsTestCatcher = new SMSTestCatcher();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("ACTION_VISUAL_SMS_TEST");
        if (this.context != null) {
            this.context.registerReceiver((BroadcastReceiver)smsTestCatcher, intentFilter);
        }
    }

    @Override
    public void startVisual(@NonNull AppCompatActivity activity, int containerId, boolean isBackStack, @NonNull String uid, @NonNull String path) throws ParameterException, SecurityException {
        LogUtil.LOGI((String)TAG, (String)"\uc6f9 \uac00\uacc4\ubd80 \ud638\ucd9c", (boolean)ParserService.mIsDebug);
        try {
            if (this.isDoingStartVisual) {
                return;
            }
            this.isDoingStartVisual = true;
            Validator.notNull(activity);
            Validator.notNull(path);
            Validator.notZero(containerId);
            this.checkSMSPermission();
            AnswerManager.onKeyMetric(new LogRequest("startVisual"));
            ActivityUtils.addFragmentToActivity(activity.getSupportFragmentManager(), VisualActivityFragment.newInstance(uid, path), containerId, VisualActivityFragment.TAG, isBackStack);
        }
        catch (ParameterException | SecurityException e) {
            throw e;
        }
        finally {
            this.isDoingStartVisual = false;
        }
    }

    @Override
    public void setDeepLink(String url) {
        this.repository.setDeepLink(url);
    }

    @Override
    public boolean isActiveTranPopup() {
        AnswerManager.onKeyMetric(new LogRequest("isActiveTranPopup"));
        return this.repository.shouldShowTranPopup();
    }

    @Override
    public void setTranPopup(boolean isActive) {
        AnswerManager.onKeyMetric(new LogRequest("setTranPopup"));
        this.repository.setTranPopup(isActive);
    }

    private void checkSMSPermission() throws SecurityException {
        if (!this.repository.isExecutedBulk() && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.RECEIVE_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.RECEIVE_MMS") != 0) {
            throw new SecurityException("Please grant permissions (Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS, Manifest.permission.RECEIVE_MMS)");
        }
    }

    @Override
    public void setDebugMode(boolean isDebug) {
        LogUtil.LOGI((String)TAG, (String)"setDebugMode", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.setDebugMode(isDebug);
        }
    }

    @Override
    public void initSDK() {
        LogUtil.LOGI((String)TAG, (String)"initSDK", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.initDb();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.repository.setEnabled(enabled);
    }

    @Override
    public void settingNotification(int smallIcon, @NonNull String channel, int color2) throws ParameterException {
        Validator.notZero(smallIcon);
        Validator.notNull(channel);
        this.repository.settingNotification(smallIcon, channel, color2);
    }

    @Override
    public void setMonthlyNoti(boolean isActive) {
        this.repository.setActiveNoti("monthly", isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveMonthlyNoti() {
        return this.repository.isActiveNoti("monthly");
    }

    @Override
    public void setWeeklyNoti(boolean isActive) {
        this.repository.setActiveNoti("weekly", isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveWeeklyNoti() {
        return this.repository.isActiveNoti("weekly");
    }

    @Override
    public void setDailyNoti(boolean isActive) {
        this.repository.setActiveNoti("daily", isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveDailyNoti() {
        return this.repository.isActiveNoti("daily");
    }

    @Override
    public void setReportTest(String type, int second) {
        VisualAlarmManager.getInstance(this.context).setReportTest(type, second);
    }

    private boolean isActive() {
        return this.context != null;
    }
}

