package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import android.os.Handler;
import android.support.v4.app.NotificationManagerCompat;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.Lv0DataCache;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.ui.TransactionPopupActivity;
import com.tenqube.visual_third.util.Mapper;

import java.util.ArrayList;
import java.util.Calendar;

import tenqube.parser.model.ParserResult;
import tenqube.parser.model.ResultCode;
import tenqube.parser.model.SMS;
import tenqube.parser.model.Transaction;

import static com.tenqube.visual_third.Constants.SAMSUNG_PAY;
import static com.tenqube.visual_third.util.Mapper.toLv0s;
import static com.tenqube.visual_third.util.Utils.isEmpty;
import static com.tenqube.visual_third.util.Utils.shouldParsing;
import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

/**
 * SMS or MMS or NOTI 수신시 실행
 *
 */
public class OneLoader extends BaseLoader {

    private static final String TAG = OneLoader.class.getSimpleName();
    private static OneLoader mInstance = null;
    private AdManager adManager;
    private int mServerCnt = 0;
    private AnalysisService analysisService;

    private OneLoader(Context context) {
        super(context);
        adManager = AdManager.getInstance(context);
        analysisService = new AnalysisServiceImpl(mContext, "");

    }

    /**
     * ParserResult의 코드에따라서 파싱된내역 서버전송, 파싱룰 동기화 안잡힌거 전송으로 분기
     *
     * @param sms 문자 데이터
     */
    public synchronized void doParsing(final SMS sms) {

        new Thread(new Runnable() {
            @Override
            public void run() {

                LOGI(TAG, "doParsing" + sms.toString(), mIsDebug);

                // 파싱
                ParserResult parserResult = parserService.parse(sms);

                // 실패하고 삼성페이인경우 title 로 파싱
                if (parserResult.resultCode != ResultCode.SEND_TO_SERVER &&
                        SAMSUNG_PAY.equals(sms.getSender())) {


                    SMS newSMS = new SMS(sms.getSmsId(),
                            sms.getTitle(),
                            sms.getSender(),
                            sms.getDisplaySender(),
                            sms.getSmsDate(),
                            sms.getSmsType(),
                            sms.getTitle());

                    parserResult = parserService.parse(newSMS);

                }

                // 파싱 결과에 따른 분기
                LOGI(TAG, "parserResult" + (parserResult.resultCode) + ResultCode.stringValueOf(parserResult.resultCode), mIsDebug);

                switch (parserResult.resultCode) {
                    case ResultCode.NEED_TO_SYNC_PARSING_RULE:
                        syncParsingRule(null);
                        break;

                    case ResultCode.NEED_TO_SYNC_PARSING_RULE_NO_SENDER:
                        if (shouldParsing(sms.getFullSms())) syncParsingRuleAndNoSender();
                        break;

                    case ResultCode.NEED_TO_SEND_TO_SERVER:
                        break;

                    case ResultCode.SEND_TO_SERVER:
                        parsedSMS(parserResult.transactions);
                        break;

                }

            }
        }).start();

    }

    private void syncParsingRuleAndNoSender() {
        mServerCnt++;
        if (mServerCnt == 10) {
            mServerCnt = 0;
            syncParsingRule(null);
        }
    }

    public static OneLoader getInstance(Context context) {
        synchronized (OneLoader.class) {
            if (mInstance == null) {
                mInstance = new OneLoader(context.getApplicationContext());
            }
        }
        return mInstance;
    }

    /**
     * 파싱된 경우
     * 결과값 저장 및 파싱된 내역 구글 캘린더 알림 노출 등 기존 로직 처리
     *
     * @param parsedTransactions 파싱된 내역
     */
    private void parsedSMS(ArrayList<Transaction> parsedTransactions) {

        try {
            ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions = Mapper.toParserTransactions(parsedTransactions);

            final com.tenqube.visual_third.model.parser.Transaction currentTran = getCurrentTransaction(transactions);

            if (currentTran == null|| currentTran.getParsedTransaction()== null) return;

            // 위치정보 추가
            addLocationInfo(currentTran);

            // 환율
            setCurrency(transactions);

            // 내역 합치기
            repository.mergeTransactions(transactions);

            final int tranId = repository.loadTranId(currentTran.getParsedTransaction().identifier);
            if(tranId == 0) return;

            // 기존 일괄 적용 확인 currentTran
            com.tenqube.visual_third.entity.Transaction applyAllTran = repository.loadApplyAllTran(currentTran.getParsedTransaction().keyword);

            SearchCompanyResponse searchCompanyResponse = null;

            if (applyAllTran != null) { // 서버 검색 요청 없이 사용자 내역으로 생성
                ArrayList<SearchCompanyResponse.TranCompany> results = new ArrayList<>();
                SearchCompanyResponse.Company company = new SearchCompanyResponse.Company(applyAllTran.getCompanyId(), applyAllTran.getFranchise(), "");
                SearchCompanyResponse.Category category = new SearchCompanyResponse.Category(applyAllTran.getCategoryCode() + "");
                SearchCompanyResponse.Keyword keyword = new SearchCompanyResponse.Keyword(applyAllTran.getKeyword(), applyAllTran.getSearchKeyword());
                SearchCompanyResponse.TranCompany tranCompany = new SearchCompanyResponse.TranCompany("" + applyAllTran.getIdentifier(), applyAllTran.getClassCode(), company, category, keyword);
                results.add(tranCompany);
                searchCompanyResponse = new SearchCompanyResponse(results);

            } else { // 서버 검색요청
                ArrayList<SearchCompanyRequest.Transaction> apiTransactions = Mapper.toSearchTransaction(transactions);
                if(!isEmpty(apiTransactions)) {
                    searchCompanyResponse = repository.searchCompany(new SearchCompanyRequest(apiTransactions));
                }
            }

            if(searchCompanyResponse != null)
                repository.updateTransactions(searchCompanyResponse);

            // 팝업 띄움. current Tran && 중복 아닌경
            if (currentTran.getParsedTransaction().isDuplicate == 0) {
                final SearchCompanyResponse.TranCompany searchedCompany =
                        findSearchedCompany(searchCompanyResponse, currentTran.getParsedTransaction());

                JoinedTransaction joinedTransaction = loadTransaction(tranId);

                loadLv0();

                startTranPopup(joinedTransaction, searchedCompany);

            }
            repository.syncTransactions(null);
            AnalysisServiceImpl.shouldRefresh = true;
            repository.onTransactionReceived(tranId);

        } catch (Exception e) {

        }

    }

    private void loadLv0() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(Calendar.YEAR);
        int month = calendar.get(Calendar.MONTH) + 1;

        TransactionRequest request = new TransactionRequest(year, month, 3, "");
        request.setDwType(tenqube.parser.constants.Constants.DWType.WITHDRAW.ordinal());
        request.setExceptType(0);

        ArrayList<com.tenqube.visual_third.model.analysis.Transaction> transactions = repository.loadAnalysisTransactions(request);

        Lv0DataCache.getInstance().lv0s = toLv0s(analysisService.loadAnalysisList(transactions, true));

    }

    private JoinedTransaction loadTransaction(int tranId) {
        return repository.loadJoinedTransaction(tranId);
    }

    private Category getDefaultCategory(boolean isDeposit, boolean isBank) {
        if(isDeposit) {

            return new Category(451, 901010, "기타수입", "기타", "일반");
        } else {

            if(isBank) {
                return new Category(444,	841010, "출금", "기타", "일반");

            } else {
                return new Category(72, 101010, "미분류", "기타", "일반");
            }
        }
    }

    private SearchCompanyResponse.TranCompany getDefaultTranCompany(final Transaction currentTran) {

        boolean isDeposit = currentTran.dwType == tenqube.parser.constants.Constants.DWType.DEPOSIT.ordinal();
        boolean isBank = currentTran.cardType == tenqube.parser.constants.Constants.CardType.BANK_ACCOUNT.ordinal();
        SearchCompanyResponse.Keyword keyword = new SearchCompanyResponse.Keyword(currentTran.keyword, currentTran.keyword);

        String identifier = currentTran.identifier;

        SearchCompanyResponse.Company company;
        SearchCompanyResponse.Category category;

        String classCode;

        if(isDeposit) {
            company = new SearchCompanyResponse.Company(Constants.COMPANY_ID.DEPOSIT_ETC, "기타", "");

            category = new SearchCompanyResponse.Category("" + Constants.CATEGORY_CODE.DEPOSIT_ETC);

            classCode = "DP";


        } else {
            if(isBank) {
                company = new SearchCompanyResponse.Company(Constants.COMPANY_ID.WITHDRAW_ETC, "기타", "");

                category = new SearchCompanyResponse.Category("" + Constants.CATEGORY_CODE.WITHDRAW_ETC);

                classCode = "WFDW";

            } else {
                company = new SearchCompanyResponse.Company(Constants.COMPANY_ID.UNCATE_ETC, "미분류", "");

                category = new SearchCompanyResponse.Category("" + Constants.CATEGORY_CODE.UNCATE_ETC);

                classCode = "NF";

            }
        }

        return new SearchCompanyResponse.TranCompany(identifier, classCode, company, category, keyword);

    }

    private com.tenqube.visual_third.model.parser.Transaction getCurrentTransaction(ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions) {

        for (com.tenqube.visual_third.model.parser.Transaction transaction : transactions) {

            if (transaction.getParsedTransaction().isCurrentTran) {
                return transaction;
            }
        }
        return null;
    }

    private void addLocationInfo(com.tenqube.visual_third.model.parser.Transaction currentTran) {
        currentTran.getParsedTransaction().spentLatitude = -1;
        currentTran.getParsedTransaction().spentLongitude = -1;
    }

    /**
     * 파싱 결과 팝업
     */
    private SearchCompanyResponse.TranCompany findSearchedCompany(final SearchCompanyResponse searchCompanyResponse, Transaction currentTran) {

        if(searchCompanyResponse != null && currentTran != null) {
            for (SearchCompanyResponse.TranCompany company : searchCompanyResponse.getResults()) {
                if (company.getIdentifier().equals(currentTran.identifier)) {
                    return company;
                }
            }
        }

        return getDefaultTranCompany(currentTran);

    }

    private void startTranPopup(final JoinedTransaction joinedTransaction,
                                final SearchCompanyResponse.TranCompany company) {

        new Handler(mContext.getMainLooper()).post(new Runnable() {
            public void run() {
                if(repository.isAppNoti() &&
                        repository.isActiveTranPopup() &&
                        NotificationManagerCompat.from(mContext).areNotificationsEnabled()) {
                    new Handler(mContext.getMainLooper()).post(new Runnable() {
                        public void run() {
                            try {
                                TransactionPopupActivity.start(mContext, new TransactionPopupInfo(joinedTransaction, company));
                            } catch (AuthException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        });
    }

}