package com.tenqube.visual_third.analysis;

import android.text.TextUtils;
import android.util.SparseArray;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.entity.JoinedContent;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.CategoryAvg;
import com.tenqube.visual_third.model.analysis.CategoryMax;
import com.tenqube.visual_third.model.analysis.Result;
import com.tenqube.visual_third.model.analysis.TopN;
import com.tenqube.visual_third.model.analysis.Transaction;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

import static com.tenqube.visual_third.Constants.ALCOHOL_TYPE;
import static com.tenqube.visual_third.Constants.ALCOHOL_TYPE_IMAGE;
import static com.tenqube.visual_third.Constants.CNT;
import static com.tenqube.visual_third.Constants.COFFEE_TYPE_COUNTRY;
import static com.tenqube.visual_third.Constants.COFFEE_TYPE_COUNTRY_AMOUNT;
import static com.tenqube.visual_third.Constants.MCODE.ALCOHOL;
import static com.tenqube.visual_third.Constants.SUM;
import static com.tenqube.visual_third.analysis.AnalysisHelper.desc;
import static com.tenqube.visual_third.analysis.AnalysisHelper.descCate;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getAggregate;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getAggregatedTranIds;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getCoffeeCountry;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getFuncAmount;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getLv0Currency;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getPercent;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getPercentValue;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getTranIds;
import static com.tenqube.visual_third.util.Utils.getDiffDay;
import static com.tenqube.visual_third.util.Utils.isEmpty;
import static tenqube.parser.constants.Constants.CardType.CARD;
import static tenqube.parser.constants.Constants.CardType.CASH;
import static tenqube.parser.constants.Constants.CardType.CHECK;

public class FunctionMap {

    /**
     * keys
     */
    private static final int month_0 = 1;
    private static final int month_0_sum = 2;
    private static final int month_0_cnt = 3;
    private static final int month_0_avg = 4;
    private static final int month_0_sum_credit = 5;
    private static final int month_0_sum_check = 6;
    private static final int month_0_sum_cash = 7;


    private static final int month_1 = 28;
    private static final int month_1_sum = 29;
    private static final int month_1_cnt = 30;

    private static final int month_1_avg = 31;
    private static final int month_1_sum_same_period = 32;
    private static final int month_1_sum_credit = 33;
    private static final int month_1_sum_check = 34;
    private static final int month_1_sum_cash = 35;


    private static final int month_1_mid_alcohol_sum = 54;
    private static final int month_1_mid_coffee_sum = 55;
    private static final int month_1_mid_mart_sum = 56;
    private static final int month_1_mid_convenience_sum = 57;

    private static final int month_1_mid_alcohol_cnt = 68;

    private static final int month_2 = 69;
    private static final int month_2_sum = 70;
    private static final int month_2_cnt = 71;
    private static final int month_2_avg = 72;


    private static final int month_2_mid_alcohol_sum = 95;
    private static final int month_2_mid_coffee_sum = 96;
    private static final int month_2_mid_mart_sum = 97;
    private static final int month_2_mid_convenience_sum = 98;

    private static final int month_3 = 99;
    private static final int month_3_sum = 100;
    private static final int month_3_cnt = 101;
    private static final int month_3_avg = 102;

    private static final int month_3_mid_alcohol_sum = 125;
    private static final int month_3_mid_coffee_sum = 126;
    private static final int month_3_mid_mart_sum = 127;
    private static final int month_3_mid_convenience_sum = 128;

    private static final int three_month_mid_alcohol_sum = 129;
    private static final int three_month_mid_coffee_sum = 130;

    private static final int three_month_mid_mart_sum = 131;
    private static final int three_month_mid_convenience_sum = 132;
    private static final int three_month_mid_coffee_cnt = 133;
    private static final int three_month_mid_coffee_country = 134;
    private static final int three_month_mid_taxi_sum = 135;
    private static final int three_month_mid_taxi_am_sum = 136;
    private static final int three_month_book_sum = 137;


    private static final int last_hospital_date = 164;
    private static final int last_movie_date = 165;
    private static final int last_movie_keyword = 166;
    private static final int three_month_movie_cnt = 167;
    private static final int last_nail_date = 168;
    private static final int last_nail_keyword = 169;
    private static final int three_month_nail_cnt = 170;
    private static final int last_hair_date = 171;
    private static final int last_hair_keyword = 172;
    private static final int three_month_hair_avg_cnt = 173;
    private static final int yesterday_sum = 174;

    private static final int yesterday_max_keyword = 175;
    private static final int yesterday_max_spent_money = 176;
    private static final int three_month_mid_coffee_am_sum = 177;
    private static final int three_month_mid_coffee_country_value = 178;
    private static final int last_hair_diff_day = 179;
    private static final int last_nail_diff_day = 180;
    private static final int last_hospital_diff_day = 181;
    private static final int last_movie_diff_day = 182;

    private static final int three_month_large_food_cnt = 186;
    private static final int three_month_mid_fastfood_cnt = 188;
    private static final int three_month_mid_fastfood_percent = 189;


    private static final int past_day = 196;
    private static final int today = 200;
    private static final int month_1_mid_taxi_sum = 201;
    private static final int month_1_alcohol_type = 204;
    private static final int user_sex = 205;

    private static final int month_0_same_period_percent = 206;
    private static final int month_0_mid_coffee_sum = 207;
    private static final int yesterday_alcohol_sum = 208;

    private static final int three_month_avg = 214;

    private static final int three_month_mid_coffee_week_avg = 216;
    private static final int month_2_mid_taxi_sum = 219;
    private static final int month_3_mid_taxi_sum = 223;
    private static final int three_month_sum = 224;
    private static final int month_0_same_period_more_or_less_str = 225;
    private static final int month_1_same_period_end_day = 226;

    private static final int three_month_book_diff_sum = 227;
    private static final int month_1_alcohol_type_image_name = 229;
    private static final int three_month_week_avg = 230;
    private static final int three_month_day_avg = 231;
    private static final int week_0_sum = 232;
    private static final int week_1_sum = 233;
    private static final int week_1_percent = 234;
    private static final int yesterday_max_sum = 236;
    private static final int day_of_week = 237;
    private static final int same_period_image = 239;

    private static final int fastfood_top_n = 241;

    private static final int large_top_n = 242;

    private static final int max_date = 243;
    private static final int max_date_sum = 263;
    private static final int max_date_keyword = 244;

    private static final int last_max_date = 245;
    private static final int last_max_date_sum = 264;
    private static final int last_max_date_keyword = 246;

    private static final int threemonth_credit_sum = 247;
    private static final int threemonth_str = 248;

    private static final int threemonth_sum_by_card_type = 249;
    private static final int threemonth_avg_by_category = 252;

    private static final int cac_sum = 253;
    private static final int cac_percent = 254;
    private static final int cac_same_period = 255;
    private static final int cac_percent_by_category = 256;
    private static final int last_cac_sum = 265;

    private static final int max_coffee_date = 266;
    private static final int month_0_mid_coffee_cnt = 267;

    public static final SparseArray<Result> values = new SparseArray<>();
    static final SparseArray<ArrayList<Integer>> tranIds = new SparseArray<>();

    public static final int LV0 = 0;
    public static final int NORMAL = 1;
    public static final int FIRSTDOT = 2;
    public static final int PERCENT = 3;
    public static final int CNT_UNIT = 4;

    private MonthlyAnalysis monthlyAnalysis0, monthlyAnalysis1, monthlyAnalysis2, monthlyAnalysis3;

    private WeeklyAnalysis weeklyAnalysis0, weeklyAnalysis1;

    private DailyAnalysis dailyAnalysis1;

    private LastSpentAnalysis movie, nail, hair, hospital;

    private int divider = 3;

    void calculate(ArrayList<Transaction> transactions) throws Exception {

        Thread[] threads = new Thread[11];
        monthlyAnalysis0 = new MonthlyAnalysis(transactions, 0);
        threads[0] = new Thread(monthlyAnalysis0);

        monthlyAnalysis1 = new MonthlyAnalysis(transactions, 1);
        threads[1] = new Thread(monthlyAnalysis1);

        monthlyAnalysis2 = new MonthlyAnalysis(transactions, 2);
        threads[2] = new Thread(monthlyAnalysis2);

        monthlyAnalysis3 = new MonthlyAnalysis(transactions, 3);
        threads[3] = new Thread(monthlyAnalysis3);

        weeklyAnalysis0 = new WeeklyAnalysis(transactions, 0);
        threads[4] = new Thread(weeklyAnalysis0);

        weeklyAnalysis1 = new WeeklyAnalysis(transactions, 1);
        threads[5] = new Thread(weeklyAnalysis1);

        dailyAnalysis1 = new DailyAnalysis(transactions, 1);
        threads[6] = new Thread(dailyAnalysis1);

        movie = new LastSpentAnalysis(transactions, Constants.MCODE.MOVIE);
        threads[7] = new Thread(movie);

        nail = new LastSpentAnalysis(transactions, Constants.MCODE.NAIL);
        threads[8] = new Thread(nail);

        hair = new LastSpentAnalysis(transactions, Constants.MCODE.HAIR);
        threads[9] = new Thread(hair);

        hospital = new LastSpentAnalysis(transactions,
                Constants.MCODE.HOSPITAL,
                Constants.MCODE.MID_PHARMACY,
                Constants.MCODE.MID_DENTIST,
                Constants.MCODE.MID_CLINIC);

        threads[10] = new Thread(hospital);

        for(Thread thread : threads) {
            thread.start();
            thread.join();
        }

        setDefault();

        setYesterday();
        setWeekly();

        setMonth0();
        setMonth1();
        setMonth2();
        setMonth3();

        setThreeMonth();

        setLastSpent();

        setTranIds();
    }

    private void setDefault() {
        values.put(today, new Result(Calendar.getInstance().get(Calendar.DATE), FIRSTDOT));
        values.put(user_sex, new Result("0"));
        values.put(day_of_week, new Result(Calendar.getInstance().get(Calendar.DAY_OF_WEEK), FIRSTDOT));
    }

    private void setYesterday() {

        values.put(yesterday_sum, new Result(getAggregate(dailyAnalysis1.yesterday, "", SUM), LV0));
        values.put(yesterday_alcohol_sum, new Result(getAggregate(dailyAnalysis1.alcohol, "", SUM), LV0));
        if(dailyAnalysis1.maxTransaction != null) {
            values.put(yesterday_max_keyword, new Result(dailyAnalysis1.maxTransaction.getTransaction().getKeyword()));
            values.put(yesterday_max_sum, new Result(dailyAnalysis1.maxTransaction.getTransaction().getSpentMoney(), NORMAL));
            values.put(yesterday_max_spent_money, values.get(yesterday_max_sum));
        }
    }

    private void setWeekly() {
        values.put(week_0_sum, new Result(getAggregate(weeklyAnalysis0.weekly, "", SUM), LV0));
        values.put(week_1_sum, new Result(getAggregate(weeklyAnalysis1.weekly, "", SUM), LV0));

        double sum = getAggregate(weeklyAnalysis1.weekly, "", SUM);
        double amount = getFuncAmount(three_month_week_avg);
        double percent = getPercentValue(sum, amount);
        values.put(week_1_percent, new Result(percent, PERCENT));
    }

    private void setMonth0() {
        if(monthlyAnalysis0 == null) return;

        values.put(month_0, new Result(monthlyAnalysis0.monthStr));
        AggregationValue month = monthlyAnalysis0.month.get("");
        if(month != null) {
            double monthSum = month.getSum();
            values.put(month_0_sum, new Result(month.getSum(), LV0));
            values.put(month_0_cnt, new Result(month.getCnt(), FIRSTDOT));
            values.put(month_0_avg, new Result(month.getAvg(), LV0));

            values.put(month_0_sum_credit, new Result(getAggregate(monthlyAnalysis0.cardType, "1", SUM), LV0));
            values.put(month_0_sum_check, new Result(getAggregate(monthlyAnalysis0.cardType, "0", SUM), LV0));
            values.put(month_0_sum_cash, new Result(getAggregate(monthlyAnalysis0.cardType, "3", SUM), LV0));

            double percent = getPercentValue(month.getSum(), monthlyAnalysis1.samePeriodSum);
            values.put(month_0_same_period_percent, new Result(percent, PERCENT));

            if(percent > 0) {
                values.put(month_0_same_period_more_or_less_str, new Result("많이"));
                values.put(same_period_image, new Result("lv0_monthly_up"));
            } else {
                values.put(month_0_same_period_more_or_less_str, new Result("적게"));
                values.put(same_period_image, new Result("lv0_monthly_down"));
            }

            values.put(month_0_mid_coffee_sum, new Result(getAggregate(monthlyAnalysis0.mcode, Constants.MCODE.COFFEE + "", SUM), LV0));
            values.put(month_0_mid_coffee_cnt, new Result(getAggregate(monthlyAnalysis0.mcode, Constants.MCODE.COFFEE + "", CNT), CNT_UNIT));
            setMaxDate();

            setCAC(monthSum);

            setCoffeeMaxDate();
        }

        values.put(past_day, new Result(Calendar.getInstance().get(Calendar.DATE), FIRSTDOT));

    }

    private void setMaxDate() {
        values.put(max_date, new Result(monthlyAnalysis0.maxDate));
        values.put(max_date_sum, new Result(monthlyAnalysis0.maxSum, LV0));
        values.put(max_date_keyword, new Result(monthlyAnalysis0.maxKeyword));
    }

    private void setCoffeeMaxDate() {
        values.put(max_coffee_date, new Result(monthlyAnalysis0.maxCoffeeDate));
    }

    /**
     * 먹고 마시는데 22만원 썼습니다.
     * 이번 달 지출의 20%를 차지하며\n지난달 같은 일자 대비 2% 증가했습니다\n\n항목별로는 식사 22%,\n 카페/간식 23%,\n 술/유흥 20% 입니다.
     */
    private void setCAC(double monthSum) {

        String cacSumByCategory = monthlyAnalysis0.getCACStr(monthSum);

        // 외식, 카페/간식, 술/유흥 순서 픽스
        double cacSum = monthlyAnalysis0.getCACSum();

        double lastCACSum = monthlyAnalysis1.getCACSum();

        int percentBySum = monthSum == 0 ? 0 : (int) ((cacSum) * 100 / monthSum);

        int samePeriodPercent = lastCACSum == 0 ? 0 : (int) ((cacSum - lastCACSum) * 100 / lastCACSum);

        String samePeriodStr = samePeriodPercent > 0 ? Math.abs(samePeriodPercent) + "% 증가" : Math.abs(samePeriodPercent) + "% 감소";

        values.put(cac_sum, new Result(cacSum, LV0));
        values.put(cac_percent, new Result(percentBySum, PERCENT));
        values.put(cac_same_period, new Result(samePeriodStr));
        values.put(cac_percent_by_category, new Result(cacSumByCategory));
        values.put(last_cac_sum, new Result(lastCACSum, LV0));

    }

    private void setMonth1() {
        values.put(month_1, new Result(monthlyAnalysis1.monthStr));
        AggregationValue month = monthlyAnalysis1.month.get("");

        if(month != null) {

            values.put(month_1_sum, new Result(month.getSum(), LV0));
            values.put(month_1_cnt, new Result(month.getCnt(), FIRSTDOT));
            values.put(month_1_avg, new Result(month.getAvg(), LV0));

            values.put(month_1_sum_same_period, new Result(monthlyAnalysis1.samePeriodSum, LV0));
            values.put(month_1_sum_credit, new Result(getAggregate(monthlyAnalysis1.cardType, "1", SUM), LV0));
            values.put(month_1_sum_check, new Result(getAggregate(monthlyAnalysis1.cardType, "0", SUM), LV0));
            values.put(month_1_sum_cash, new Result(getAggregate(monthlyAnalysis1.cardType, "3", SUM), LV0));

            //술
            AggregationValue alcohol = monthlyAnalysis1.mcode.get(ALCOHOL + "");
            if(alcohol != null) {
                values.put(month_1_mid_alcohol_sum, new Result(alcohol.getSum(), LV0));
                values.put(month_1_mid_alcohol_cnt, new Result(alcohol.getCnt(), FIRSTDOT));

                String[] alcohols = AnalysisHelper.getAlcoholType(alcohol.getCnt());
                values.put(month_1_alcohol_type, new Result(alcohols[ALCOHOL_TYPE]));
                values.put(month_1_alcohol_type_image_name, new Result(alcohols[ALCOHOL_TYPE_IMAGE]));
            }


            values.put(month_1_mid_coffee_sum, new Result(getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.COFFEE + "", SUM), LV0));
            values.put(month_1_mid_mart_sum, new Result(getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.MART + "", SUM), LV0));
            values.put(month_1_mid_convenience_sum, new Result(getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.CONVENIENCE + "", SUM), LV0));
            values.put(month_1_mid_taxi_sum, new Result(getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.TAXI + "", SUM), LV0));

            values.put(month_1_same_period_end_day, new Result(Calendar.getInstance().get(Calendar.DATE), FIRSTDOT));

            setLargeCategoryTop3(month.getSum());

            setLastMaxDate();

        }

    }

    private void setLastMaxDate() {
        values.put(last_max_date, new Result(monthlyAnalysis1.maxDate));
        values.put(last_max_date_sum, new Result(monthlyAnalysis1.maxSum, LV0));
        values.put(last_max_date_keyword, new Result(monthlyAnalysis1.maxKeyword));
    }

    private void setLargeCategoryTop3(double monthSum) {
        // 카테고리 공통
        ArrayList<AggregationValue> larges = new ArrayList<>(monthlyAnalysis1.lcode.values());
        desc(larges);// 금액 역순 정렬
        ArrayList<String> topN = new ArrayList<>();
        int i = 1;

        for(AggregationValue large : larges) {
            if(i == 4) break;

            double percentValue = large.getSum() * 100 / monthSum;
            Result percent = new Result(percentValue, PERCENT);
            topN.add(new TopN(large.getTitle(), "", percent.getDisplayValue()).getLargeValue(i));
            i++;
        }

        if(topN.size() > 1)
            values.put(large_top_n, new Result(TextUtils.join(",\\n", topN)));

    }

    private void setMonth2() {
        values.put(month_2, new Result(monthlyAnalysis2.monthStr));
        AggregationValue month = monthlyAnalysis2.month.get("");

        if(month != null) {

            values.put(month_2_sum, new Result(month.getSum(), LV0));
            values.put(month_2_cnt, new Result(month.getCnt(), FIRSTDOT));
            values.put(month_2_avg, new Result(month.getAvg(), LV0));

            values.put(month_2_mid_alcohol_sum, new Result(getAggregate(monthlyAnalysis2.mcode, ALCOHOL + "", SUM), LV0));
            values.put(month_2_mid_coffee_sum, new Result(getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.COFFEE + "", SUM), LV0));
            values.put(month_2_mid_mart_sum, new Result(getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.MART + "", SUM), LV0));
            values.put(month_2_mid_convenience_sum, new Result(getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.CONVENIENCE + "", SUM), LV0));
            values.put(month_2_mid_taxi_sum, new Result(getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.TAXI + "", SUM), LV0));
        }
    }

    private void setMonth3() {

        values.put(month_3, new Result(monthlyAnalysis3.monthStr));
        AggregationValue month = monthlyAnalysis3.month.get("");

        if(month != null) {

            values.put(month_3_sum, new Result(month.getSum(), LV0));
            values.put(month_3_cnt, new Result(month.getCnt(), FIRSTDOT));
            values.put(month_3_avg, new Result(month.getAvg(), LV0));

            values.put(month_3_mid_alcohol_sum, new Result(getAggregate(monthlyAnalysis3.mcode, ALCOHOL + "", SUM), LV0));
            values.put(month_3_mid_coffee_sum, new Result(getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.COFFEE + "", SUM), LV0));

            values.put(month_3_mid_mart_sum, new Result(getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.MART + "", SUM), LV0));
            values.put(month_3_mid_convenience_sum, new Result(getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.CONVENIENCE + "", SUM), LV0));
            values.put(month_3_mid_taxi_sum, new Result(getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.TAXI + "", SUM), LV0));
        }
    }

    private void setThreeMonth() {

        int threeMonthTotalDay = getThreeMonthTotalDay();// 3 개월 전체 일수

        // 3개월 전체 합 건 평균, 주간평균
        setThreeMonthAggregation(threeMonthTotalDay);

        // 지난3개월 커피 국가
        setThreeMonthCoffeeCountry(threeMonthTotalDay);

        // book
        setThreeMonthBookSum();

        // fastfood
        setThreeMonthFastFood();

        // hair
        setThreeMonthHair(threeMonthTotalDay);

        // nail
        setThreeMonthNail();

        // mart
        setThreeMonthMart();

        // convenience
        setThreeMonthConvenience();

        // movie
        setThreeMonthMovie();

        // taxi
        setThreeMonthTaxi();

        // alcohol
        setThreeMonthAlcohol();

        // credit
        setThreeMonthCredit();

        // category
        setThreeMonthCategory();

    }

    private int getThreeMonthTotalDay() {
        Calendar before = Calendar.getInstance();
        before.set(Calendar.DATE, 1);
        before.add(Calendar.MONTH, -4);

        Calendar after = Calendar.getInstance();
        after.set(Calendar.DATE, 1);
        after.add(Calendar.MONTH, -1);

        return getDiffDay(before, after);
    }

    private void setThreeMonthAggregation(int totalDay) {

        double m1 = getAggregate(monthlyAnalysis1.month, "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.month, "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.month, "", SUM);

        double threeMonthSum = m1 + m2 + m3;
        divider = getDivider(m1, m2, m3);


        double threeMonthAvg = threeMonthSum / divider;
        double threeMonthDayAvg = totalDay == 0 ? 0 : threeMonthSum / totalDay;
        double threeMonthWeekAvg = threeMonthDayAvg * 7;

        values.put(three_month_sum, new Result(threeMonthSum, LV0));
        values.put(three_month_week_avg, new Result(threeMonthWeekAvg, LV0));
        values.put(three_month_day_avg, new Result(threeMonthWeekAvg, LV0));
        values.put(three_month_avg, new Result(threeMonthAvg, LV0));

    }

    private void setThreeMonthCoffeeCountry(int totalDay) {

        double s1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.COFFEE + "", SUM);
        double s2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.COFFEE + "", SUM);
        double s3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.COFFEE + "", SUM);
        values.put(three_month_mid_coffee_sum, new Result(s1 + s2 + s3, LV0));

        double morning = monthlyAnalysis1.morningCoffeeSum.getSum() + monthlyAnalysis2.morningCoffeeSum.getSum() + monthlyAnalysis3.morningCoffeeSum.getSum();
        values.put(three_month_mid_coffee_am_sum, new Result(morning, LV0));

        double c1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.COFFEE + "", CNT);
        double c2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.COFFEE + "", CNT);
        double c3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.COFFEE + "", CNT);

        double threeMonthCoffeeCnt = (c1 + c2 + c3);

        double threeMonthCoffeeWeekAvg = totalDay == 0 ? 0 : threeMonthCoffeeCnt * 7 / totalDay;
        String[] coffeeType = getCoffeeCountry(threeMonthCoffeeWeekAvg);

        values.put(three_month_mid_coffee_cnt, new Result(threeMonthCoffeeCnt, FIRSTDOT));
        values.put(three_month_mid_coffee_country, new Result(coffeeType[COFFEE_TYPE_COUNTRY]));
        values.put(three_month_mid_coffee_country_value, new Result(coffeeType[COFFEE_TYPE_COUNTRY_AMOUNT]));

        values.put(three_month_mid_coffee_week_avg, new Result(threeMonthCoffeeWeekAvg, FIRSTDOT));

    }

    private void setThreeMonthBookSum() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.BOOK + "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.BOOK + "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.BOOK + "", SUM);

        double threeMonthSum = m1 + m2 + m3;

        double diff = threeMonthSum - 54300;

        values.put(three_month_book_sum, new Result(threeMonthSum, LV0));
        values.put(three_month_book_diff_sum, new Result(diff, LV0));
    }

    private void setThreeMonthFastFood() {

        double l1 = getAggregate(monthlyAnalysis1.lcode, Constants.LCODE.FOOD + "", CNT);
        double l2 = getAggregate(monthlyAnalysis2.lcode, Constants.LCODE.FOOD + "", CNT);
        double l3 = getAggregate(monthlyAnalysis3.lcode, Constants.LCODE.FOOD + "", CNT);

        double lcnt = l1 + l2 + l3;
        if(lcnt == 0) return;

        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.FASTFOOD + "", CNT);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.FASTFOOD + "", CNT);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.FASTFOOD + "", CNT);

        double mcnt = m1 + m2 + m3;

        double percent = mcnt * 100 / lcnt;

        values.put(three_month_large_food_cnt, new Result(lcnt, FIRSTDOT));
        values.put(three_month_mid_fastfood_cnt, new Result(mcnt, FIRSTDOT));
        values.put(three_month_mid_fastfood_percent, new Result(percent, PERCENT));

        HashMap<String, AggregationValue> totalFastFoods = new HashMap<>();
        ArrayList<AggregationValue> fastfoods = new ArrayList<>(monthlyAnalysis1.fastfood.values());
        fastfoods.addAll(monthlyAnalysis2.fastfood.values());
        fastfoods.addAll(monthlyAnalysis3.fastfood.values());

        for(AggregationValue keyword : fastfoods) {

            AggregationValue value = totalFastFoods.get(keyword.getKey());
            if(value == null) {
               value = keyword;
            } else {
                //기존 횟수추가
                value.setCnt(value.getCnt() + keyword.getCnt());
            }
            totalFastFoods.put(keyword.getKey(), value);
        }


        ArrayList<AggregationValue> keywords = new ArrayList<>(totalFastFoods.values());
        desc(keywords);

        int i = 0;

        ArrayList<String> topN = new ArrayList<>();
        for(AggregationValue keyword : keywords) {
            if(i == 3) break;
            Result cnt = new Result(keyword.getCnt(), CNT_UNIT);
            topN.add(new TopN(keyword.getTitle(), cnt.getDisplayValue()).getCntValue());
            i++;
        }

        if(topN.size() > 1)
            values.put(fastfood_top_n, new Result(TextUtils.join(", ", topN)));

    }

    private void setThreeMonthHair(int totalDay) {

        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.HAIR + "", CNT);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.HAIR + "", CNT);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.HAIR + "", CNT);

        double hairCnt = m1 + m2 + m3;
        double avg = hairCnt == 0 ? 0 : totalDay / hairCnt;

        values.put(three_month_hair_avg_cnt, new Result(avg, FIRSTDOT));

    }

    private void setThreeMonthMovie() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.MOVIE + "", CNT);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.MOVIE + "", CNT);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.MOVIE + "", CNT);

        double movieCnt = m1 + m2 + m3;

        values.put(three_month_movie_cnt, new Result(movieCnt, FIRSTDOT));

    }

    private void setThreeMonthNail() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.NAIL + "", CNT);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.NAIL + "", CNT);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.NAIL + "", CNT);

        double nailCnt = m1 + m2 + m3;
        values.put(three_month_nail_cnt, new Result(nailCnt, FIRSTDOT));

    }

    private void setThreeMonthTaxi() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.TAXI + "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.TAXI + "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.TAXI + "", SUM);

        double taxiSum = m1 + m2 + m3;
        double taxiAmSum = monthlyAnalysis1.morningTaxiSum.getSum() + monthlyAnalysis2.morningTaxiSum.getSum() + monthlyAnalysis3.morningTaxiSum.getSum();

        values.put(three_month_mid_taxi_sum, new Result(taxiSum, LV0));
        values.put(three_month_mid_taxi_am_sum, new Result(taxiAmSum, LV0));
    }

    private void setThreeMonthConvenience() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.CONVENIENCE + "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.CONVENIENCE + "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.CONVENIENCE + "", SUM);

        double conSum = m1 + m2 + m3;
        values.put(three_month_mid_convenience_sum, new Result(conSum, LV0));
    }

    private void setThreeMonthMart() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, Constants.MCODE.MART + "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.mcode, Constants.MCODE.MART + "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.mcode, Constants.MCODE.MART + "", SUM);

        double martSum = m1 + m2 + m3;
        values.put(three_month_mid_mart_sum, new Result(martSum, LV0));
    }

    private void setThreeMonthAlcohol() {
        double m1 = getAggregate(monthlyAnalysis1.mcode, ALCOHOL + "", SUM);
        double m2 = getAggregate(monthlyAnalysis2.mcode, ALCOHOL + "", SUM);
        double m3 = getAggregate(monthlyAnalysis3.mcode, ALCOHOL + "", SUM);

        double alcoholSum = m1 + m2 + m3;
        values.put(three_month_mid_alcohol_sum, new Result(alcoholSum, LV0));
    }

    private void setThreeMonthCredit() {

        double m1 = getAggregate(monthlyAnalysis1.cardType, String.valueOf(CARD.ordinal()), SUM);
        double m2 = getAggregate(monthlyAnalysis2.cardType, String.valueOf(CARD.ordinal()), SUM);
        double m3 = getAggregate(monthlyAnalysis3.cardType, String.valueOf(CARD.ordinal()), SUM);

        double creditSum = m1 + m2 + m3;

        double checkSum = getAggregate(monthlyAnalysis1.cardType, String.valueOf(CHECK.ordinal()), SUM) +
                getAggregate(monthlyAnalysis2.cardType, String.valueOf(CHECK.ordinal()), SUM) +
                getAggregate(monthlyAnalysis3.cardType, String.valueOf(CHECK.ordinal()), SUM);

        double cashSum = getAggregate(monthlyAnalysis1.cardType, String.valueOf(CASH.ordinal()), SUM) +
                getAggregate(monthlyAnalysis2.cardType, String.valueOf(CASH.ordinal()), SUM) +
                getAggregate(monthlyAnalysis3.cardType, String.valueOf(CASH.ordinal()), SUM);

        values.put(threemonth_credit_sum, new Result(creditSum, LV0));

        values.put(threemonth_str, new Result(makeThreeMonthStr()));

        String monthStr = checkSum > cashSum ?  "체크 " + getLv0Currency(checkSum) +", 현금 " + getLv0Currency(cashSum)
                :
                "현금 " + getLv0Currency(cashSum) +", 체크 " + getLv0Currency(checkSum);

        values.put(threemonth_sum_by_card_type, new Result(monthStr));
    }

    private String makeThreeMonthStr() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(Calendar.MONTH);

        ArrayList<String> months = new ArrayList<>();
        for(int i = 0 ; i < 3 ; i ++) {
            int result = (12 + (month - (3 - i))) % 12 + 1;
            months.add(result + "월");
        }

        return "(" + TextUtils.join(", ", months) +")";
    }

    /**
     *  1. 전체 한달 평균 지난 3개월 카테고리 한달 평균
     *  2. 카테고리별 한달 평균 금액
     *  3. desc 평균 정렬
     *  4. 탑 3위 내역 뽑기
     */
    private void setThreeMonthCategory() {
        if(divider == 0) return;

        // 1. 전체 한달 평균 지난 3개월 카테고리 한달 평균
        double threeMonthAvg = values.get(three_month_avg).getAmount(); // 3개월 평균

        // 2. 카테고리별 한달 평균 금액
        HashMap<String, CategoryAvg> map = new HashMap<>();

        calculateThreeMonth(new ArrayList<>(monthlyAnalysis1.lcode.values()), map);
        calculateThreeMonth(new ArrayList<>(monthlyAnalysis2.lcode.values()), map);
        calculateThreeMonth(new ArrayList<>(monthlyAnalysis3.lcode.values()), map);

        ArrayList<CategoryAvg> categoryAvgs = new ArrayList<>(map.values());
        descCate(categoryAvgs);


        ArrayList<String> strValues = new ArrayList<>();
        for (int i = 0; i < categoryAvgs.size(); i++) {
            if(i == 3) break;
            strValues.add((i + 1) + "위" + " " +
                    categoryAvgs.get(i).getName() + " (" + getPercent(categoryAvgs.get(i).getSum() * 100 / threeMonthAvg / divider) + ")");
        }

        values.put(threemonth_avg_by_category, new Result(TextUtils.join(",\n", strValues)));
    }

    private int getDivider(double m1, double m2, double m3) {
        if(m3 != 0)
            return 3;
        else if(m2 != 0)
            return  2;
        else if(m1 != 0)
            return  1;

        return 3;
    }

    private void calculateThreeMonth(ArrayList<AggregationValue> categories, HashMap<String, CategoryAvg> map) {

        if(isEmpty(categories)) return;

        CategoryAvg categoryAvg;

        for(AggregationValue category : categories) {

            categoryAvg = map.get(category.getTitle());
            if(categoryAvg == null) {
                categoryAvg = new CategoryAvg(category.getTitle());
            }

            categoryAvg.addSum(category.getSum());

            map.put(category.getTitle(), categoryAvg);
        }
    }

    private void setLastSpent() {
        if(hospital.lastTransaction != null) {
            values.put(last_hospital_date, new Result(hospital.lastTransaction.getTransaction().getSpentDate()));
            values.put(last_hospital_diff_day, new Result(hospital.difDay, FIRSTDOT));
        }

        if(movie.lastTransaction != null) {
            values.put(last_movie_date, new Result(movie.lastTransaction.getTransaction().getSpentDate()));
            values.put(last_movie_diff_day, new Result(movie.difDay, FIRSTDOT));
            values.put(last_movie_keyword, new Result(movie.lastTransaction.getTransaction().getKeyword()));
        }

        if(nail.lastTransaction != null) {
            values.put(last_nail_date, new Result(nail.lastTransaction.getTransaction().getSpentDate()));
            values.put(last_nail_diff_day, new Result(nail.difDay, FIRSTDOT));
            values.put(last_nail_keyword, new Result(nail.lastTransaction.getTransaction().getKeyword()));
        }

        if(hair.lastTransaction != null) {
            values.put(last_hair_date, new Result(hair.lastTransaction.getTransaction().getSpentDate()));
            values.put(last_hair_diff_day, new Result(hair.difDay, FIRSTDOT));
            values.put(last_hair_keyword, new Result(hair.lastTransaction.getTransaction().getKeyword()));
        }
    }

    private void setTranIds() {
        ArrayList<Integer> ids;

        //180
        tranIds.put(last_nail_diff_day, getTranIds(nail.filteredTransactions));

        //182
        tranIds.put(last_movie_diff_day, getTranIds(movie.filteredTransactions));

        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.FASTFOOD));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis2.mcode, "" + Constants.MCODE.FASTFOOD));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis3.mcode, "" + Constants.MCODE.FASTFOOD));

        //186
        tranIds.put(three_month_large_food_cnt, ids);

        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.COFFEE));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis2.mcode, "" + Constants.MCODE.COFFEE));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis3.mcode, "" + Constants.MCODE.COFFEE));

        // 133
        tranIds.put(three_month_mid_coffee_cnt, ids);

        ids = new ArrayList<>();
        ids.addAll(monthlyAnalysis1.morningCoffeeSum.getIds());
        ids.addAll(monthlyAnalysis2.morningCoffeeSum.getIds());
        ids.addAll(monthlyAnalysis3.morningCoffeeSum.getIds());

        // 177
        tranIds.put(three_month_mid_coffee_am_sum, ids);

        ids = new ArrayList<>();
        ids.addAll(monthlyAnalysis1.morningTaxiSum.getIds());
        ids.addAll(monthlyAnalysis2.morningTaxiSum.getIds());
        ids.addAll(monthlyAnalysis3.morningTaxiSum.getIds());

        // 136
        tranIds.put(three_month_mid_taxi_am_sum, ids);

        // 179
        tranIds.put(last_hair_diff_day, getTranIds(hair.filteredTransactions));

        // 55
        tranIds.put(month_1_mid_coffee_sum, getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.COFFEE));

        // 54
        tranIds.put(month_1_mid_alcohol_sum, getAggregatedTranIds(monthlyAnalysis1.mcode, "" + ALCOHOL));
        // 56
        tranIds.put(month_1_mid_mart_sum, getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.MART));
        // 57
        tranIds.put(month_1_mid_convenience_sum, getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.CONVENIENCE));

        // 201
        tranIds.put(month_1_mid_taxi_sum, getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.TAXI));

        //247
        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.cardType, "1"));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis2.cardType, "1" ));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis3.cardType, "1"));
        tranIds.put(threemonth_credit_sum, ids);

        // 5
        tranIds.put(month_0_sum_credit, getAggregatedTranIds(monthlyAnalysis0.cardType, "1"));

        // 33
        tranIds.put(month_1_sum_credit, getAggregatedTranIds(monthlyAnalysis1.cardType, "1"));

        // 243
        if(monthlyAnalysis0.maxDateValue != null)
            tranIds.put(max_date, monthlyAnalysis0.maxDateValue.getTranIds());

        // 245
        if(monthlyAnalysis1.maxDateValue != null)
            tranIds.put(last_max_date, monthlyAnalysis1.maxDateValue.getTranIds());

        // 232
        tranIds.put(week_0_sum, getAggregatedTranIds(weeklyAnalysis0.weekly, ""));

        // 233
        tranIds.put(week_1_sum, getAggregatedTranIds(weeklyAnalysis1.weekly, ""));

        // 224
        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.month, ""));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis2.month, "" ));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis3.month, ""));
        tranIds.put(three_month_sum, ids);

        // 2
        tranIds.put(month_0_sum, getAggregatedTranIds(monthlyAnalysis0.month, ""));

        // 164
        tranIds.put(last_hospital_date, getTranIds(hospital.filteredTransactions));

        // 29
        tranIds.put(month_1_sum, getAggregatedTranIds(monthlyAnalysis1.month, "" ));

        // 174
        tranIds.put(yesterday_sum, getAggregatedTranIds(dailyAnalysis1.yesterday, ""));

        // 208
        tranIds.put(yesterday_alcohol_sum, getAggregatedTranIds(dailyAnalysis1.alcohol, ""));

        // 253
        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis0.lcode, "" + Constants.LCODE.FOOD));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis0.lcode, "" + Constants.LCODE.CAFE));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis0.lcode, "" + Constants.LCODE.ALCOHOL));
        tranIds.put(cac_sum, ids);

        // 137
        ids = new ArrayList<>();
        ids.addAll(getAggregatedTranIds(monthlyAnalysis1.mcode, "" + Constants.MCODE.BOOK));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis2.mcode, "" + Constants.MCODE.BOOK));
        ids.addAll(getAggregatedTranIds(monthlyAnalysis3.mcode, "" + Constants.MCODE.BOOK));
        tranIds.put(three_month_book_sum, ids);

        // 207
        tranIds.put(month_0_mid_coffee_sum, getAggregatedTranIds(monthlyAnalysis0.mcode, Constants.MCODE.COFFEE + ""));

    }

    /**
     *
     * @param map 분석된 데이터 담을 맵 정보 lcode, 분석 내용 목록 추가
     * @param categoryContents 카테고리 공통 목록
     * @return 공통 카테고리 분석 데이터
     */
    SparseArray<ArrayList<Analysis>> loadCommonCategory(SparseArray<ArrayList<Analysis>> map, ArrayList<JoinedContent> categoryContents) {

        for(JoinedContent content : categoryContents) {

            switch (content.getContent().getId()) {
                case 23: // 지난달
                    setCommonCategoryKeyword(monthlyAnalysis1, map, content);
                    break;
                case 24: // 지난달
                    setCommonCategoryMid(monthlyAnalysis1, map, content, true);
                    break;
                case 137:// 이번달
                    setCommonCategoryKeyword(monthlyAnalysis0, map, content);
                    break;
                case 138:// 이번달
                    setCommonCategoryMid(monthlyAnalysis0, map, content, false);
                    break;
            }
        }
        return map;
    }

    /**
     * 23	2	1	0	0		0	지난달	지난달 %1$s 지출은\n%2$s 입니다.		주요 지출처는\n%1$s 입니다.		0	카테고리	지난달 요약	지난달	지난달 건수 > 1, 합 > 100000	지난달 %1$s 지출은\n22만원입니다.	주요 지출처는\n%(스타벅스 22만원)입니다.	1	3	2018-09-11 05:42:04
     * 137	2	1	0	0		0	이번달	이번 달 %1$s 지출은\n%2$s 입니다.		주요 지출처는\n%1$s 입니다.		0	카테고리	카테고리 주요	이번달	이번달 건수 > 1, 합 > 100000	이번 달 %1$s 지출은\n22만원입니다.	주요 지출처는\n%(스타벅스 22만원)입니다.	1	3	2018-09-11 06:48:51
     */
    private void setCommonCategoryKeyword(MonthlyAnalysis monthlyAnalysis, SparseArray<ArrayList<Analysis>> map, JoinedContent content) {

        ArrayList<AggregationValue> categories = new ArrayList<>(monthlyAnalysis.lcode.values());
        desc(categories);

        String categoryName;
        String categorySum;
        String maxKeywordStr;
        String image;

        ArrayList<Analysis> analyses;
        int index = 0;
        for(AggregationValue value : categories) {
            if (index == 3) break;
            try {
                if(value.getCnt() > 1) {

                    int lcode = Integer.parseInt(value.getKey());
                    CategoryMax categoryMax = monthlyAnalysis.maxKeywordsByCategory.get(value.getTitle());
                    if(categoryMax != null) {
                        categoryName = value.getTitle();
                        categorySum = getLv0Currency(value.getSum());
                        maxKeywordStr = categoryMax.getKeyword() + " (" + getLv0Currency(categoryMax.getSum()) + ")";
                        image = AnalysisHelper.getLargeImages(lcode + "", true);

                        String lContent = String.format(content.getContent().getlContent(), categoryName, categorySum);
                        String mContent = String.format(content.getContent().getmContent(), maxKeywordStr);

                        Analysis analysis = new Analysis(
                                content.getContent().getId(),
                                image,
                                categoryName,
                                lContent,
                                mContent,
                                value.getTranIds(),
                                content.getContent().getCategoryPriority()
                        );

                        analyses = map.get(lcode);
                        if(analyses == null) {
                            analyses = new ArrayList<>();
                        }
                        analyses.add(analysis);

                        map.put(lcode, analyses);
                    }
                }

            } catch (Exception e) {

            }

            index++;
        }
    }

    private void setCommonCategoryMid(MonthlyAnalysis monthlyAnalysis, SparseArray<ArrayList<Analysis>> map, JoinedContent content, boolean isLast) {
//        24	2	0	0	0		0	지난달	%1$s월 %2$s 지출은 ↵%3$s입니다.		%1$s 지출의 주요 항목은↵%2$s  입니다.		0	카테고리	지난달 요약	1) 지난 달,↵2) 중분류	1) 대카테고리 사용금액>5만원,↵2) mid카테 2개 이상↵3) 날짜 : 20일 이전	10월 백화점/패션 지출은 ↵2,512.1만원입니다.↵↵(*저거 10월 = 지난 달 임)	백화점/패션 지출의 주요 항목은↵1위 아울렛 (31.2만원, 32%)↵2위 의류 (32.1만원, 32%) 입니다.	1	3	2018-09-11 06:52:04
//        138	2	1	0	0		0	이번달	이번 달 %1$s 지출은\n%2$s 입니다.		지출의 주요 항목은\n%1$s입니다.		0	카테고리	카테고리 주요	이번달	중분류 갯수 > 1	이번 달 카페/간식 지출은\n22만원입니다.	지출의 주요 항목은\n1위 커피 (22만원),\n2위 아이스크림(21만원)입니다.	1	3	2018-09-11 06:52:07

        // 1. 월, 카테고리명, 금액,  내용(1위 아울렛 (31.2만원, 32%)↵2위 의류 (32.1만원, 32%))
        ArrayList<AggregationValue> categories = new ArrayList<>(monthlyAnalysis.lcode.values());
        desc(categories);

        ArrayList<AggregationValue> mediums = new ArrayList<>(monthlyAnalysis.mcode.values());
        desc(mediums);

        String monthStr = monthlyAnalysis.monthStr + "월";
        String categoryName;
        String categorySum;
        String mContents;
        String image = "";

        ArrayList<Analysis> analyses;

        int index = 0;
        for(AggregationValue value : categories) {
            if (index == 3) break;
            try {
                if(value.getCnt() > 1) { //condition
                    int lcode = Integer.parseInt(value.getKey());
                    categoryName = value.getTitle();
                    categorySum = getLv0Currency(value.getSum());

                    int i = 1;
                    ArrayList<String> contentValues = new ArrayList<>();
                    for(AggregationValue medium : mediums) {

                        if(value.getKey().equals(medium.getKey().substring(0,2))) {
                            if(i == 4) break;

                            if(i == 1) image = AnalysisHelper.getMidImg(medium.getKey());

                            double percentValue = medium.getSum() * 100 / value.getSum();
                            contentValues.add(i + "위 " +  medium.getTitle() + "(" + getLv0Currency(medium.getSum()) + ", " + getPercent(percentValue) + ")");
                            i++;
                        }

                    }// end medium

                    if(contentValues.size() < 2) continue;

                    mContents = TextUtils.join(",\\n", contentValues);
                    String lContent;
//            이번 달 %1$s 지출은\n%2$s 입니다.
                    if(isLast) {
                        lContent = String.format(content.getContent().getlContent(), monthStr, categoryName, categorySum);
                    } else {
                        lContent = String.format(content.getContent().getlContent(), categoryName, categorySum);

                    }
                    String mContent = String.format(content.getContent().getmContent(), mContents);

                    Analysis analysis = new Analysis(
                            content.getContent().getId(),
                            image,
                            categoryName,
                            lContent,
                            mContent,
                            value.getTranIds(),
                            content.getContent().getCategoryPriority()
                    );

                    analyses = map.get(lcode);
                    if(analyses == null) {
                        analyses = new ArrayList<>();
                    }
                    analyses.add(analysis);

                    map.put(lcode, analyses);
                }
            } catch (Exception e) {

            }

            index++;

        }

    }

}
