package com.tenqube.visual_third.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import com.tenqube.visual_third.manager.VisualAlarmManager;


public class AlarmReceiver extends BroadcastReceiver {

    protected static final String TAG = AlarmReceiver.class.getSimpleName();

    @Override
    public void onReceive(final Context context, Intent intent) {

        Log.i(TAG, "AlarmReceiver" + intent.getAction());
        if (Intent.ACTION_BOOT_COMPLETED.equals(intent.getAction()) ||
                Intent.ACTION_LOCKED_BOOT_COMPLETED.equals(intent.getAction())) {
            VisualAlarmManager.getInstance(context).setAlarms();
        }
    }

}
