package com.tenqube.visual_third;

import android.Manifest;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.Switch;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.receiver.AlarmReceiver;
import com.tenqube.visual_third.provider.VisualContract;
import com.tenqube.visual_third.ui.OnResultListener;

import static com.tenqube.visual_third.Constants.ACTION_TRAN_POPUP;


public class MainActivity extends AppCompatActivity {

    private VisualService visualService;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        try {
            // visual service 생성
            visualService = new VisualServiceImpl(this, "", Constants.DEV);
            visualService.setDebugMode(true); // 개발자 모드 설정 (로그 확인이 가능합니다.)

            // 알림 상태바에 나타느는 notification small icon 값 설정
            visualService.settingNotification(R.drawable.ic_deposit_loan); // 상단 노티 아이콘 설정

            // 팝업 설정
            Switch popup = (Switch) findViewById(R.id.popup);
            popup.setChecked(visualService.isActiveTranPopup());
            popup.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    visualService.setTranPopup(isChecked);
                }
            });

            // daily 알림 설정
            Switch daily = (Switch) findViewById(R.id.daily);
            daily.setChecked(visualService.isActiveDailyNoti());
            daily.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    visualService.setDailyNoti(isChecked);
                }
            });

            // weekly 알림 설정
            Switch weekly = (Switch) findViewById(R.id.weekly);
            weekly.setChecked(visualService.isActiveWeeklyNoti());

            weekly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    visualService.setWeeklyNoti(isChecked);

                }
            });

            // monthly 알림설정
            Switch monthly = (Switch) findViewById(R.id.monthly);
            monthly.setChecked(visualService.isActiveMonthlyNoti());
            monthly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    visualService.setMonthlyNoti(isChecked);

                }
            });

            IntentFilter filter = new IntentFilter();
            filter.addAction(ACTION_TRAN_POPUP);
            LocalBroadcastManager.getInstance(getApplicationContext()).registerReceiver(new AlarmReceiver(), filter);
        } catch (ParameterException e) {
            e.printStackTrace();
        }



//        Cursor cursor = getContentResolver().query(VisualContract.CATEGORY_PATH_URI, null, null, null, null);
//        if (cursor != null) {
//            cursor.moveToFirst();
//        }

    }

    /**
     * 1. 맨처음 가입 이후 파싱 진행 가능
     * 2. 가입 실패시
     * @param view
     */
    public void onSignUp(View view) {

        Cursor cursor = getContentResolver().query(VisualContract.MONTH_PATH_URI, null, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
        }

        try {
            visualService.signUp("123412", new OnResultListener() {
                @Override
                public void onResult(int signUpResult, String msg) {

                    switch (signUpResult) {
                        case Constants.SignupResult.SUCCESS: // 가입성공

                            break;

                        case Constants.SignupResult.FAIL: // 가입 실패

                            break;

                        case Constants.SignupResult.ALREADY_JOINED:// 이미 가입됨

                            break;

                    }
                }
            });

        } catch (ParameterException e) { // custId 올바르지 않은경우 custId.length() > 500
            e.printStackTrace();
        } catch (SecurityException e) { //sms, mms 권한이 필요합니다.
            e.printStackTrace();
        }
    }

    /**
     *
     * @param view
     */
    public void onWeb(View view) {

        try {
            if (ContextCompat.checkSelfPermission(MainActivity.this,
                    Manifest.permission.READ_SMS)
                    != PackageManager.PERMISSION_GRANTED) {

                // Should we show an explanation?
                if (ActivityCompat.shouldShowRequestPermissionRationale(MainActivity.this,
                        Manifest.permission.READ_SMS)) {



                } else {

                    ActivityCompat.requestPermissions(MainActivity.this,
                            new String[]{Manifest.permission.READ_SMS},
                            0);

                }
            } else {
                visualService.startVisual("1234", new OnResultListener() {
                    @Override
                    public void onResult(int signUpResult, String msg) {

                    }
                });
            }


        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        switch (requestCode) {
            case 0: {
                // If request is cancelled, the result arrays are empty.
                if (grantResults.length > 0
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                    try {
                        visualService.startVisual("1234", new OnResultListener() {
                            @Override
                            public void onResult(int signUpResult, String msg) {

                            }
                        });
                    } catch (ParameterException e) {
                        e.printStackTrace();
                    }
                    // permission was granted, yay! Do the
                    // contacts-related task you need to do.

                } else {

                    // permission denied, boo! Disable the
                    // functionality that depends on this permission.
                }
                return;
            }

        }
    }

}
