/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model;

import android.text.TextUtils;
import com.tenqube.visual_third.model.Company;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;
import tenqube.parser.model.Transaction;

public class TransactionPopupInfo
implements Serializable {
    private Transaction transaction;
    private Company company;

    public TransactionPopupInfo(Transaction transaction, Company company) {
        this.transaction = transaction;
        this.company = company;
    }

    public String getCompanyTitle() {
        return this.company == null ? "" : this.company.getCompanyTitle();
    }

    public String getCompanyAddress() {
        return this.company == null ? "" : this.company.getCompanyAddress();
    }

    public String getSpentDate() {
        return this.transaction == null ? "" : this.transaction.spentDate;
    }

    public String getPayment() {
        if (this.transaction == null) {
            return "";
        }
        String payment = this.transaction.cardName;
        if (!TextUtils.isEmpty((CharSequence)this.transaction.cardNum)) {
            payment = payment + " " + this.transaction.cardNum;
        }
        return payment;
    }

    public int getInstallmentCnt() {
        return this.transaction == null ? 1 : this.transaction.installmentCount;
    }

    public String getInstallmentStr() {
        int instCnt = this.getInstallmentCnt();
        return instCnt == 1 || instCnt == 0 ? "\uc77c\uc2dc\ubd88" : instCnt + "\uac1c\uc6d4";
    }

    public double getSpentMoney() {
        if (this.transaction == null) {
            return 0.0;
        }
        return this.transaction.spentMoney;
    }

    public String getSpentMoneyStr() {
        return Utils.threeComma(this.getSpentMoney());
    }
}

