/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tenqube.visual_third.core.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.PrefManager;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class AuthorizationInterceptor
implements Interceptor {
    private final PrefManager prefManager;
    private final VisualApi visualApi;

    AuthorizationInterceptor(PrefManager prefManager, VisualApi visualApi) {
        this.prefManager = prefManager;
        this.visualApi = visualApi;
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        String refreshToken;
        Response mainResponse = chain.proceed(chain.request());
        if (mainResponse.code() == 401 && !TextUtils.isEmpty((CharSequence)(refreshToken = this.prefManager.loadStringValue("TENQUBE_REFRESH_TOKEN", "")))) {
            try {
                this.visualApi.renewToken(refreshToken);
                Request mainRequest = chain.request();
                Request.Builder builder = mainRequest.newBuilder();
                builder.header("Authorization", this.prefManager.loadStringValue("TENQUBE_ACCESS_TOKEN", "")).method(mainRequest.method(), mainRequest.body());
                mainResponse = chain.proceed(builder.build());
            }
            catch (AuthException e) {
                e.printStackTrace();
            }
        }
        return mainResponse;
    }
}

