package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.exception.ParameterException;

public class VisualWebActivity extends Activity {

    public static final String ARG_PATH = "ARG_PATH";
    public static final String DETAIL_PATH = "detail";
    public static final String MAIN_PATH = "main";

    public static void startActivity(Context context, String path) throws ParameterException {

        if(DETAIL_PATH.equals(path) || MAIN_PATH.equals(path)) {
            throw new ParameterException("Path in ('detail', 'main')");
        }

        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        context.startActivity(intent);
    }

    private WebView webview;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        try {
            setContentView(R.layout.activity_visual_web);

            webview = findViewById(R.id.visual_web_view);

            webview.getSettings().setJavaScriptEnabled(true);

            webview.setWebChromeClient(new WebChromeClient() {
                public void onProgressChanged(WebView view, int progress) {
                }
            });

            webview.setWebViewClient(new WebViewClient() {
                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                }
            });

            webview.loadUrl("http://dev.kt-view.tenqube.kr//");
        } catch (Exception e) {
            finish();
        }

    }

}
