/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.text.TextUtils;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.AppExecutors;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jxl.CellView;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.Blank;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class ExcelManager {
    WritableCellFormat titleFormat;
    public static final String FILE_NAME = "ibk-visual.xls";
    private static ExcelManager mInstance = null;
    private Context mContext;
    private VisualRepository repository;
    private AppExecutors appExecutors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExcelManager getInstance(Context ctx) {
        Class<ExcelManager> clazz = ExcelManager.class;
        synchronized (ExcelManager.class) {
            if (mInstance == null) {
                mInstance = new ExcelManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public void destroy() {
        mInstance = null;
    }

    private ExcelManager(Context context) {
        this.mContext = context;
        this.repository = VisualRepository.getInstance(context);
        this.appExecutors = new AppExecutors();
        try {
            this.titleFormat = this.createTitleFormat();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File createFile() throws IOException {
        File deviceFile;
        File path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        if (!path.exists()) {
            path.mkdirs();
        }
        if (!(deviceFile = new File(path, FILE_NAME)).exists()) {
            deviceFile.createNewFile();
        }
        return deviceFile;
    }

    private WritableCellFormat createTitleFormat() throws Exception {
        WritableFont times10pt = new WritableFont(WritableFont.ARIAL, 10);
        WritableCellFormat titleFormat = new WritableCellFormat(times10pt);
        titleFormat.setWrap(false);
        titleFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
        titleFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.WHITE);
        return titleFormat;
    }

    private WritableCellFormat createNumberFormat() throws Exception {
        WritableFont times10pt = new WritableFont(WritableFont.ARIAL, 10);
        NumberFormat numberFormat = new NumberFormat("###,###");
        WritableCellFormat integerFormat = new WritableCellFormat(times10pt, (DisplayFormat)numberFormat);
        integerFormat.setWrap(false);
        integerFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
        integerFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.WHITE);
        return integerFormat;
    }

    private WritableCellFormat createDateTimeFormat() throws Exception {
        WritableFont times10pt = new WritableFont(WritableFont.ARIAL, 10);
        DateFormat userdatafmt = new DateFormat("yyyy-MM-DD hh:mm:ss");
        WritableCellFormat dataformat = new WritableCellFormat(times10pt, (DisplayFormat)userdatafmt);
        dataformat.setWrap(false);
        dataformat.setVerticalAlignment(VerticalAlignment.CENTRE);
        dataformat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.WHITE);
        return dataformat;
    }

    public void export(final Callback completion) {
        this.appExecutors.diskIO().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AssetManager am = ExcelManager.this.mContext.getAssets();
                File deviceFile = null;
                try {
                    InputStream inStream = am.open(ExcelManager.FILE_NAME);
                    Workbook tempWorkbook = Workbook.getWorkbook((InputStream)inStream);
                    deviceFile = ExcelManager.this.createFile();
                    WritableWorkbook writableWorkbook = Workbook.createWorkbook((File)deviceFile, (Workbook)tempWorkbook);
                    WritableSheet excelSheet = writableWorkbook.getSheet(0);
                    ExcelManager.this.addHeaders(excelSheet);
                    ArrayList<JoinedTransaction> transactions = ExcelManager.this.repository.loadJoinedTransactions();
                    int row = 1;
                    for (JoinedTransaction transaction : transactions) {
                        ExcelManager.this.addLines(excelSheet, transaction, row);
                        ++row;
                    }
                    writableWorkbook.write();
                    writableWorkbook.close();
                    File finalDeviceFile = deviceFile;
                    ExcelManager.this.appExecutors.mainThread().execute(new Runnable(finalDeviceFile){
                        final /* synthetic */ File val$finalDeviceFile;
                        {
                            this.val$finalDeviceFile = file;
                        }

                        @Override
                        public void run() {
                            completion.onCompleted(this.val$finalDeviceFile);
                        }
                    });
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        File finalDeviceFile = deviceFile;
                        ExcelManager.this.appExecutors.mainThread().execute(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Throwable throwable) {
                        File finalDeviceFile = deviceFile;
                        ExcelManager.this.appExecutors.mainThread().execute(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
            }
        });
    }

    private void addLabel(WritableSheet sheet, int column, int row, String s, WritableCellFormat titleFormat, CellView cv) {
        try {
            cv.setFormat((CellFormat)titleFormat);
            if (s == null || TextUtils.isEmpty((CharSequence)s)) {
                Blank blank = new Blank(column, row, (CellFormat)titleFormat);
                sheet.addCell((WritableCell)blank);
                sheet.setColumnView(row, cv);
            } else {
                Label label = new Label(column, row, s, (CellFormat)titleFormat);
                sheet.addCell((WritableCell)label);
                sheet.setColumnView(row, cv);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addNumber(WritableSheet sheet, int column, int row, int spentMoney, CellView cv, WritableCellFormat integerFormat) {
        try {
            cv.setFormat((CellFormat)integerFormat);
            Number number = new Number(column, row, (double)spentMoney, (CellFormat)integerFormat);
            sheet.addCell((WritableCell)number);
            sheet.setColumnView(row, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDate(WritableSheet sheet, int column, int row, Calendar s, WritableCellFormat titleFormat, CellView cv, WritableCellFormat dataformat) {
        try {
            if (s == null) {
                cv.setFormat((CellFormat)titleFormat);
                Blank blank = new Blank(column, row, (CellFormat)titleFormat);
                sheet.addCell((WritableCell)blank);
                sheet.setColumnView(row, cv);
            } else {
                Date now = s.getTime();
                cv.setFormat((CellFormat)dataformat);
                DateTime datetime = new DateTime(column, row, now, (CellFormat)dataformat);
                sheet.addCell((WritableCell)datetime);
                sheet.setColumnView(row, cv);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addHeaders(WritableSheet sheet) {
        int size = COLUMS.values().length;
        CellView cv = new CellView();
        cv.setAutosize(true);
        for (int column = 0; column < size; ++column) {
            this.addLabel(sheet, column, 0, COLUMS.values()[column].name(), this.titleFormat, cv);
        }
    }

    private void addLines(WritableSheet sheet, JoinedTransaction transaction, int row) {
        try {
            CellView cv = new CellView();
            cv.setAutosize(true);
            int size = COLUMS.values().length;
            block44: for (int column = 0; column < size; ++column) {
                switch (COLUMS.values()[column]) {
                    case id: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getId(), this.titleFormat, cv);
                        continue block44;
                    }
                    case identifier: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getIdentifier(), this.titleFormat, cv);
                        continue block44;
                    }
                    case cardId: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getCardId(), this.titleFormat, cv);
                        continue block44;
                    }
                    case userCategoryId: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getUserCategoryId(), this.titleFormat, cv);
                        continue block44;
                    }
                    case companyId: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getCompanyId(), this.titleFormat, cv);
                        continue block44;
                    }
                    case franchise: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getFranchise(), this.titleFormat, cv);
                        continue block44;
                    }
                    case code: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getCategoryCode(), this.titleFormat, cv);
                        continue block44;
                    }
                    case spentDate: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getSpentDate(), this.titleFormat, cv);
                        continue block44;
                    }
                    case spentMoney: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getSpentMoney(), this.titleFormat, cv);
                        continue block44;
                    }
                    case oriSpentMoney: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getOriSpentMoney(), this.titleFormat, cv);
                        continue block44;
                    }
                    case installmentCnt: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getInstallmentCnt(), this.titleFormat, cv);
                        continue block44;
                    }
                    case keyword: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getKeyword(), this.titleFormat, cv);
                        continue block44;
                    }
                    case repeatType: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getRepeatType(), this.titleFormat, cv);
                        continue block44;
                    }
                    case currency: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getCurrency(), this.titleFormat, cv);
                        continue block44;
                    }
                    case dwType: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getDwType(), this.titleFormat, cv);
                        continue block44;
                    }
                    case fullSms: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getFullSms(), this.titleFormat, cv);
                        continue block44;
                    }
                    case smsDate: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getSmsDate(), this.titleFormat, cv);
                        continue block44;
                    }
                    case smsType: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getSmsType(), this.titleFormat, cv);
                        continue block44;
                    }
                    case regId: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getRegId(), this.titleFormat, cv);
                        continue block44;
                    }
                    case isOffset: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().isOffset(), this.titleFormat, cv);
                        continue block44;
                    }
                    case isCustom: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().isCustom(), this.titleFormat, cv);
                        continue block44;
                    }
                    case isUserUpdate: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().isUserUpdate(), this.titleFormat, cv);
                        continue block44;
                    }
                    case isUpdateAll: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().isUpdateAll(), this.titleFormat, cv);
                        continue block44;
                    }
                    case memo: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getMemo(), this.titleFormat, cv);
                        continue block44;
                    }
                    case classCode: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getClassCode(), this.titleFormat, cv);
                        continue block44;
                    }
                    case isSynced: {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().isSynced(), this.titleFormat, cv);
                        continue block44;
                    }
                    case cardName: {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().getName(), this.titleFormat, cv);
                        continue block44;
                    }
                    case cardType: {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().getType(), this.titleFormat, cv);
                        continue block44;
                    }
                    case cardSubType: {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().getSubType(), this.titleFormat, cv);
                        continue block44;
                    }
                    case cardChangeName: {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().getChangeName(), this.titleFormat, cv);
                        continue block44;
                    }
                    case cardChangeType: {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().getChangeType(), this.titleFormat, cv);
                        continue block44;
                    }
                    case cardChangeSubType: {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().getChangeSubType(), this.titleFormat, cv);
                        continue block44;
                    }
                    case billingDay: {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().getBillingDay(), this.titleFormat, cv);
                        continue block44;
                    }
                    case balance: {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().getBalance(), this.titleFormat, cv);
                        continue block44;
                    }
                    case cardMemo: {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().getMemo(), this.titleFormat, cv);
                        continue block44;
                    }
                    case cardIsExcept: {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().isExcept(), this.titleFormat, cv);
                        continue block44;
                    }
                    case cateIsExcept: {
                        this.addLabel(sheet, column, row, "" + transaction.getUserCategory().isExcept(), this.titleFormat, cv);
                        continue block44;
                    }
                    case large: {
                        this.addLabel(sheet, column, row, "" + transaction.getCategory().getLarge(), this.titleFormat, cv);
                        continue block44;
                    }
                    case medium: {
                        this.addLabel(sheet, column, row, "" + transaction.getCategory().getMedium(), this.titleFormat, cv);
                        continue block44;
                    }
                    case small: {
                        this.addLabel(sheet, column, row, "" + transaction.getCategory().getSmall(), this.titleFormat, cv);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface Callback {
        public void onCompleted(File var1);
    }

    static enum COLUMS {
        id,
        identifier,
        cardId,
        userCategoryId,
        companyId,
        franchise,
        code,
        spentDate,
        spentMoney,
        oriSpentMoney,
        installmentCnt,
        keyword,
        repeatType,
        currency,
        dwType,
        fullSms,
        smsDate,
        smsType,
        regId,
        isOffset,
        isCustom,
        isUserUpdate,
        isUpdateAll,
        memo,
        classCode,
        isSynced,
        cardName,
        cardType,
        cardSubType,
        cardChangeName,
        cardChangeType,
        cardChangeSubType,
        billingDay,
        balance,
        cardMemo,
        cardIsExcept,
        cateIsExcept,
        large,
        medium,
        small;

    }
}

