/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class FontUtil {
    public static final String BOLD = "NotoSansKR-Bold-Hestia.otf";
    public static final String LIGHT = "NotoSansKR-Light-Hestia.otf";
    public static final String MEDIUM = "NotoSansKR-Medium-Hestia.otf";
    public static final String REGULAR = "NotoSans-Regular.otf";
    public static final String THIN = "NotoSansKR-Thin-Hestia.otf";

    public static void setAllTextView(View view) {
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            for (int i = parent.getChildCount() - 1; i >= 0; --i) {
                View child = parent.getChildAt(i);
                if (child instanceof ViewGroup) {
                    FontUtil.setAllTextView((View)((ViewGroup)child));
                    continue;
                }
                if (!(child instanceof TextView)) continue;
                Typeface typeface = FontUtil.getFont(parent.getContext());
                if (typeface == null) break;
                ((TextView)child).setTypeface(typeface);
            }
        }
    }

    public static Typeface getFont(Context context) {
        try {
            return Typeface.createFromAsset((AssetManager)context.getAssets(), (String)REGULAR);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setFont(Context context, TextView textView, String font) {
        try {
            Typeface tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)font);
            textView.setTypeface(tf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

