/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.util.permission;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.tenqube.visual_third.util.permission.AfterPermissionGranted;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PermissionUtil {
    public static final String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final String[] PERMISSIONS_SMS = new String[]{"android.permission.READ_SMS", "android.permission.RECEIVE_SMS"};
    private static final String TAG = "EasyPermissions";
    private static final String DIALOG_TAG = "RationaleDialogFragmentCompat";

    public static boolean hasPermissions(@NonNull Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        for (String perm : perms) {
            boolean hasPerm;
            boolean bl = hasPerm = ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0;
            if (hasPerm) continue;
            return false;
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    public static void requestPermissions(@NonNull Activity activity, int requestCode, String ... perms) {
        if (PermissionUtil.hasPermissions((Context)activity, perms)) {
            PermissionUtil.notifyAlreadyHasPermissions(activity, requestCode, perms);
            return;
        }
        ActivityCompat.requestPermissions((Activity)activity, (String[])perms, (int)requestCode);
    }

    @SuppressLint(value={"NewApi"})
    public static void requestPermissions(@NonNull androidx.fragment.app.Fragment fragment, int requestCode, String ... perms) {
        if (PermissionUtil.hasPermissions(fragment.getContext(), perms)) {
            PermissionUtil.notifyAlreadyHasPermissions(fragment, requestCode, perms);
            return;
        }
        fragment.requestPermissions(perms, requestCode);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=11)
    public static void requestPermissions(@NonNull Fragment fragment, int requestCode, String ... perms) {
        if (PermissionUtil.hasPermissions((Context)fragment.getActivity(), perms)) {
            PermissionUtil.notifyAlreadyHasPermissions(fragment, requestCode, perms);
            return;
        }
        fragment.requestPermissions(perms, requestCode);
    }

    public static void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults, Object ... receivers) {
        ArrayList<String> granted = new ArrayList<String>();
        ArrayList<String> denied = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String perm = permissions[i];
            if (grantResults[i] == 0) {
                granted.add(perm);
                continue;
            }
            denied.add(perm);
        }
        for (Object object : receivers) {
            if (!granted.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsGranted(requestCode, granted);
            }
            if (!denied.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsDenied(requestCode, denied);
            }
            if (granted.isEmpty() || !denied.isEmpty()) continue;
            PermissionUtil.runAnnotatedMethods(object, requestCode);
        }
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Activity activity, @NonNull List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (!PermissionUtil.permissionPermanentlyDenied(activity, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull androidx.fragment.app.Fragment fragment, @NonNull List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (!PermissionUtil.permissionPermanentlyDenied(fragment, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(api=23)
    public static boolean somePermissionPermanentlyDenied(@NonNull Fragment fragment, @NonNull List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (!PermissionUtil.permissionPermanentlyDenied(fragment, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    public static boolean permissionPermanentlyDenied(@NonNull Activity activity, @NonNull String deniedPermission) {
        return !PermissionUtil.shouldShowRequestPermissionRationale(activity, deniedPermission);
    }

    public static boolean permissionPermanentlyDenied(@NonNull androidx.fragment.app.Fragment fragment, @NonNull String deniedPermission) {
        return !PermissionUtil.shouldShowRequestPermissionRationale(fragment, deniedPermission);
    }

    @RequiresApi(api=23)
    public static boolean permissionPermanentlyDenied(@NonNull Fragment fragment, @NonNull String deniedPermission) {
        return !PermissionUtil.shouldShowRequestPermissionRationale(fragment, deniedPermission);
    }

    private static void notifyAlreadyHasPermissions(Object object, int requestCode, @NonNull String[] perms) {
        int[] grantResults = new int[perms.length];
        for (int i = 0; i < perms.length; ++i) {
            grantResults[i] = 0;
        }
        PermissionUtil.onRequestPermissionsResult(requestCode, perms, grantResults, object);
    }

    private static boolean shouldShowRationale(@NonNull Object object, @NonNull String[] perms) {
        boolean shouldShowRationale = false;
        for (String perm : perms) {
            shouldShowRationale = shouldShowRationale || PermissionUtil.shouldShowRequestPermissionRationale(object, perm);
        }
        return shouldShowRationale;
    }

    private static boolean shouldShowRequestPermissionRationale(@NonNull Object object, @NonNull String perm) {
        if (object instanceof Activity) {
            return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)object), (String)perm);
        }
        if (object instanceof androidx.fragment.app.Fragment) {
            return ((androidx.fragment.app.Fragment)object).shouldShowRequestPermissionRationale(perm);
        }
        if (object instanceof Fragment) {
            if (Build.VERSION.SDK_INT >= 23) {
                return ((Fragment)object).shouldShowRequestPermissionRationale(perm);
            }
            throw new IllegalArgumentException("Target SDK needs to be greater than 23 if caller is android.app.Fragment");
        }
        throw new IllegalArgumentException("Object was neither an Activity nor a Fragment.");
    }

    private static void runAnnotatedMethods(@NonNull Object object, int requestCode) {
        Class<?> clazz = object.getClass();
        if (PermissionUtil.isUsingAndroidAnnotations(object)) {
            clazz = clazz.getSuperclass();
        }
        for (Method method : clazz.getDeclaredMethods()) {
            AfterPermissionGranted ann;
            if (!method.isAnnotationPresent(AfterPermissionGranted.class) || (ann = method.getAnnotation(AfterPermissionGranted.class)).value() != requestCode) continue;
            if (method.getParameterTypes().length > 0) {
                throw new RuntimeException("Cannot execute method " + method.getName() + " because it is non-void method and/or has input parameters.");
            }
            try {
                method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"runDefaultMethod:IllegalAccessException", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)"runDefaultMethod:InvocationTargetException", (Throwable)e);
            }
            catch (SecurityException e) {
                Log.e((String)TAG, (String)"runDefaultMethod:SecurityException", (Throwable)e);
            }
        }
    }

    private static boolean isUsingAndroidAnnotations(@NonNull Object object) {
        if (!object.getClass().getSimpleName().endsWith("_")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("org.androidannotations.api.view.HasViews");
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean shouldRequestOverlayPermission(Context context) {
        return Build.VERSION.SDK_INT >= 28 && !Settings.canDrawOverlays((Context)context.getApplicationContext());
    }

    public static interface PermissionCallbacks
    extends ActivityCompat.OnRequestPermissionsResultCallback {
        public void onPermissionsGranted(int var1, List<String> var2);

        public void onPermissionsDenied(int var1, List<String> var2);
    }
}

