/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.cardview.widget.CardView;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.tenqube.visual_third.ActivityCallback;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.migration.Migration;
import com.tenqube.visual_third.manager.migration.MigrationCallback;
import com.tenqube.visual_third.manager.sms.SmsLoader;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.parser.SyncHolder;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.ResourceRepository;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.VisualWebView;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.util.permission.AfterPermissionGranted;
import com.tenqube.visual_third.util.permission.PermissionUtil;
import com.tenqube.visual_third.web.ActionImpl;
import com.tenqube.visual_third.web.Completion;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.VisualInterface;
import java.lang.reflect.Field;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import tenqube.parser.Parser;
import tenqube.parser.core.ParserService;

public class VisualWebActivity
extends AppCompatActivity
implements TimePickerFragment.Callback,
DatePickerFragment.Callback,
PermissionUtil.PermissionCallbacks,
ActivityCallback {
    public static final String ARG_PATH = "ARG_PATH";
    public static final String ACTION_BROADCAST_TRANSACTION = "ACTION_BROADCAST_TRANSACTION";
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final int NOTIFICATION_REQUEST_CODE = 10;
    public static final int VISUAL_REQUEST_CODE = 512;
    public static final int PERMISSION_REQUEST_CODE = 0;
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    public static final int SYNC_ERROR = 14;
    public static final int SYNC_PROGRESS = 15;
    public static final int SHOW_SYNC_PROGRESS_BAR = 16;
    public static final int CLOSE_SYNC_PROGRESS_BAR = 17;
    private BulkLoader bulkLoader;
    @Nullable
    private VisualRepository repository;
    @Nullable
    private ResourceRepository resourceRepository;
    private VisualAlarmManager alarmManager;
    private Migration migration;
    private boolean isPageLoaded;
    private String mFailingUrl;
    private String baseUrl = "";
    private String webUrl = "";
    private String path;
    @Nullable
    private VisualWebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private VisualInterface.Action actionInterface;
    private SwipeRefreshLayout swipeRefreshLayout;
    @Nullable
    private LinearLayout errorView;
    private boolean isError;
    private PrefManager prefManager;
    private boolean isLoading;
    private long startTime;
    private FrameLayout webContainer;
    private CardView adContainer;
    private boolean isActivityFirst;
    private BottomDialog bottomDialog;
    private BroadcastReceiver transactionReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                Utils.LOGD("transactionReceiver", "start");
                final int tranId = intent.getIntExtra("tranId", 0);
                VisualWebActivity.this.webview.post(new Runnable(){

                    @Override
                    public void run() {
                        if (tranId != 0) {
                            VisualWebActivity.this.webview.loadUrl("javascript:window.onTransactionReceived(" + tranId + ");");
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            try {
                switch (msg.what) {
                    case 11: {
                        Bundle bundle;
                        if (VisualWebActivity.this.webview != null && (bundle = msg.getData()) != null) {
                            VisualWebActivity.this.webview.loadUrl("javascript:window.onProgress(" + bundle.getInt("now") + "," + bundle.getInt("total") + ");");
                        }
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 12: {
                        VisualWebActivity.this.isLoading = true;
                        Utils.LOGD("BulkHandler", "startBulk handleMessage SHOW_PROGRESS_BAR");
                        VisualWebActivity.this.loadProgressUrl(Constants.ProgressType.BULK);
                        break;
                    }
                    case 16: {
                        VisualWebActivity.this.loadProgressUrl(Constants.ProgressType.SYNC);
                        VisualWebActivity.this.isLoading = true;
                        break;
                    }
                    case 17: {
                        VisualWebActivity.this.isLoading = false;
                        break;
                    }
                    case 14: {
                        Utils.LOGD("BulkHandler", "onBulkFinish SYNC_ERROR");
                        VisualWebActivity.this.onSyncError();
                        VisualWebActivity.this.onBulkFinish(false, false);
                        break;
                    }
                    case 10: {
                        Utils.LOGD("BulkHandler", "onBulkFinish FINISH");
                        VisualWebActivity.this.onBulkFinish(true, true);
                        break;
                    }
                    default: {
                        Utils.LOGD("BulkHandler", "onBulkFinish DEFAULT " + msg.what);
                        VisualWebActivity.this.onBulkFinish(false, true);
                    }
                }
            }
            catch (Exception e) {
                Utils.LOGD("BulkHandler", "Exception  " + e.toString());
                VisualWebActivity.this.onBulkFinish(false, true);
            }
            return false;
        }
    });
    boolean isBulkFinished = false;
    public static final int STORAGE = 1;
    public Completion<Boolean> completion;

    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface", "SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.isActivityFirst = true;
            Utils.LOGD("onCreate", "start VisualActivity");
            AnalysisServiceImpl.shouldRefresh = true;
            this.startTime = System.currentTimeMillis();
            this.checkSDK();
            this.setContentView(R.layout.activity_visual_web);
            this.parseArg();
            this.createInstances();
            this.setUpWebContainer();
            this.setupSwipeRefreshView();
            this.setupErrorView();
            this.setupWebView();
            this.start();
        }
        catch (Exception e) {
            Utils.LOGD("onCreate", "start VisualActivity" + e.toString());
            this.finish();
        }
    }

    private void checkSDK() throws Exception {
        Utils.LOGD("checkSDK", "start");
        if (Utils.isSDKDisabled(this.getApplicationContext())) {
            throw new Exception("SDK disabled");
        }
    }

    private void parseArg() {
        Utils.LOGD("parseArg", "start");
        this.path = this.getIntent().getStringExtra(ARG_PATH);
        if (this.path == null) {
            this.path = "";
        }
    }

    private void setUpWebContainer() {
        Utils.LOGD("setUpWebContainer", "start");
        this.webContainer = (FrameLayout)this.findViewById(R.id.web_container);
    }

    private void createInstances() {
        Utils.LOGD("createInstances", "start");
        this.prefManager = PrefManager.getInstance(this.getApplicationContext());
        this.repository = RepositoryHolder.getInstance(this.getApplicationContext()).getVisualRepository();
        this.resourceRepository = RepositoryHolder.getInstance(this.getApplicationContext()).getResourceRepository();
        this.alarmManager = VisualAlarmManager.getInstance(this.getApplicationContext());
        this.migration = new Migration(this.prefManager, this.repository, new SmsLoader(this.getApplicationContext()), (Parser)ParserService.getInstance((Context)this.getApplicationContext()), new AppExecutors());
    }

    private void setupSwipeRefreshView() {
        Utils.LOGD("setupSwipeRefreshView", "start");
        this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_refresh_layout);
        this.swipeRefreshLayout.setEnabled(false);
        this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                VisualWebActivity.this.swipeRefreshLayout.setRefreshing(false);
                AnalysisServiceImpl.shouldRefresh = true;
                if (VisualWebActivity.this.webview != null) {
                    VisualWebActivity.this.webview.reload();
                }
            }
        });
    }

    private void setupErrorView() {
        Utils.LOGD("setupErrorView", "start");
        this.errorView = (LinearLayout)this.findViewById(R.id.error_container);
        this.errorView.setVisibility(8);
        this.findViewById(R.id.retry).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VisualWebActivity.this.retry();
            }
        });
    }

    private void setupWebView() {
        Utils.LOGD("setupWebView", "start");
        this.webview = (VisualWebView)this.findViewById(R.id.visual2_web_view);
        this.webview.setLayerType(2, null);
        this.webview.playSoundEffect(0);
        this.errorInterface = new ErrorImpl(this, this.webview);
        this.logInterface = new LogImpl(this, this.webview, this.errorInterface);
        this.bottomDialog = new BottomDialog((Activity)this);
        this.repoInterface = new RepoImpl(this, this.webview, this.errorInterface, this.repository, new AnalysisServiceImpl(this.getApplicationContext(), ""), this.alarmManager);
        this.uiInterface = new UiImpl(this, this.webview, this.errorInterface, this.bottomDialog, AdManager.getInstance(this.getApplicationContext()));
        this.systemInterface = new SystemImpl(this, this.webview, this.errorInterface);
        this.actionInterface = new ActionImpl(this, this.webview);
        this.webview.setBackgroundColor(0);
        this.webview.addJavascriptInterface(this.errorInterface, "visualError");
        this.webview.addJavascriptInterface(this.repoInterface, "visualRepo");
        this.webview.addJavascriptInterface(this.uiInterface, "visualUI");
        this.webview.addJavascriptInterface(this.systemInterface, "visualSystem");
        this.webview.addJavascriptInterface(this.logInterface, "visualLog");
        this.webview.addJavascriptInterface(this.actionInterface, "visualAction");
        this.webview.getSettings().setJavaScriptEnabled(true);
        this.webview.getSettings().setDomStorageEnabled(true);
        this.webview.getSettings().setDatabaseEnabled(true);
        this.webview.getSettings().setLoadWithOverviewMode(true);
        this.webview.getSettings().setUseWideViewPort(true);
        this.webview.getSettings().setTextZoom(100);
        if (this.repository != null) {
            if (this.repository.isDev()) {
                this.webview.getSettings().setCacheMode(2);
                WebView.setWebContentsDebuggingEnabled((boolean)true);
            } else {
                WebView.setWebContentsDebuggingEnabled((boolean)false);
            }
        }
        this.webview.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                Utils.LOGD("onProgressChanged", "newProgress: " + newProgress + "");
                super.onProgressChanged(view, newProgress);
            }

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                Utils.LOGD("onConsoleMessage", "consoleMessage: " + consoleMessage.message() + "");
                return super.onConsoleMessage(consoleMessage);
            }
        });
        this.webview.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                Utils.LOGD("onReceivedError", "\uc218\ud589\uc2dc\uac04: " + (System.currentTimeMillis() - VisualWebActivity.this.startTime) / 1000L + "\ucd08");
                VisualWebActivity.this.isError = true;
                VisualWebActivity.this.mFailingUrl = failingUrl;
                VisualWebActivity.this.loadErrorUrl();
            }

            public void onPageFinished(WebView view, String url) {
                if (!VisualWebActivity.this.isError && VisualWebActivity.this.errorView != null) {
                    VisualWebActivity.this.errorView.setVisibility(8);
                }
                VisualWebActivity.this.isError = false;
                Utils.LOGD("onPageFinished", "\uc218\ud589\uc2dc\uac04: " + (System.currentTimeMillis() - VisualWebActivity.this.startTime) / 1000L + "\ucd08, url:" + url);
                super.onPageFinished(view, url);
            }
        });
    }

    private void start() {
        Utils.LOGD("start", "start");
        this.startVisual();
    }

    @Override
    public void addAd(View view) {
        Utils.LOGD("addAd", "start");
        try {
            this.webContainer.addView((View)this.createCardView(view));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CardView createCardView(View view) {
        Utils.LOGD("createCardView", "start");
        this.adContainer = new CardView((Context)this);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.setMargins(Utils.dpToPx(10), Utils.dpToPx(16), Utils.dpToPx(10), Utils.dpToPx(16));
        params.gravity = 80;
        this.adContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        this.adContainer.setRadius((float)Utils.dpToPx(13));
        this.adContainer.setCardBackgroundColor(Color.parseColor((String)"#00000000"));
        this.adContainer.addView(view);
        return this.adContainer;
    }

    @Override
    public void hideAd() {
        Utils.LOGD("hideAd", "start");
        try {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (VisualWebActivity.this.adContainer != null) {
                        VisualWebActivity.this.webContainer.removeView((View)VisualWebActivity.this.adContainer);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TransactionPopupInfo getPopUpInfo() {
        return null;
    }

    @Override
    public void setStatusBarColor(String color2) {
        Utils.LOGD("setStatusBarColor", "start");
        try {
            this.getWindow().setStatusBarColor(Color.parseColor((String)color2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startVisual() {
        Utils.LOGD("startVisual", "start");
        if (this.repository != null) {
            if (this.repository.shouldBulk()) {
                this.migration.saveMigratedVersion(1);
                this.loadProgressUrl(Constants.ProgressType.DEFAULT);
                this.startBulkParsing(true);
            } else {
                this.migration.card(new MigrationCallback(){

                    @Override
                    public void onStart() {
                        Utils.LOGD("migration", "start");
                        if (VisualWebActivity.this.webview != null) {
                            VisualWebActivity.this.loadProgressUrl(Constants.ProgressType.MIGRATION);
                        }
                    }

                    @Override
                    public void onProgress(int current, int total) {
                        Utils.LOGD("migration", "current" + current + "/ total" + total);
                        if (VisualWebActivity.this.webview != null) {
                            VisualWebActivity.this.webview.loadUrl("javascript:window.onProgress(" + current + "," + total + ");");
                        }
                    }

                    @Override
                    public void onCompleted() {
                        Utils.LOGD("migration", "onCompleted");
                        VisualWebActivity.this.loadUrl(VisualWebActivity.this.path);
                        VisualWebActivity.this.alarmManager.setAlarms();
                        if (VisualWebActivity.this.resourceRepository != null) {
                            VisualWebActivity.this.resourceRepository.sync();
                        }
                    }
                });
            }
        }
    }

    private void onSyncError() {
        Utils.LOGD("onSyncError", "start");
        if (this.isLoading && this.webview != null) {
            this.webview.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (VisualWebActivity.this.webview != null) {
                        VisualWebActivity.this.webview.loadUrl("javascript:window.onSyncError();");
                    }
                }
            }, 200L);
        }
    }

    private void onBulkFinish(boolean isSuccess, boolean shouldReload) {
        if (!this.isBulkFinished) {
            this.isBulkFinished = true;
            Utils.LOGD("BulkHandler", "onBulkFinish");
            this.isLoading = false;
            AnalysisServiceImpl.shouldRefresh = true;
            if (this.repository != null) {
                this.repository.saveBulk();
            }
            if (this.webview != null && shouldReload) {
                this.startVisual();
            }
            if (this.completion != null) {
                this.completion.onDataLoaded(isSuccess);
                this.completion = null;
            }
        }
    }

    private void startBulkParsing(final boolean isInit) {
        Utils.LOGD("startBulkParsing", "isInit:" + isInit);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (isInit) {
                        VisualWebActivity.this.handler.sendEmptyMessage(16);
                    } else {
                        VisualWebActivity.this.handler.sendEmptyMessage(12);
                    }
                    VisualWebActivity.this.bulkLoader = new BulkLoader(VisualWebActivity.this.getApplicationContext(), VisualWebActivity.this.handler, new BulkLoader.OnSmsLoadFinished(){

                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if (VisualWebActivity.this.handler != null) {
                                    VisualWebActivity.this.handler.sendEmptyMessage(10);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    VisualWebActivity.this.bulkLoader.doParsing(isInit);
                }
                catch (Exception e) {
                    VisualWebActivity.this.handler.sendEmptyMessage(13);
                }
            }
        }).start();
    }

    @Override
    public void changeStatusBarColor(String color2) {
        Utils.LOGD("changeStatusBarColor", "color:" + color2);
        try {
            this.getWindow().setStatusBarColor(Color.parseColor((String)color2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onPagedLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.isPageLoaded = true;
            }
        });
    }

    private void loadUrl(String path) {
        Utils.LOGD("loadUrl", "path:" + path);
        if (this.webview != null && !this.isLoading) {
            this.isPageLoaded = false;
            if (path == null) {
                path = "";
            }
            this.webUrl = this.prefManager.loadStringValue("TENQUBE_VISUAL_WEB_URL", "");
            if (TextUtils.isEmpty((CharSequence)this.webUrl)) {
                Utils.LOGD("finish", "TextUtils.isEmpty(webUrl)");
                this.finish();
                return;
            }
            this.baseUrl = WebViewHelper.getBaseUrl(this.webUrl);
            Utils.LOGD("loadUrl", "\uc218\ud589\uc2dc\uac04: " + (System.currentTimeMillis() - this.startTime) / 1000L + "\ucd08, url:" + this.baseUrl);
            this.webview.loadUrl(this.baseUrl + path);
        }
    }

    private void loadProgressUrl(Constants.ProgressType progressType) {
        Utils.LOGD("loadProgressUrl", "progressType:" + (Object)((Object)progressType));
        if (!this.isBulkFinished && this.webview != null) {
            this.isPageLoaded = false;
            this.baseUrl = WebViewHelper.getProgressUrl(this.prefManager, progressType);
            this.webview.loadUrl(this.baseUrl);
        }
    }

    private void loadErrorUrl() {
        Utils.LOGD("loadErrorUrl", "start");
        this.isPageLoaded = false;
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setEnabled(false);
        }
        if (this.errorView != null) {
            this.errorView.setVisibility(0);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 10) {
            boolean isEnabled = Utils.isNotiEnabled(this.getApplicationContext());
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("isNotiEnabled", isEnabled);
                String json = jsonObject.toString();
                if (this.systemInterface != null) {
                    this.systemInterface.onNotiCallback(json);
                }
            }
            catch (JSONException jSONException) {}
        } else if (requestCode == 0) {
            this.startVisual();
        }
    }

    public void onBackPressed() {
        Utils.LOGD("onBackPressed", "start");
        try {
            if (this.isLoading) {
                this.showParsingEndPopup();
            } else if (this.isPageLoaded && this.uiInterface != null) {
                this.uiInterface.onFinish();
            } else {
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }

    private void showParsingEndPopup() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)this.getString(R.string.visual_parsing_cancel_title)).setCancelable(false).setPositiveButton((CharSequence)this.getString(R.string.visual_parsing_close), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (VisualWebActivity.this.repository != null) {
                    VisualWebActivity.this.bulkLoader.cancelParseBulk();
                    VisualWebActivity.this.repository.initialize(new Callback<Boolean>(){

                        @Override
                        public void onDataLoaded(Boolean value) {
                            Utils.LOGD("showParsingEndPopup ", "setPositiveButton");
                            VisualWebActivity.this.isLoading = false;
                            VisualWebActivity.this.onBulkFinish(true, true);
                        }
                    });
                }
            }
        }).setNegativeButton((CharSequence)this.getString(R.string.visual_parsing_continue), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Utils.LOGD("showParsingEndPopup", "setNegativeButton");
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public void onResume() {
        super.onResume();
        Utils.LOGD("onBackPressed", "onResume");
        if (this.webview != null) {
            this.webview.onResume();
        }
        if (!this.isActivityFirst && this.webview != null) {
            this.webview.reload();
        }
        if (this.isActivityFirst) {
            this.isActivityFirst = false;
        }
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.transactionReceiver, new IntentFilter(ACTION_BROADCAST_TRANSACTION));
        if (this.repository != null) {
            this.repository.setVisualActive(true);
        }
        this.overridePendingTransition(0, 0);
    }

    private void showPopup() {
        Utils.LOGD("onBackPressed", "showPopup");
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)this.getString(R.string.dialog_title)).setMessage((CharSequence)this.getString(R.string.dialog_message)).setCancelable(false).setPositiveButton((CharSequence)this.getString(R.string.dialog_setting), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                VisualWebActivity.this.goToAppSetting();
                dialog.cancel();
                Utils.LOGD("showPopup setting", "finish");
                VisualWebActivity.this.finish();
            }
        }).setNegativeButton((CharSequence)this.getString(R.string.dialog_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Utils.LOGD("showPopup cancel", "finish");
                VisualWebActivity.this.finish();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public void goToAppSetting() {
        Utils.LOGD("goToAppSetting", "start");
        Uri packageUri = Uri.parse((String)("package:" + this.getApplicationContext().getPackageName()));
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", packageUri);
        intent.addFlags(0x10800000);
        this.startActivity(intent);
    }

    public void onPause() {
        super.onPause();
        if (this.webview != null) {
            this.webview.onPause();
        }
        Utils.LOGD("onPause", "start");
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.transactionReceiver);
        if (this.repository != null) {
            this.repository.setVisualActive(false);
        }
        this.overridePendingTransition(0, 0);
    }

    @Override
    public void onCalendar(String date, String callback) {
        Utils.LOGD("onCalendar", "date" + date + "callback" + callback);
        this.uiInterface.onCalendar(date, callback);
    }

    @Override
    public void onScrollChanged(int pos) {
    }

    @Override
    public void setRefreshEnabled(final boolean enabled) {
        this.swipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.swipeRefreshLayout.setEnabled(enabled);
            }
        });
    }

    @Override
    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.loadUrl(VisualWebActivity.this.mFailingUrl);
                }
            });
        }
    }

    @Override
    public void exportExcel(Completion<Boolean> completion) {
        this.completion = completion;
        this.exportExcel();
    }

    @Override
    public Context getContext() {
        return this.getApplicationContext();
    }

    @Override
    public AppCompatActivity getActivity() {
        return this;
    }

    @Override
    public void restore(Completion<Boolean> completion) {
        this.completion = completion;
        this.startBulkParsing(false);
    }

    @AfterPermissionGranted(value=1)
    public void exportExcel() {
        if (!PermissionUtil.hasPermissions((Context)this, PermissionUtil.PERMISSIONS_STORAGE)) {
            PermissionUtil.requestPermissions((Activity)this, 1, PermissionUtil.PERMISSIONS_STORAGE);
        }
    }

    @Override
    public void onPermissionsGranted(int requestCode, List<String> list) {
        if (requestCode == 1) {
            this.exportExcel();
        }
    }

    @Override
    public void onPermissionsDenied(int requestCode, List<String> list) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\uc5d1\uc140 \ud30c\uc77c \ub0b4\ubcf4\ub0b4\uae30\ub97c \uc704\ud574 \uc678\ubd80 \uc800\uc7a5\uc18c\uc5d0 \ub300\ud55c \uad8c\ud55c\uc774 \ud544\uc694\ud569\ub2c8\ub2e4. \uad8c\ud55c\uc774 \uc5c6\ub294 \uacbd\uc6b0 \uc5d1\uc140 \ud30c\uc77c \ub0b4\ubcf4\ub0b4\uae30 \uc0ac\uc6a9\uc774 \ubd88\uac00\ud569\ub2c8\ub2e4.", (int)0).show();
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    public static void startActivity(Activity activity, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)SecretKeyManager.getInstance((Context)activity).getKey("TENQUBE_VISUAL_ACCESS_TOKEN"))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent((Context)activity, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(0x4020000);
        activity.startActivityForResult(intent, 512);
    }

    public static void startActivity(Context context, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)SecretKeyManager.getInstance(context).getKey("TENQUBE_VISUAL_ACCESS_TOKEN"))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(335675392);
        context.startActivity(intent);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        Utils.LOGD("onRestoreInstanceState", "");
        try {
            if (PermissionUtil.hasPermissions((Context)this, PermissionUtil.PERMISSIONS_SMS)) {
                Utils.LOGD("onRestoreInstanceState", "finish");
                this.finish();
            } else {
                this.showPopup();
            }
            super.onRestoreInstanceState(savedInstanceState);
        }
        catch (Exception e) {
            Utils.LOGD("onRestoreInstanceState", "exception" + e.toString());
            this.finish();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Utils.LOGD("onConfigurationChanged", "");
        super.onConfigurationChanged(newConfig);
        Utils.LOGD("onConfigurationChanged", "finish");
        this.finish();
    }

    protected void onDestroy() {
        Utils.LOGD("onDestroy", "");
        this.destroyWebView();
        this.destroy();
        super.onDestroy();
        VisualWebActivity.fixInputMethod(this.getApplicationContext());
    }

    private void destroyWebView() {
        if (this.webview != null) {
            this.webview.removeAllViews();
            this.webview.getSettings().setJavaScriptEnabled(false);
            this.webview.removeJavascriptInterface("visualError");
            this.webview.removeJavascriptInterface("visualRepo");
            this.webview.removeJavascriptInterface("visualUI");
            this.webview.removeJavascriptInterface("visualSystem");
            this.webview.removeJavascriptInterface("visualLog");
            this.webview.removeJavascriptInterface("visualAction");
        }
    }

    public static void fixInputMethod(Context context) {
        Field[] declaredFields;
        if (context == null) {
            return;
        }
        InputMethodManager inputMethodManager = null;
        try {
            inputMethodManager = (InputMethodManager)context.getApplicationContext().getSystemService("input_method");
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        if (inputMethodManager == null) {
            return;
        }
        for (Field declaredField : declaredFields = inputMethodManager.getClass().getDeclaredFields()) {
            try {
                Object obj;
                if (!declaredField.isAccessible()) {
                    declaredField.setAccessible(true);
                }
                if ((obj = declaredField.get(inputMethodManager)) == null || !(obj instanceof View)) continue;
                declaredField.set(inputMethodManager, null);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    private void destroy() {
        SyncHolder.getInstance().setSyncService(null);
        if (this.bulkLoader != null) {
            this.bulkLoader.cancelParseBulk();
        }
        this.bulkLoader = null;
        this.alarmManager = null;
        this.repoInterface = null;
        this.uiInterface = null;
        this.systemInterface = null;
        this.errorInterface = null;
        this.logInterface = null;
        this.actionInterface = null;
        this.swipeRefreshLayout = null;
        this.errorView = null;
        this.prefManager = null;
        this.webContainer = null;
        this.adContainer = null;
        this.bottomDialog = null;
        this.webview = null;
    }
}

