/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.parser;

import android.text.TextUtils;
import com.tenqube.visual_third.exception.ParameterException;
import java.io.Serializable;

public class Transaction
implements Serializable {
    private final tenqube.parser.model.Transaction parsedTransaction;
    private int cardId;
    private int userCateId;
    private double spentMoney;

    public Transaction(tenqube.parser.model.Transaction parsedTransaction) throws ParameterException {
        if (parsedTransaction == null) {
            throw new ParameterException("parsedTransaction is empty");
        }
        this.parsedTransaction = parsedTransaction;
    }

    public String getCardName() {
        String cardNum;
        String cardName = this.parsedTransaction.cardName;
        if (cardName == null) {
            cardName = "";
        }
        if ((cardNum = this.parsedTransaction.cardNum) == null) {
            cardNum = "";
        } else if (!TextUtils.isEmpty((CharSequence)(cardNum = cardNum.replace("(", "").replace(")", "")))) {
            cardNum = "(" + cardNum + ")";
        }
        return cardName + cardNum;
    }

    public void setCardId(int cardId) {
        this.cardId = cardId;
    }

    public void setUserCateId(int userCateId) {
        this.userCateId = userCateId;
    }

    public void setSpentMoney(double spentMoney) {
        this.spentMoney = spentMoney;
    }

    public tenqube.parser.model.Transaction getParsedTransaction() {
        return this.parsedTransaction;
    }

    public int getCardId() {
        return this.cardId;
    }

    public int getUserCateId() {
        return this.userCateId;
    }

    public double getSpentMoney() {
        return this.spentMoney;
    }

    public String getCategoryCode() {
        String categoryCode = "" + this.parsedTransaction.categoryCode;
        if (categoryCode.length() == 2) {
            categoryCode = categoryCode + "1010";
        }
        return categoryCode;
    }
}

