/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.repository;

import android.content.Context;
import androidx.annotation.Nullable;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.dao.AdvertisementDao;
import com.tenqube.visual_third.db.dao.CardDao;
import com.tenqube.visual_third.db.dao.CategoryDao;
import com.tenqube.visual_third.db.dao.ContentsDao;
import com.tenqube.visual_third.db.dao.CurrencyDao;
import com.tenqube.visual_third.db.dao.NotificationAppDao;
import com.tenqube.visual_third.db.dao.NotificationDao;
import com.tenqube.visual_third.db.dao.SenderTransactionDao;
import com.tenqube.visual_third.db.dao.TransactionDao;
import com.tenqube.visual_third.db.dao.UserCategoryDao;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import com.tenqube.visual_third.manager.SignatureManager;
import com.tenqube.visual_third.parser.executor.BulkExecutor;
import com.tenqube.visual_third.repository.AnalysisRepository;
import com.tenqube.visual_third.repository.ResourceRepository;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.VisualInjection;
import tenqube.parser.core.ParserService;

public class RepositoryHolder {
    private Context context;
    private BulkExecutor bulkExecutor;
    private VisualRepository visualRepository;
    @Nullable
    private ResourceRepository resourceRepository;
    private AnalysisRepository analysisRepository;
    private static RepositoryHolder mInstance;
    private Db db;
    private AppExecutors appExecutor;
    private PrefManager prefManager;
    private NotificationAppDao notificationAppDao;
    private AdvertisementDao advertisementDao;
    private NotificationDao notificationDao;
    private CategoryDao categoryDao;
    private ContentsDao contentsDao;
    private SecretKeyManager secretKeyManager;
    private SignatureManager signatureManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryHolder getInstance(Context context) {
        Class<RepositoryHolder> clazz = RepositoryHolder.class;
        synchronized (RepositoryHolder.class) {
            if (mInstance == null) {
                mInstance = new RepositoryHolder(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private RepositoryHolder(Context context) {
        this.context = context;
        this.prefManager = VisualInjection.providePrefManager(context);
        this.db = VisualInjection.provideDb(context);
        this.appExecutor = VisualInjection.provideAppExecutors();
        this.secretKeyManager = VisualInjection.provideSecretKeyManager(context);
        this.notificationAppDao = VisualInjection.provideNotificationAppDao(this.db);
        this.advertisementDao = VisualInjection.provideAdvertisementDao(this.db);
        this.notificationDao = VisualInjection.provideNotificationDao(this.db);
        CurrencyDao currencyDao = VisualInjection.provideCurrencyDao(this.db);
        UserCategoryDao userCategoryDao = VisualInjection.provideUserCategoryDao(this.db);
        TransactionDao transactionDao = VisualInjection.provideTransactionDao(this.db);
        this.categoryDao = VisualInjection.provideCategoryDao(this.db);
        CardDao cardDao = VisualInjection.provideCardDao(this.db);
        SenderTransactionDao senderTransactionDao = VisualInjection.provideSenderTransactionDao(this.db);
        this.contentsDao = VisualInjection.provideContentsDao(this.db);
        this.bulkExecutor = BulkExecutor.getInstance(context);
        this.visualRepository = VisualInjection.provideVisualRepository(context, this.prefManager, senderTransactionDao, cardDao, this.categoryDao, transactionDao, userCategoryDao, currencyDao, this.notificationDao, this.advertisementDao, this.notificationAppDao, this.appExecutor, this.secretKeyManager);
        ParserService parserService = VisualInjection.provideParserService(context);
        SignatureManager signatureManager = VisualInjection.provideSignatureManager();
        this.resourceRepository = VisualInjection.provideResourceRepository(this.prefManager, parserService, this.appExecutor, this.notificationAppDao, this.categoryDao, this.notificationDao, this.contentsDao, signatureManager);
        this.analysisRepository = VisualInjection.provideAnalysisRepository(this.contentsDao);
    }

    public VisualRepository getVisualRepository() {
        return this.visualRepository;
    }

    public ResourceRepository getResourceRepository() {
        return this.resourceRepository;
    }

    public AnalysisRepository getAnalysisRepository() {
        return this.analysisRepository;
    }

    public BulkExecutor getBulkExecutor() {
        return this.bulkExecutor;
    }
}

