package com.tenqube.visual_third;

import android.content.Context;
import android.view.View;

import androidx.appcompat.app.AppCompatActivity;

import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.web.Completion;

public interface ActivityCallback {

    void changeStatusBarColor(String color);

    void exportExcel(Completion<Boolean> callback);

    Context getContext();

    AppCompatActivity getActivity();

    void onPagedLoaded();

    void onScrollChanged(int pos);

    void reload();

    void retry();

    void setRefreshEnabled(boolean enabled);

    void addAd(View view);

    void hideAd();

    TransactionPopupInfo getPopUpInfo();

    void setStatusBarColor(String color);

    void restore(Completion<Boolean> callback);

}
